/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.audit.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.Enumeration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Config {
    private static final Logger logger = LoggerFactory.getLogger(Config.class);
    private String localIP;
    private String dockerId = "";
    private static final int CGROUP_FILE_LENGTH = 50;
    private static final int DOCKERID_LENGTH = 10;

    public void init() {
        this.initIP();
        this.initDockerId();
    }

    public void setLocalIP(String localIP) {
        this.localIP = localIP;
    }

    public String getLocalIP() {
        return this.localIP;
    }

    public String getDockerId() {
        return this.dockerId;
    }

    private void initIP() {
        if (this.localIP != null) {
            return;
        }
        try {
            Enumeration<NetworkInterface> en = NetworkInterface.getNetworkInterfaces();
            while (en.hasMoreElements()) {
                NetworkInterface intf = en.nextElement();
                String name = intf.getName();
                if (name.contains("docker") || name.contains("lo")) continue;
                Enumeration<InetAddress> enumIpAddr = intf.getInetAddresses();
                while (enumIpAddr.hasMoreElements()) {
                    String ipaddress;
                    InetAddress inetAddress = enumIpAddr.nextElement();
                    if (inetAddress.isLoopbackAddress() || (ipaddress = inetAddress.getHostAddress()).contains("::") || ipaddress.contains("0:0:") || ipaddress.contains("fe80")) continue;
                    this.localIP = ipaddress;
                }
            }
        }
        catch (SocketException ex) {
            this.localIP = "127.0.0.1";
            return;
        }
    }

    private void initDockerId() {
        File file = new File("/proc/self/cgroup");
        if (!file.exists()) {
            return;
        }
        try (BufferedReader in = new BufferedReader(new FileReader("/proc/self/cgroup"));){
            String dockerID = in.readLine();
            if (dockerID == null || dockerID.length() < 50) {
                in.close();
                return;
            }
            this.dockerId = dockerID.substring(dockerID.length() - 10);
            in.close();
        }
        catch (Exception ex) {
            logger.error(ex.toString());
        }
    }
}

