/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.tubemq.server.broker.msgstore.disk;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.inlong.tubemq.server.broker.msgstore.disk.Segment;
import org.apache.inlong.tubemq.server.broker.msgstore.disk.SegmentList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileSegmentList
implements SegmentList {
    private static final Logger logger = LoggerFactory.getLogger(FileSegmentList.class);
    private final AtomicReference<Segment[]> segmentList = new AtomicReference();

    public FileSegmentList(Segment[] s) {
        this.segmentList.set(s);
    }

    public FileSegmentList() {
        this.segmentList.set(new Segment[0]);
    }

    @Override
    public void close() {
        for (Segment segment : this.segmentList.get()) {
            if (segment == null) continue;
            segment.close();
        }
    }

    @Override
    public Segment[] getView() {
        return this.segmentList.get();
    }

    @Override
    public Segment getRecordSeg(long offset) throws IOException {
        Segment tmpSeg = this.findSegment(offset);
        if (tmpSeg != null && tmpSeg.isExpired()) {
            return null;
        }
        return tmpSeg;
    }

    @Override
    public void append(Segment segment) {
        Segment[] update;
        Segment[] curr;
        do {
            curr = this.segmentList.get();
            update = new Segment[curr.length + 1];
            System.arraycopy(curr, 0, update, 0, curr.length);
            update[curr.length] = segment;
        } while (!this.segmentList.compareAndSet(curr, update));
    }

    @Override
    public boolean checkExpiredSegments(long checkTimestamp, long fileValidTimeMs) {
        boolean hasExpired = false;
        for (Segment segment : this.segmentList.get()) {
            if (segment == null) continue;
            if (segment.checkAndSetExpired(checkTimestamp, fileValidTimeMs) == 0) break;
            hasExpired = true;
        }
        return hasExpired;
    }

    @Override
    public void delExpiredSegments(StringBuilder sb) {
        for (Segment segment : this.segmentList.get()) {
            if (segment == null) continue;
            if (!segment.needDelete()) break;
            this.delete(segment);
            segment.deleteFile();
        }
    }

    @Override
    public void delete(Segment segment) {
        Segment[] update;
        Segment[] curViews;
        do {
            int index = -1;
            curViews = this.segmentList.get();
            for (int i = 0; i < curViews.length; ++i) {
                if (curViews[i] != segment) continue;
                index = i;
                break;
            }
            if (index == -1) {
                return;
            }
            update = new Segment[curViews.length - 1];
            System.arraycopy(curViews, 0, update, 0, index);
            if (index + 1 >= curViews.length) continue;
            System.arraycopy(curViews, index + 1, update, index, curViews.length - index - 1);
        } while (!this.segmentList.compareAndSet(curViews, update));
    }

    @Override
    public void flushLast(boolean force) throws IOException {
        Segment[] curViews = this.segmentList.get();
        if (curViews.length == 0) {
            return;
        }
        Segment last = curViews[curViews.length - 1];
        if (last == null) {
            return;
        }
        last.flush(force);
    }

    @Override
    public Segment last() {
        Segment[] curViews = this.segmentList.get();
        if (curViews.length == 0) {
            return null;
        }
        return curViews[curViews.length - 1];
    }

    @Override
    public long getMinOffset() {
        long last = 0L;
        Segment[] curViews = this.segmentList.get();
        if (curViews.length == 0) {
            return last;
        }
        for (int i = 0; i < curViews.length; ++i) {
            if (curViews[i] == null) continue;
            if (curViews[i].isExpired()) {
                last = curViews[i].getCommitLast();
                continue;
            }
            return curViews[i].getStart();
        }
        return last;
    }

    @Override
    public long getMaxOffset() {
        Segment[] curViews = this.segmentList.get();
        if (curViews.length == 0) {
            return 0L;
        }
        Segment last = curViews[curViews.length - 1];
        if (last == null) {
            return 0L;
        }
        return last.getLast();
    }

    @Override
    public long getMaxAppendTime() {
        Segment[] curViews = this.segmentList.get();
        if (curViews.length == 0) {
            return 0L;
        }
        Segment last = curViews[curViews.length - 1];
        if (last == null) {
            return 0L;
        }
        return last.getRightAppendTime();
    }

    @Override
    public long getCommitMaxOffset() {
        Segment[] curViews = this.segmentList.get();
        if (curViews.length == 0) {
            return 0L;
        }
        Segment last = curViews[curViews.length - 1];
        if (last == null) {
            return 0L;
        }
        return last.getCommitLast();
    }

    @Override
    public long getSizeInBytes() {
        long sum = 0L;
        Segment[] curViews = this.segmentList.get();
        if (curViews.length == 0) {
            return sum;
        }
        for (int i = 0; i < curViews.length; ++i) {
            if (curViews[i] == null || curViews[i].isExpired()) continue;
            sum += curViews[i].getCachedSize();
        }
        return sum;
    }

    @Override
    public Segment findSegment(long offset) {
        Segment startSeg;
        Segment[] curViews = this.segmentList.get();
        if (curViews.length == 0) {
            return null;
        }
        int minStart = 0;
        for (minStart = 0; minStart < curViews.length && (curViews[minStart] == null || curViews[minStart].isExpired()); ++minStart) {
        }
        if (minStart >= curViews.length) {
            minStart = curViews.length - 1;
        }
        if (offset < (startSeg = curViews[minStart]).getStart()) {
            throw new ArrayIndexOutOfBoundsException(new StringBuilder(512).append("Request offsets is ").append(offset).append(", the start is ").append(startSeg.getStart()).toString());
        }
        Segment last = curViews[curViews.length - 1];
        if (offset >= last.getStart() + last.getCachedSize()) {
            return null;
        }
        int high = curViews.length - 1;
        while (minStart <= high) {
            int mid = high + minStart >>> 1;
            Segment found = curViews[mid];
            if (found.contains(offset)) {
                return found;
            }
            if (offset < found.getStart()) {
                high = mid - 1;
                continue;
            }
            minStart = mid + 1;
        }
        return null;
    }

    @Override
    public Segment findSegmentByTimeStamp(long timestamp) {
        Segment[] curViews = this.segmentList.get();
        if (curViews.length == 0) {
            return null;
        }
        int minStart = 0;
        for (minStart = 0; minStart < curViews.length && (curViews[minStart] == null || curViews[minStart].isExpired()); ++minStart) {
        }
        if (minStart >= curViews.length) {
            minStart = curViews.length - 1;
        }
        int hight = curViews.length - 1;
        Segment startSeg = curViews[minStart];
        if (minStart == hight || timestamp <= startSeg.getLeftAppendTime()) {
            return startSeg;
        }
        Segment last = curViews[hight];
        Segment before = curViews[hight - 1];
        if (last.getCachedSize() > 0L && timestamp > last.getLeftAppendTime()) {
            return last;
        }
        if (timestamp > before.getRightAppendTime()) {
            return last;
        }
        if (timestamp > before.getLeftAppendTime()) {
            return before;
        }
        int mid = 0;
        Segment found = null;
        while (minStart <= hight) {
            mid = hight + minStart >>> 1;
            found = curViews[mid];
            if (found.containTime(timestamp)) {
                before = curViews[mid - 1];
                if (timestamp > before.getRightAppendTime()) {
                    return found;
                }
                if (timestamp > before.getLeftAppendTime()) {
                    return before;
                }
                hight = mid - 1;
                continue;
            }
            if (timestamp < found.getLeftAppendTime()) {
                hight = mid - 1;
                continue;
            }
            minStart = mid + 1;
        }
        return null;
    }
}

