/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.tubemq.server.broker.stats.prometheus;

import io.prometheus.client.Collector;
import io.prometheus.client.CounterMetricFamily;
import io.prometheus.client.exporter.HTTPServer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.inlong.tubemq.server.broker.TubeBroker;
import org.apache.inlong.tubemq.server.broker.msgstore.MessageStore;
import org.apache.inlong.tubemq.server.broker.stats.BrokerSrvStatsHolder;
import org.apache.inlong.tubemq.server.common.fileconfig.PrometheusConfig;
import org.apache.inlong.tubemq.server.common.webbase.WebCallStatsHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BrokerPromMetricService
extends Collector {
    private static final Logger logger = LoggerFactory.getLogger(BrokerPromMetricService.class);
    private TubeBroker tubeBroker;
    private PrometheusConfig promConfig = new PrometheusConfig();
    private HTTPServer httpServer;
    private volatile boolean started = false;

    public BrokerPromMetricService(TubeBroker tubeBroker, PrometheusConfig prometheusConfig) {
        if (prometheusConfig == null || !prometheusConfig.isPromEnable()) {
            return;
        }
        this.tubeBroker = tubeBroker;
        this.promConfig = prometheusConfig;
    }

    public void start() {
        try {
            this.httpServer = new HTTPServer(this.promConfig.getPromHttpPort());
            this.register();
            this.started = true;
        }
        catch (IOException e) {
            logger.error("exception while register Broker prometheus http server, error:{}", (Object)e.getMessage());
        }
    }

    public List<Collector.MetricFamilySamples> collect() {
        ArrayList<Collector.MetricFamilySamples> mfs = new ArrayList<Collector.MetricFamilySamples>();
        if (!this.started) {
            return mfs;
        }
        LinkedHashMap<String, Long> statsMap = new LinkedHashMap<String, Long>();
        StringBuilder strBuff = new StringBuilder(512);
        CounterMetricFamily srvStatusCounter = new CounterMetricFamily(strBuff.append(this.promConfig.getPromClusterName()).append("&group=serviceStatus").toString(), "The service status metrics of TubeMQ-Broker node.", Arrays.asList("serviceStatus"));
        strBuff.delete(0, strBuff.length());
        BrokerSrvStatsHolder.snapShort(statsMap);
        for (Map.Entry entry : statsMap.entrySet()) {
            srvStatusCounter.addMetric(Arrays.asList((String)entry.getKey()), (double)((Long)entry.getValue()).longValue());
        }
        mfs.add((Collector.MetricFamilySamples)srvStatusCounter);
        CounterMetricFamily webAPICounter = new CounterMetricFamily(strBuff.append(this.promConfig.getPromClusterName()).append("&group=webAPI").toString(), "The web api call metrics of TubeMQ-Broker node.", Arrays.asList("webAPI"));
        strBuff.delete(0, strBuff.length());
        statsMap.clear();
        WebCallStatsHolder.snapShort(statsMap);
        for (Map.Entry entry : statsMap.entrySet()) {
            webAPICounter.addMetric(Arrays.asList((String)entry.getKey()), (double)((Long)entry.getValue()).longValue());
        }
        mfs.add((Collector.MetricFamilySamples)webAPICounter);
        CounterMetricFamily counterMetricFamily = new CounterMetricFamily(strBuff.append(this.promConfig.getPromClusterName()).append("&group=msgStore").toString(), "The message store metrics of TubeMQ-Broker node.", Arrays.asList("msgStore"));
        strBuff.delete(0, strBuff.length());
        ArrayList<Object> arrayList = new ArrayList<Object>();
        Map<String, ConcurrentHashMap<Integer, MessageStore>> msgTopicStores = this.tubeBroker.getStoreManager().getMessageStores();
        for (ConcurrentHashMap<Integer, MessageStore> storeMap : msgTopicStores.values()) {
            if (storeMap == null) continue;
            for (MessageStore msgStore : storeMap.values()) {
                if (msgStore == null) continue;
                statsMap.clear();
                msgStore.getMsgStoreStatsHolder().snapShort(statsMap);
                for (Map.Entry entry : statsMap.entrySet()) {
                    arrayList.clear();
                    arrayList.add(entry.getKey());
                    arrayList.add(strBuff.append("topicName=").append(msgStore.getTopic()).toString());
                    strBuff.delete(0, strBuff.length());
                    arrayList.add(strBuff.append("storeId=").append(msgStore.getStoreId()).toString());
                    strBuff.delete(0, strBuff.length());
                    counterMetricFamily.addMetric(arrayList, (double)((Long)entry.getValue()).longValue());
                }
            }
        }
        mfs.add((Collector.MetricFamilySamples)counterMetricFamily);
        return mfs;
    }
}

