/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.tubemq.server.common.utils;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.apache.inlong.tubemq.corebase.cluster.MasterInfo;
import org.apache.inlong.tubemq.corebase.utils.AddressUtils;
import org.apache.inlong.tubemq.corebase.utils.TStringUtils;
import org.apache.inlong.tubemq.server.common.fielddef.WebFieldDef;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpUtils {
    private static final Logger logger = LoggerFactory.getLogger(HttpUtils.class);

    public static JsonObject requestWebService(String url, Map<String, String> inParamMap) throws Exception {
        if (url == null) {
            throw new Exception("Web service url is null!");
        }
        if (url.trim().toLowerCase().startsWith("https://")) {
            throw new Exception("Unsupported https protocol!");
        }
        ArrayList<BasicNameValuePair> params = new ArrayList<BasicNameValuePair>();
        if (inParamMap != null && !inParamMap.isEmpty()) {
            for (Map.Entry<String, String> entry : inParamMap.entrySet()) {
                params.add(new BasicNameValuePair(entry.getKey(), entry.getValue()));
            }
            if (inParamMap.containsKey(WebFieldDef.CALLERIP.shortName) || inParamMap.containsKey(WebFieldDef.CALLERIP.name)) {
                params.add(new BasicNameValuePair(WebFieldDef.CALLERIP.name, AddressUtils.getIPV4LocalAddress()));
            }
        }
        RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(50000).setSocketTimeout(60000).build();
        CloseableHttpClient httpclient = null;
        HttpPost httpPost1 = null;
        HttpPost httpPost2 = null;
        JsonObject jsonRes = null;
        try {
            String returnStr;
            httpclient = HttpClients.custom().setDefaultRequestConfig(requestConfig).build();
            UrlEncodedFormEntity se = new UrlEncodedFormEntity(params);
            httpPost1 = new HttpPost(url);
            httpPost1.setEntity((HttpEntity)se);
            CloseableHttpResponse response = httpclient.execute((HttpUriRequest)httpPost1);
            if (response.getStatusLine().getStatusCode() == 302) {
                String redirectURL = response.getFirstHeader("Location").getValue();
                httpPost2 = new HttpPost(redirectURL);
                httpPost2.setEntity((HttpEntity)se);
                response = httpclient.execute((HttpUriRequest)httpPost2);
            }
            if (TStringUtils.isNotBlank((String)(returnStr = EntityUtils.toString((HttpEntity)response.getEntity()))) && response.getStatusLine().getStatusCode() == 200) {
                jsonRes = JsonParser.parseString((String)returnStr).getAsJsonObject();
            }
        }
        catch (Throwable e) {
            throw new Exception("Connecting " + url + " throw an error!", e);
        }
        finally {
            if (httpPost1 != null) {
                httpPost1.releaseConnection();
            }
            if (httpPost2 != null) {
                httpPost2.releaseConnection();
            }
            if (httpclient != null) {
                try {
                    httpclient.close();
                }
                catch (IOException ie) {
                    logger.error("Close HttpClient error.", (Throwable)ie);
                }
            }
        }
        return jsonRes;
    }

    public static void main(String[] args) {
        HashMap<String, String> inParamMap = new HashMap<String, String>();
        inParamMap.put("topicName", "test_1");
        inParamMap.put("brokerId", "170399798");
        String masterAddr = "127.0.0.1:8082,127.0.0.1:8080";
        MasterInfo masterInfo = new MasterInfo(masterAddr.trim());
        JsonObject jsonRes = null;
        for (String address : masterInfo.getNodeHostPortList()) {
            String visitUrl = "http://" + address + "/webapi.htm?method=admin_query_topic_info";
            try {
                jsonRes = HttpUtils.requestWebService(visitUrl, inParamMap);
                if (jsonRes == null) continue;
                break;
            }
            catch (Throwable throwable) {
            }
        }
        if (jsonRes != null) {
            System.out.println("query result is " + jsonRes.toString());
        }
    }
}

