/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.tubemq.server.master.bdbstore.bdbentitys;

import com.sleepycat.persist.model.Entity;
import com.sleepycat.persist.model.PrimaryKey;
import java.io.Serializable;
import java.util.Date;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.inlong.tubemq.corebase.utils.DateTimeConvertUtils;
import org.apache.inlong.tubemq.corebase.utils.TStringUtils;

@Entity
public class BdbTopicAuthControlEntity
implements Serializable {
    private static final long serialVersionUID = 7356175918639562340L;
    @PrimaryKey
    private String topicName;
    private int enableAuthControl = -1;
    private String createUser;
    private Date createDate;
    private String attributes;

    public BdbTopicAuthControlEntity() {
    }

    public BdbTopicAuthControlEntity(String topicName, boolean enableAuthControl, String modifyUser, Date modifyDate) {
        this.topicName = topicName;
        this.enableAuthControl = enableAuthControl ? 1 : 0;
        this.createUser = modifyUser;
        this.createDate = modifyDate;
    }

    public BdbTopicAuthControlEntity(String topicName, boolean enableAuthControl, String attributes, String modifyUser, Date modifyDate) {
        this.topicName = topicName;
        this.enableAuthControl = enableAuthControl ? 1 : 0;
        this.attributes = attributes;
        this.createUser = modifyUser;
        this.createDate = modifyDate;
    }

    public String getAttributes() {
        return this.attributes;
    }

    public void setAttributes(String attributes) {
        this.attributes = attributes;
    }

    public String getTopicName() {
        return this.topicName;
    }

    public void setTopicName(String topicName) {
        this.topicName = topicName;
    }

    public boolean isEnableAuthControl() {
        return this.enableAuthControl == 1;
    }

    public int getEnableAuthControl() {
        return this.enableAuthControl;
    }

    public void setEnableAuthControl(boolean enableAuthControl) {
        this.enableAuthControl = enableAuthControl ? 1 : 0;
    }

    public String getModifyUser() {
        return this.createUser;
    }

    public Date getModifyDate() {
        return this.createDate;
    }

    public long getDataVerId() {
        String atrVal = TStringUtils.getAttrValFrmAttributes((String)this.attributes, (String)"dataVerId");
        if (atrVal != null) {
            return Long.parseLong(atrVal);
        }
        return -2L;
    }

    public void setDataVerId(long dataVerId) {
        this.attributes = TStringUtils.setAttrValToAttributes((String)this.attributes, (String)"dataVerId", (String)String.valueOf(dataVerId));
    }

    public int getTopicId() {
        String atrVal = TStringUtils.getAttrValFrmAttributes((String)this.attributes, (String)"topicId");
        if (atrVal != null) {
            return Integer.parseInt(atrVal);
        }
        return -2;
    }

    public void setTopicId(int topicId) {
        this.attributes = TStringUtils.setAttrValToAttributes((String)this.attributes, (String)"topicId", (String)String.valueOf(topicId));
    }

    public int getMaxMsgSize() {
        String atrVal = TStringUtils.getAttrValFrmAttributes((String)this.attributes, (String)"maxMsgSize");
        if (atrVal != null) {
            return Integer.parseInt(atrVal);
        }
        return -2;
    }

    public void setMaxMsgSize(int maxMsgSize) {
        this.attributes = TStringUtils.setAttrValToAttributes((String)this.attributes, (String)"maxMsgSize", (String)String.valueOf(maxMsgSize));
    }

    public void setCreateInfo(String createUser, Date createDate) {
        if (TStringUtils.isNotBlank((String)createUser)) {
            this.attributes = TStringUtils.setAttrValToAttributes((String)this.attributes, (String)"creater", (String)createUser);
        }
        if (createDate != null) {
            String dataStr = DateTimeConvertUtils.date2yyyyMMddHHmmss((Date)createDate);
            this.attributes = TStringUtils.setAttrValToAttributes((String)this.attributes, (String)"createDate", (String)dataStr);
        }
    }

    public String getCreateUser() {
        String tmpCreateUser = TStringUtils.getAttrValFrmAttributes((String)this.attributes, (String)"creater");
        if (TStringUtils.isEmpty((String)tmpCreateUser)) {
            tmpCreateUser = this.createUser;
        }
        return tmpCreateUser;
    }

    public Date getCreateDate() {
        String dateStr = TStringUtils.getAttrValFrmAttributes((String)this.attributes, (String)"createDate");
        if (TStringUtils.isNotEmpty((String)dateStr)) {
            return DateTimeConvertUtils.yyyyMMddHHmmss2date((String)dateStr);
        }
        return this.createDate;
    }

    public String getStrModifyDate() {
        return DateTimeConvertUtils.date2yyyyMMddHHmmss((Date)this.createDate);
    }

    public String getStrCreateDate() {
        String dateStr = TStringUtils.getAttrValFrmAttributes((String)this.attributes, (String)"createDate");
        if (TStringUtils.isEmpty((String)dateStr)) {
            dateStr = DateTimeConvertUtils.date2yyyyMMddHHmmss((Date)this.createDate);
        }
        return dateStr;
    }

    public StringBuilder toJsonString(StringBuilder sBuilder) {
        return sBuilder.append("{\"type\":\"BdbConsumerGroupEntity\",").append("\"topicName\":\"").append(this.topicName).append("\",\"enableAuthControl\":\"").append(this.enableAuthControl).append("\",\"createUser\":\"").append(this.getCreateUser()).append("\",\"createDate\":\"").append(this.getStrCreateDate()).append("\",\"modifyUser\":\"").append(this.getModifyUser()).append("\",\"modifyDate\":\"").append(this.getStrModifyDate()).append("\",\"attributes\":\"").append(this.attributes).append("\"}");
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("topicName", (Object)this.topicName).append("enableAuthControl", this.enableAuthControl).append("createUser", (Object)this.getCreateUser()).append("createDate", (Object)this.getStrCreateDate()).append("modifyUser", (Object)this.getModifyUser()).append("modifyDate", (Object)this.getStrModifyDate()).append("attributes", (Object)this.attributes).toString();
    }
}

