/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.tubemq.server.master.metamanage.metastore.dao.entity;

import java.util.Objects;
import org.apache.inlong.tubemq.corebase.utils.TStringUtils;
import org.apache.inlong.tubemq.server.common.statusdef.EnableStatus;
import org.apache.inlong.tubemq.server.master.bdbstore.bdbentitys.BdbGroupFlowCtrlEntity;
import org.apache.inlong.tubemq.server.master.metamanage.metastore.dao.entity.BaseEntity;

public class GroupResCtrlEntity
extends BaseEntity
implements Cloneable {
    private String groupName = "";
    private EnableStatus resCheckStatus = EnableStatus.STATUS_UNDEFINE;
    private int allowedBrokerClientRate = -2;
    private int qryPriorityId = -2;
    private EnableStatus flowCtrlStatus = EnableStatus.STATUS_UNDEFINE;
    private int ruleCnt = 0;
    private String flowCtrlInfo = "";

    public GroupResCtrlEntity() {
    }

    public GroupResCtrlEntity(BaseEntity opEntity, String groupName) {
        super(opEntity);
        this.groupName = groupName;
    }

    public GroupResCtrlEntity(BdbGroupFlowCtrlEntity bdbEntity) {
        super(bdbEntity.getSerialId(), bdbEntity.getModifyUser(), bdbEntity.getModifyDate());
        this.setCreateInfo(bdbEntity.getCreateUser(), bdbEntity.getCreateDate());
        this.groupName = bdbEntity.getGroupName();
        this.qryPriorityId = bdbEntity.getQryPriorityId();
        this.ruleCnt = bdbEntity.getRuleCnt();
        this.flowCtrlInfo = bdbEntity.getFlowCtrlInfo();
        this.flowCtrlStatus = bdbEntity.getStatusId() != 0 ? EnableStatus.STATUS_ENABLE : EnableStatus.STATUS_DISABLE;
        this.resCheckStatus = bdbEntity.getResCheckStatus();
        this.allowedBrokerClientRate = bdbEntity.getAllowedBrokerClientRate();
        this.setAttributes(bdbEntity.getAttributes());
    }

    public BdbGroupFlowCtrlEntity buildBdbGroupFlowCtrlEntity() {
        int statusId = this.flowCtrlStatus == EnableStatus.STATUS_ENABLE ? 1 : 0;
        BdbGroupFlowCtrlEntity bdbEntity = new BdbGroupFlowCtrlEntity(this.getDataVerId(), this.groupName, this.flowCtrlInfo, statusId, this.ruleCnt, this.qryPriorityId, this.getAttributes(), this.getModifyUser(), this.getModifyDate());
        bdbEntity.setCreateInfo(this.getCreateUser(), this.getCreateDate());
        bdbEntity.setResCheckStatus(this.resCheckStatus);
        bdbEntity.setAllowedBrokerClientRate(this.allowedBrokerClientRate);
        return bdbEntity;
    }

    public GroupResCtrlEntity fillDefaultValue() {
        this.resCheckStatus = EnableStatus.STATUS_DISABLE;
        this.allowedBrokerClientRate = 0;
        this.qryPriorityId = 301;
        this.flowCtrlStatus = EnableStatus.STATUS_DISABLE;
        this.ruleCnt = 0;
        this.flowCtrlInfo = "[]";
        return this;
    }

    public GroupResCtrlEntity fillEmptyValues() {
        if (TStringUtils.isBlank((String)this.flowCtrlInfo)) {
            this.setFlowCtrlRule(0, "[]");
        }
        if (this.resCheckStatus == EnableStatus.STATUS_UNDEFINE) {
            this.resCheckStatus = EnableStatus.STATUS_DISABLE;
            this.allowedBrokerClientRate = 0;
        }
        if (this.flowCtrlStatus == EnableStatus.STATUS_UNDEFINE) {
            this.flowCtrlStatus = EnableStatus.STATUS_DISABLE;
        }
        if (this.qryPriorityId == -2) {
            this.qryPriorityId = 301;
        }
        return this;
    }

    public GroupResCtrlEntity setGroupName(String groupName) {
        this.groupName = groupName;
        return this;
    }

    public String getGroupName() {
        return this.groupName;
    }

    public int getRuleCnt() {
        return this.ruleCnt;
    }

    public String getFlowCtrlInfo() {
        return this.flowCtrlInfo;
    }

    public int getQryPriorityId() {
        return this.qryPriorityId;
    }

    public void setQryPriorityId(int qryPriorityId) {
        this.qryPriorityId = qryPriorityId;
    }

    public boolean isFlowCtrlEnable() {
        return this.flowCtrlStatus == EnableStatus.STATUS_ENABLE;
    }

    public boolean isEnableResCheck() {
        return this.resCheckStatus == EnableStatus.STATUS_ENABLE;
    }

    public int getAllowedBrokerClientRate() {
        return this.allowedBrokerClientRate;
    }

    public void setAllowedBrokerClientRate(int allowedBrokerClientRate) {
        this.allowedBrokerClientRate = allowedBrokerClientRate;
    }

    public EnableStatus getResCheckStatus() {
        return this.resCheckStatus;
    }

    public EnableStatus getFlowCtrlStatus() {
        return this.flowCtrlStatus;
    }

    public void setResCheckStatus(EnableStatus resCheckStatus) {
        if (resCheckStatus != null) {
            this.resCheckStatus = resCheckStatus;
        }
    }

    public void setFlowCtrlStatus(EnableStatus flowCtrlStatus) {
        if (flowCtrlStatus != null) {
            this.flowCtrlStatus = flowCtrlStatus;
        }
    }

    private void setFlowCtrlRule(int ruleCnt, String flowCtrlInfo) {
        this.ruleCnt = ruleCnt;
        this.flowCtrlInfo = flowCtrlInfo;
    }

    public boolean updModifyInfo(long dataVerId, EnableStatus resChkEnable, int allowedB2CRate, int qryPriorityId, EnableStatus flowCtrlEnable, int flowRuleCnt, String flowCtrlRuleInfo) {
        boolean changed = false;
        if (dataVerId != -2L && this.getDataVerId() != dataVerId) {
            changed = true;
            this.setDataVersionId(dataVerId);
        }
        if (resChkEnable != null && resChkEnable != EnableStatus.STATUS_UNDEFINE && this.resCheckStatus != resChkEnable) {
            changed = true;
            this.setResCheckStatus(resChkEnable);
        }
        if (allowedB2CRate != -2 && this.allowedBrokerClientRate != allowedB2CRate) {
            changed = true;
            this.allowedBrokerClientRate = allowedB2CRate;
        }
        if (qryPriorityId != -2 && this.qryPriorityId != qryPriorityId) {
            changed = true;
            this.qryPriorityId = qryPriorityId;
        }
        if (flowCtrlEnable != null && flowCtrlEnable != EnableStatus.STATUS_UNDEFINE && this.flowCtrlStatus != flowCtrlEnable) {
            changed = true;
            this.setFlowCtrlStatus(flowCtrlEnable);
        }
        if (TStringUtils.isNotBlank((String)flowCtrlRuleInfo) && !flowCtrlRuleInfo.equals(this.flowCtrlInfo)) {
            changed = true;
            this.setFlowCtrlRule(flowRuleCnt, flowCtrlRuleInfo);
        }
        if (changed) {
            this.updSerialId();
        }
        return changed;
    }

    public boolean isMatched(GroupResCtrlEntity target) {
        if (target == null) {
            return true;
        }
        if (!super.isMatched(target)) {
            return false;
        }
        return !(target.getQryPriorityId() != -2 && target.getQryPriorityId() != this.qryPriorityId || !TStringUtils.isBlank((String)target.getGroupName()) && !target.getGroupName().equals(this.groupName) || target.getResCheckStatus() != EnableStatus.STATUS_UNDEFINE && target.getResCheckStatus() != this.resCheckStatus || target.getFlowCtrlStatus() != EnableStatus.STATUS_UNDEFINE && target.getFlowCtrlStatus() != this.flowCtrlStatus || target.getAllowedBrokerClientRate() != -2 && target.getAllowedBrokerClientRate() != this.allowedBrokerClientRate);
    }

    public StringBuilder toWebJsonStr(StringBuilder sBuffer, boolean isLongName, boolean fullFormat) {
        if (isLongName) {
            sBuffer.append("{\"groupName\":\"").append(this.groupName).append("\"").append(",\"resCheckEnable\":").append(this.resCheckStatus.isEnable()).append(",\"alwdBrokerClientRate\":").append(this.allowedBrokerClientRate).append(",\"qryPriorityId\":").append(this.qryPriorityId).append(",\"flowCtrlEnable\":").append(this.flowCtrlStatus.isEnable()).append(",\"flowCtrlRuleCount\":").append(this.ruleCnt).append(",\"flowCtrlInfo\":").append(this.flowCtrlInfo);
        } else {
            sBuffer.append("{\"group\":\"").append(this.groupName).append("\"").append(",\"resChkEn\":").append(this.resCheckStatus.isEnable()).append(",\"abcr\":").append(this.allowedBrokerClientRate).append(",\"qryPriId\":").append(this.qryPriorityId).append(",\"fCtrlEn\":").append(this.flowCtrlStatus.isEnable()).append(",\"fCtrlCnt\":").append(this.ruleCnt).append(",\"fCtrlInfo\":").append(this.flowCtrlInfo);
        }
        super.toWebJsonStr(sBuffer, isLongName);
        if (fullFormat) {
            sBuffer.append("}");
        }
        return sBuffer;
    }

    public StringBuilder toOldVerFlowCtrlWebJsonStr(StringBuilder sBuffer, boolean isLongName) {
        int statusId;
        int n = statusId = this.flowCtrlStatus.isEnable() ? 1 : 0;
        if (isLongName) {
            sBuffer.append("{\"groupName\":\"").append(this.groupName).append("\",\"statusId\":").append(statusId).append(",\"qryPriorityId\":").append(this.qryPriorityId).append(",\"ruleCnt\":").append(this.ruleCnt).append(",\"flowCtrlInfo\":").append(this.flowCtrlInfo);
        } else {
            sBuffer.append("{\"group\":\"").append(this.groupName).append("\",\"statusId\":").append(statusId).append(",\"qryPriId\":").append(this.qryPriorityId).append(",\"fCtrlCnt\":").append(this.ruleCnt).append(",\"fCtrlInfo\":").append(this.flowCtrlInfo);
        }
        super.toWebJsonStr(sBuffer, isLongName);
        sBuffer.append("}");
        return sBuffer;
    }

    public boolean isDataEquals(GroupResCtrlEntity other) {
        return super.isDataEquals(other) && this.allowedBrokerClientRate == other.allowedBrokerClientRate && this.qryPriorityId == other.qryPriorityId && this.ruleCnt == other.ruleCnt && this.groupName.equals(other.groupName) && this.resCheckStatus == other.resCheckStatus && this.flowCtrlStatus == other.flowCtrlStatus && Objects.equals(this.flowCtrlInfo, other.flowCtrlInfo);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GroupResCtrlEntity)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        GroupResCtrlEntity that = (GroupResCtrlEntity)o;
        return this.isDataEquals(that);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.groupName, this.resCheckStatus, this.allowedBrokerClientRate, this.qryPriorityId, this.flowCtrlStatus, this.ruleCnt, this.flowCtrlInfo});
    }

    @Override
    public GroupResCtrlEntity clone() {
        GroupResCtrlEntity copy = (GroupResCtrlEntity)super.clone();
        copy.setFlowCtrlStatus(this.getFlowCtrlStatus());
        copy.setResCheckStatus(this.getResCheckStatus());
        return copy;
    }
}

