/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.tubemq.server.master.metamanage.metastore.impl.bdbimpl;

import com.sleepycat.je.Environment;
import com.sleepycat.je.rep.ReplicatedEnvironment;
import com.sleepycat.persist.EntityCursor;
import com.sleepycat.persist.EntityStore;
import com.sleepycat.persist.PrimaryIndex;
import com.sleepycat.persist.StoreConfig;
import org.apache.inlong.tubemq.corebase.rv.ProcessResult;
import org.apache.inlong.tubemq.server.common.exception.LoadMetaException;
import org.apache.inlong.tubemq.server.master.bdbstore.bdbentitys.BdbTopicConfEntity;
import org.apache.inlong.tubemq.server.master.metamanage.DataOpErrCode;
import org.apache.inlong.tubemq.server.master.metamanage.metastore.dao.entity.TopicDeployEntity;
import org.apache.inlong.tubemq.server.master.metamanage.metastore.impl.AbsTopicDeployMapperImpl;

public class BdbTopicDeployMapperImpl
extends AbsTopicDeployMapperImpl {
    private EntityStore topicConfStore;
    private final PrimaryIndex<String, BdbTopicConfEntity> topicConfIndex;

    public BdbTopicDeployMapperImpl(ReplicatedEnvironment repEnv, StoreConfig storeConfig) {
        this.topicConfStore = new EntityStore((Environment)repEnv, "bdbTopicConfig", storeConfig);
        this.topicConfIndex = this.topicConfStore.getPrimaryIndex(String.class, BdbTopicConfEntity.class);
    }

    @Override
    public void close() {
        this.clearCachedData();
        if (this.topicConfStore != null) {
            try {
                this.topicConfStore.close();
                this.topicConfStore = null;
            }
            catch (Throwable e) {
                logger.error("[BDB Impl] close topic deploy configure failure ", e);
            }
        }
        logger.info("[BDB Impl] topic deploy configure closed!");
    }

    @Override
    public void loadConfig(StringBuilder strBuff) throws LoadMetaException {
        long totalCnt = 0L;
        EntityCursor cursor = null;
        logger.info("[BDB Impl] load topic deploy configure start...");
        this.clearCachedData();
        try {
            cursor = this.topicConfIndex.entities();
            for (BdbTopicConfEntity bdbEntity : cursor) {
                if (bdbEntity == null) {
                    logger.warn("[BDB Impl] found Null data while loading topic deploy configure!");
                    continue;
                }
                this.putRecord2Caches(new TopicDeployEntity(bdbEntity));
                ++totalCnt;
            }
        }
        catch (Exception e) {
            logger.error("[BDB Impl] load topic deploy configure failure ", (Throwable)e);
            throw new LoadMetaException(e.getMessage());
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
        }
        logger.info(strBuff.append("[BDB Impl] loaded ").append(totalCnt).append(" topic deploy configure successfully...").toString());
        strBuff.delete(0, strBuff.length());
    }

    @Override
    protected boolean putConfig2Persistent(TopicDeployEntity entity, StringBuilder strBuff, ProcessResult result) {
        BdbTopicConfEntity bdbEntity = entity.buildBdbTopicConfEntity();
        try {
            this.topicConfIndex.put((Object)bdbEntity);
        }
        catch (Throwable e) {
            logger.error("[BDB Impl] put topic deploy configure failure ", e);
            result.setFailResult(DataOpErrCode.DERR_STORE_ABNORMAL.getCode(), strBuff.append("Put topic deploy configure failure: ").append(e.getMessage()).toString());
            strBuff.delete(0, strBuff.length());
            return result.isSuccess();
        }
        result.setSuccResult(null);
        return result.isSuccess();
    }

    @Override
    protected boolean delConfigFromPersistent(String recordKey, StringBuilder strBuff) {
        try {
            this.topicConfIndex.delete((Object)recordKey);
        }
        catch (Throwable e) {
            logger.error("[BDB Impl] delete topic deploy configure failure ", e);
            return false;
        }
        return true;
    }
}

