/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.tubemq.server.master.nodemanage.nodebroker;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.inlong.tubemq.corebase.cluster.BrokerInfo;
import org.apache.inlong.tubemq.corebase.cluster.Partition;
import org.apache.inlong.tubemq.corebase.cluster.TopicInfo;
import org.apache.inlong.tubemq.corebase.protobuf.generated.ClientMaster;
import org.apache.inlong.tubemq.corebase.rv.ProcessResult;
import org.apache.inlong.tubemq.corebase.utils.Tuple2;
import org.apache.inlong.tubemq.corebase.utils.Tuple3;
import org.apache.inlong.tubemq.corebase.utils.Tuple4;
import org.apache.inlong.tubemq.server.common.heartbeat.HeartbeatManager;
import org.apache.inlong.tubemq.server.common.heartbeat.TimeoutInfo;
import org.apache.inlong.tubemq.server.common.heartbeat.TimeoutListener;
import org.apache.inlong.tubemq.server.common.statusdef.ManageStatus;
import org.apache.inlong.tubemq.server.common.utils.SerialIdUtils;
import org.apache.inlong.tubemq.server.master.MasterConfig;
import org.apache.inlong.tubemq.server.master.TMaster;
import org.apache.inlong.tubemq.server.master.metamanage.MetaDataService;
import org.apache.inlong.tubemq.server.master.metamanage.metastore.ConfigObserver;
import org.apache.inlong.tubemq.server.master.metamanage.metastore.dao.entity.BrokerConfEntity;
import org.apache.inlong.tubemq.server.master.nodemanage.nodebroker.BrokerAbnHolder;
import org.apache.inlong.tubemq.server.master.nodemanage.nodebroker.BrokerPSInfoHolder;
import org.apache.inlong.tubemq.server.master.nodemanage.nodebroker.BrokerRunManager;
import org.apache.inlong.tubemq.server.master.nodemanage.nodebroker.BrokerRunStatusInfo;
import org.apache.inlong.tubemq.server.master.stats.MasterSrvStatsHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefBrokerRunManager
implements BrokerRunManager,
ConfigObserver {
    private static final Logger logger = LoggerFactory.getLogger(DefBrokerRunManager.class);
    private final MetaDataService metaDataService;
    private final HeartbeatManager heartbeatManager;
    private final AtomicLong brokerInfoCheckSum = new AtomicLong(System.currentTimeMillis());
    private long lastBrokerUpdatedTime = System.currentTimeMillis();
    private final ConcurrentHashMap<Integer, String> brokersMap = new ConcurrentHashMap();
    private final ConcurrentHashMap<Integer, String> brokersTLSMap = new ConcurrentHashMap();
    private final AtomicInteger brokerTotalCount = new AtomicInteger(0);
    private final ConcurrentHashMap<Integer, BrokerRunStatusInfo> brokerRunSyncManageMap = new ConcurrentHashMap();
    private final BrokerAbnHolder brokerAbnHolder;
    private final BrokerPSInfoHolder brokerPubSubInfo = new BrokerPSInfoHolder();

    public DefBrokerRunManager(TMaster tMaster) {
        this.metaDataService = tMaster.getMetaDataService();
        this.heartbeatManager = tMaster.getHeartbeatManager();
        MasterConfig masterConfig = tMaster.getMasterConfig();
        this.brokerAbnHolder = new BrokerAbnHolder(masterConfig.getMaxAutoForbiddenCnt(), this.metaDataService);
        this.heartbeatManager.regBrokerCheckBusiness(masterConfig.getBrokerHeartbeatTimeoutMs(), new TimeoutListener(){

            @Override
            public void onTimeout(String nodeId, TimeoutInfo nodeInfo) throws Exception {
                logger.info(new StringBuilder(512).append("[Broker Timeout] ").append(nodeId).toString());
                DefBrokerRunManager.this.releaseBrokerRunInfo(Integer.parseInt(nodeId), nodeInfo.getSecondKey(), true);
            }
        });
        this.metaDataService.regMetaConfigObserver(this);
    }

    @Override
    public void clearCacheData() {
    }

    @Override
    public void reloadCacheData() {
        this.updBrokerStaticInfo(this.metaDataService.getBrokerConfInfo(null));
    }

    @Override
    public Tuple2<Long, Map<Integer, String>> getBrokerStaticInfo(boolean isOverTLS) {
        if (isOverTLS) {
            return new Tuple2((Object)this.brokerInfoCheckSum.get(), this.brokersTLSMap);
        }
        return new Tuple2((Object)this.brokerInfoCheckSum.get(), this.brokersMap);
    }

    @Override
    public void updBrokerStaticInfo(Map<Integer, BrokerConfEntity> brokerConfMap) {
        if (brokerConfMap == null || brokerConfMap.isEmpty()) {
            return;
        }
        for (BrokerConfEntity entity : brokerConfMap.values()) {
            this.updBrokerStaticInfo(entity);
        }
    }

    @Override
    public void updBrokerStaticInfo(BrokerConfEntity entity) {
        if (entity == null) {
            return;
        }
        String brokerReg = this.brokersMap.putIfAbsent(entity.getBrokerId(), entity.getSimpleBrokerInfo());
        String brokerTLSReg = this.brokersTLSMap.putIfAbsent(entity.getBrokerId(), entity.getSimpleTLSBrokerInfo());
        if (brokerReg == null || brokerTLSReg == null || !brokerReg.equals(entity.getSimpleBrokerInfo()) || !brokerTLSReg.equals(entity.getSimpleTLSBrokerInfo())) {
            if (brokerReg == null) {
                MasterSrvStatsHolder.incBrokerConfigCnt();
            } else if (!brokerReg.equals(entity.getSimpleBrokerInfo())) {
                this.brokersMap.put(entity.getBrokerId(), entity.getSimpleBrokerInfo());
            }
            if (brokerTLSReg != null && !brokerTLSReg.equals(entity.getSimpleTLSBrokerInfo())) {
                this.brokersTLSMap.put(entity.getBrokerId(), entity.getSimpleTLSBrokerInfo());
            }
            SerialIdUtils.updTimeStampSerialIdValue(this.brokerInfoCheckSum);
        }
    }

    @Override
    public void delBrokerStaticInfo(int brokerId) {
        if (brokerId == -2) {
            return;
        }
        String brokerReg = this.brokersMap.remove(brokerId);
        String brokerTLSReg = this.brokersTLSMap.remove(brokerId);
        if (brokerReg != null || brokerTLSReg != null) {
            SerialIdUtils.updTimeStampSerialIdValue(this.brokerInfoCheckSum);
        }
    }

    @Override
    public void getBrokerPublishStatus(int brokerId, Tuple2<Boolean, Boolean> result) {
        this.brokerPubSubInfo.getBrokerPubStatus(brokerId, result);
    }

    @Override
    public BrokerAbnHolder getBrokerAbnHolder() {
        return this.brokerAbnHolder;
    }

    @Override
    public boolean brokerRegister2M(String clientId, BrokerInfo brokerInfo, long reportConfigId, int reportCheckSumId, boolean isTackData, String repBrokerConfInfo, List<String> repTopicConfInfo, boolean isOnline, boolean isOverTLS, StringBuilder sBuffer, ProcessResult result) {
        BrokerConfEntity brokerEntry = this.metaDataService.getBrokerConfByBrokerId(brokerInfo.getBrokerId());
        if (brokerEntry == null) {
            result.setFailResult(400, sBuffer.append("Not found broker configure info, please create first!").append(" the connecting client id is:").append(clientId).toString());
            sBuffer.delete(0, sBuffer.length());
            return result.isSuccess();
        }
        if (!brokerInfo.getHost().equals(brokerEntry.getBrokerIp()) || brokerInfo.getPort() != brokerEntry.getBrokerPort()) {
            result.setFailResult(400, sBuffer.append("Inconsistent broker configure,please confirm first!").append(" the connecting client id is:").append(clientId).append(", the configured broker address by brokerId is:").append(brokerEntry.getBrokerIdAndAddress()).toString());
            sBuffer.delete(0, sBuffer.length());
            return result.isSuccess();
        }
        int confTLSPort = brokerEntry.getBrokerTLSPort();
        if (confTLSPort != brokerInfo.getTlsPort()) {
            result.setFailResult(400, sBuffer.append("Inconsistent TLS configure, please confirm first!").append(" the connecting client id is:").append(clientId).append(", the configured TLS port is:").append(confTLSPort).append(", the broker reported TLS port is ").append(brokerInfo.getTlsPort()).toString());
            sBuffer.delete(0, sBuffer.length());
            return result.isSuccess();
        }
        if (brokerEntry.getManageStatus() == ManageStatus.STATUS_MANAGE_APPLY) {
            result.setFailResult(400, sBuffer.append("Broker's configure not online, please online configure first!").append(" the connecting client id is:").append(clientId).toString());
            sBuffer.delete(0, sBuffer.length());
            return result.isSuccess();
        }
        brokerEntry.getBrokerDefaultConfInfo(this.metaDataService.getClusterDefSetting(false), sBuffer);
        String brokerConfInfo = sBuffer.toString();
        sBuffer.delete(0, sBuffer.length());
        Map<String, String> topicConfInfoMap = this.metaDataService.getBrokerTopicStrConfigInfo(brokerEntry, sBuffer);
        BrokerRunStatusInfo runStatusInfo = this.brokerRunSyncManageMap.get(brokerInfo.getBrokerId());
        if (runStatusInfo == null) {
            BrokerRunStatusInfo tmpRunStatusInfo = new BrokerRunStatusInfo(this, brokerInfo, brokerEntry.getManageStatus(), brokerConfInfo, topicConfInfoMap, isOverTLS);
            runStatusInfo = this.brokerRunSyncManageMap.putIfAbsent(brokerInfo.getBrokerId(), tmpRunStatusInfo);
            if (runStatusInfo == null) {
                this.brokerTotalCount.incrementAndGet();
                MasterSrvStatsHolder.incBrokerOnlineCnt();
                runStatusInfo = tmpRunStatusInfo;
            }
        } else {
            runStatusInfo.reInitRunStatusInfo(brokerInfo, brokerEntry.getManageStatus(), brokerConfInfo, topicConfInfoMap, isOverTLS);
        }
        runStatusInfo.bookBrokerReportInfo(true, isOnline, reportConfigId, reportCheckSumId, isTackData, repBrokerConfInfo, repTopicConfInfo, sBuffer);
        this.heartbeatManager.regBrokerNode(String.valueOf(brokerInfo.getBrokerId()), runStatusInfo.getCreateId());
        result.setSuccResult(null);
        return result.isSuccess();
    }

    @Override
    public boolean brokerHeartBeat2M(int brokerId, long reportConfigId, int reportCheckSumId, boolean isTackData, String repBrokerConfInfo, List<String> repTopicConfInfo, boolean isTackRmvInfo, List<String> removedTopics, int rptReadStatus, int rptWriteStatus, boolean isOnline, StringBuilder sBuffer, ProcessResult result) {
        BrokerRunStatusInfo runStatusInfo = this.brokerRunSyncManageMap.get(brokerId);
        if (runStatusInfo == null) {
            result.setFailResult(411, sBuffer.append("Not found Broker run status info, please register broker first!").append(" the connecting client id is:").append(brokerId).toString());
            return result.isSuccess();
        }
        if (!this.heartbeatManager.updBrokerNode(String.valueOf(brokerId), runStatusInfo.getCreateId(), sBuffer, result)) {
            return result.isSuccess();
        }
        runStatusInfo.bookBrokerReportInfo(false, isOnline, reportConfigId, reportCheckSumId, isTackData, repBrokerConfInfo, repTopicConfInfo, sBuffer);
        if (isTackRmvInfo) {
            this.metaDataService.delCleanedTopicDeployInfo(brokerId, removedTopics, sBuffer, result);
            logger.info(sBuffer.append("[Broker Report] brokerId=").append(brokerId).append(" removed topics = ").append(removedTopics).append(", removed result is ").append(result.getErrMsg()).toString());
            sBuffer.delete(0, sBuffer.length());
        }
        this.brokerAbnHolder.updateBrokerReportStatus(brokerId, rptReadStatus, rptWriteStatus);
        result.setSuccResult(null);
        return result.isSuccess();
    }

    @Override
    public boolean brokerClose2M(int brokerId, StringBuilder sBuffer, ProcessResult result) {
        BrokerRunStatusInfo runStatusInfo = this.brokerRunSyncManageMap.get(brokerId);
        if (runStatusInfo == null) {
            result.setFailResult(411, sBuffer.append("Not found Broker run status info, please register broker first!").append(" the connecting client id is:").append(brokerId).toString());
            return result.isSuccess();
        }
        if (!this.heartbeatManager.unRegBrokerNode(String.valueOf(brokerId), runStatusInfo.getCreateId())) {
            logger.info(sBuffer.append("[Broker Closed] brokerId=").append(brokerId).append(" unregister failure, run-info has been replaced by new request!").toString());
            return result.isSuccess();
        }
        boolean isOverTls = runStatusInfo.isOverTLS();
        this.releaseBrokerRunInfo(brokerId, runStatusInfo.getCreateId(), false);
        logger.info(sBuffer.append("[Broker Closed] brokerId=").append(brokerId).append(" unregister success, isOverTLS=").append(isOverTls).toString());
        result.setSuccResult(null);
        return result.isSuccess();
    }

    @Override
    public Tuple3<ManageStatus, String, Map<String, String>> getBrokerMetaConfigInfo(int brokerId) {
        String brokerConfInfo = null;
        ManageStatus manageStatus = ManageStatus.STATUS_MANAGE_UNDEFINED;
        StringBuilder sBuffer = new StringBuilder(512);
        BrokerConfEntity brokerConfEntity = this.metaDataService.getBrokerConfByBrokerId(brokerId);
        if (brokerConfEntity != null) {
            brokerConfEntity.getBrokerDefaultConfInfo(this.metaDataService.getClusterDefSetting(false), sBuffer);
            brokerConfInfo = sBuffer.toString();
            sBuffer.delete(0, sBuffer.length());
            manageStatus = brokerConfEntity.getManageStatus();
        }
        Map<String, String> brokerTopicSetConfInfo = this.metaDataService.getBrokerTopicStrConfigInfo(brokerConfEntity, sBuffer);
        return new Tuple3((Object)manageStatus, (Object)brokerConfInfo, brokerTopicSetConfInfo);
    }

    @Override
    public void setRegisterDownConfInfo(int brokerId, StringBuilder sBuffer, ClientMaster.RegisterResponseM2B.Builder builder) {
        BrokerRunStatusInfo runStatusInfo = this.brokerRunSyncManageMap.get(brokerId);
        if (runStatusInfo == null) {
            logger.info(sBuffer.append("Get Broker run-info failure, brokerId=").append(brokerId).append(", please check the implement first!").toString());
            sBuffer.delete(0, sBuffer.length());
            return;
        }
        Tuple4<Long, Integer, String, List<String>> retTuple = runStatusInfo.getNeedSyncData();
        builder.setCurBrokerConfId(((Long)retTuple.getF0()).longValue());
        builder.setConfCheckSumId(((Integer)retTuple.getF1()).intValue());
        Tuple2<Boolean, Boolean> autoFbdTuple = this.brokerAbnHolder.getBrokerAutoFbdStatus(brokerId);
        builder.setStopWrite(((Boolean)autoFbdTuple.getF0()).booleanValue());
        builder.setStopRead(((Boolean)autoFbdTuple.getF1()).booleanValue());
        if (retTuple.getF2() == null) {
            builder.setTakeConfInfo(false);
        } else {
            builder.setTakeConfInfo(true);
            builder.setBrokerDefaultConfInfo((String)retTuple.getF2());
            builder.addAllBrokerTopicSetConfInfo((Iterable)retTuple.getF3());
            logger.info(sBuffer.append("[TMaster sync] push broker configure: brokerId = ").append(brokerId).append(",configureId=").append(retTuple.getF0()).append(",stopWrite=").append(builder.getStopWrite()).append(",stopRead=").append(builder.getStopRead()).append(",checksumId=").append(retTuple.getF1()).append(",default configure is ").append((String)retTuple.getF2()).append(",topic configure is ").append(retTuple.getF3()).toString());
            sBuffer.delete(0, sBuffer.length());
        }
    }

    @Override
    public void setHeatBeatDownConfInfo(int brokerId, StringBuilder sBuffer, ClientMaster.HeartResponseM2B.Builder builder) {
        BrokerRunStatusInfo runStatusInfo = this.brokerRunSyncManageMap.get(brokerId);
        if (runStatusInfo == null) {
            logger.info(sBuffer.append("Get Broker run-info failure, brokerId=").append(brokerId).append(", please check the implement first!").toString());
            sBuffer.delete(0, sBuffer.length());
            return;
        }
        Tuple4<Long, Integer, String, List<String>> retTuple = runStatusInfo.getNeedSyncData();
        builder.setCurBrokerConfId(((Long)retTuple.getF0()).longValue());
        builder.setConfCheckSumId(((Integer)retTuple.getF1()).intValue());
        Tuple2<Boolean, Boolean> autoFbdTuple = this.brokerAbnHolder.getBrokerAutoFbdStatus(brokerId);
        builder.setStopWrite(((Boolean)autoFbdTuple.getF0()).booleanValue());
        builder.setStopRead(((Boolean)autoFbdTuple.getF1()).booleanValue());
        if (retTuple.getF2() == null) {
            builder.setNeedReportData(false);
            builder.setTakeConfInfo(false);
        } else {
            builder.setNeedReportData(true);
            builder.setTakeConfInfo(true);
            builder.setBrokerDefaultConfInfo((String)retTuple.getF2());
            builder.addAllBrokerTopicSetConfInfo((Iterable)retTuple.getF3());
            logger.info(sBuffer.append("[TMaster sync] heartbeat sync config: brokerId = ").append(brokerId).append(",configureId=").append(retTuple.getF0()).append(",stopWrite=").append(builder.getStopWrite()).append(",stopRead=").append(builder.getStopRead()).append(",checksumId=").append(retTuple.getF1()).append(",default configure is ").append((String)retTuple.getF2()).append(",topic configure is ").append(retTuple.getF3()).toString());
            sBuffer.delete(0, sBuffer.length());
        }
    }

    @Override
    public BrokerRunStatusInfo getBrokerRunStatusInfo(int brokerId) {
        return this.brokerRunSyncManageMap.get(brokerId);
    }

    @Override
    public BrokerInfo getBrokerInfo(int brokerId) {
        BrokerRunStatusInfo runStatusInfo = this.brokerRunSyncManageMap.get(brokerId);
        if (runStatusInfo == null) {
            return null;
        }
        return runStatusInfo.getBrokerInfo();
    }

    @Override
    public Map<Integer, BrokerInfo> getBrokerInfoMap(List<Integer> brokerIds) {
        HashMap<Integer, BrokerInfo> brokerInfoMap = new HashMap<Integer, BrokerInfo>();
        if (brokerIds == null || brokerIds.isEmpty()) {
            for (BrokerRunStatusInfo runStatusInfo : this.brokerRunSyncManageMap.values()) {
                if (runStatusInfo == null) continue;
                BrokerInfo brokerInfo = runStatusInfo.getBrokerInfo();
                brokerInfoMap.put(brokerInfo.getBrokerId(), brokerInfo);
            }
        } else {
            for (Integer brokerId : brokerIds) {
                BrokerRunStatusInfo runStatusInfo = this.brokerRunSyncManageMap.get(brokerId);
                if (runStatusInfo == null) continue;
                brokerInfoMap.put(brokerId, runStatusInfo.getBrokerInfo());
            }
        }
        return brokerInfoMap;
    }

    @Override
    public boolean releaseBrokerRunInfo(int brokerId, String blockId, boolean isTimeout) {
        StringBuilder sBuffer = new StringBuilder(512);
        BrokerRunStatusInfo runStatusInfo = this.brokerRunSyncManageMap.get(brokerId);
        if (runStatusInfo == null) {
            logger.info(sBuffer.append("[Broker Release] brokerId=").append(brokerId).append(", isTimeout=").append(isTimeout).append(", release failure, run-info has deleted before!").toString());
            return false;
        }
        if (!blockId.equals(runStatusInfo.getCreateId())) {
            logger.info(sBuffer.append("[Broker Release] brokerId=").append(brokerId).append(", isTimeout=").append(isTimeout).append(", release failure, run-info has been replaced by new register!").toString());
            return false;
        }
        runStatusInfo = this.brokerRunSyncManageMap.remove(brokerId);
        if (runStatusInfo == null) {
            return false;
        }
        MasterSrvStatsHolder.decBrokerOnlineCnt(isTimeout);
        this.brokerTotalCount.decrementAndGet();
        this.brokerAbnHolder.removeBroker(brokerId);
        this.brokerPubSubInfo.rmvBrokerAllPushedInfo(brokerId);
        logger.info(sBuffer.append("[Broker Release] brokerId=").append(brokerId).append(", isTimeout=").append(isTimeout).append(", release success!").toString());
        return true;
    }

    @Override
    public void iniBrokerConfInfo(int brokerId, ManageStatus mngStatus, Map<String, TopicInfo> topicInfoMap) {
        this.brokerPubSubInfo.iniBrokerConfigInfo(brokerId, mngStatus, topicInfoMap);
    }

    @Override
    public boolean updBrokerCsmConfInfo(int brokerId, ManageStatus mngStatus, Map<String, TopicInfo> topicInfoMap) {
        this.brokerPubSubInfo.updBrokerMangeStatus(brokerId, mngStatus);
        return this.brokerPubSubInfo.updBrokerSubTopicConfInfo(brokerId, topicInfoMap);
    }

    @Override
    public void updBrokerPrdConfInfo(int brokerId, ManageStatus mngStatus, Map<String, TopicInfo> topicInfoMap) {
        this.brokerPubSubInfo.updBrokerPubTopicConfInfo(brokerId, topicInfoMap);
    }

    @Override
    public Map<String, String> getPubBrokerAcceptPubPartInfo(Map<String, Integer> topicSizeMap) {
        return this.brokerPubSubInfo.getAcceptPubPartInfo(topicSizeMap);
    }

    @Override
    public int getSubTopicMaxBrokerCount(Set<String> topicSet) {
        return this.brokerPubSubInfo.getTopicMaxSubBrokerCnt(topicSet);
    }

    @Override
    public Map<String, Partition> getSubBrokerAcceptSubParts(Set<String> topicSet) {
        return this.brokerPubSubInfo.getAcceptSubParts(topicSet);
    }

    @Override
    public List<Partition> getSubBrokerAcceptSubParts(String topic) {
        return this.brokerPubSubInfo.getAcceptSubParts(topic);
    }

    @Override
    public void getSubBrokerTopicInfo(int brokerId, String topic, Tuple2<Boolean, TopicInfo> result) {
        this.brokerPubSubInfo.getBrokerSubPushedTopicInfo(brokerId, topic, result);
    }

    @Override
    public void getPubBrokerTopicInfo(int brokerId, String topic, Tuple3<Boolean, Boolean, TopicInfo> result) {
        this.brokerPubSubInfo.getBrokerPubPushedTopicInfo(brokerId, topic, result);
    }

    @Override
    public void getPubBrokerPushedTopicInfo(int brokerId, Tuple3<Boolean, Boolean, List<TopicInfo>> result) {
        this.brokerPubSubInfo.getPubBrokerPushedTopicInfo(brokerId, result);
    }
}

