/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.tubemq.server.master.web.action.screen;

import javax.servlet.http.HttpServletRequest;
import org.apache.inlong.tubemq.corebase.rv.ProcessResult;
import org.apache.inlong.tubemq.corebase.utils.TStringUtils;
import org.apache.inlong.tubemq.corerpc.exception.StandbyException;
import org.apache.inlong.tubemq.server.common.utils.WebParameterUtils;
import org.apache.inlong.tubemq.server.common.webbase.WebCallStatsHolder;
import org.apache.inlong.tubemq.server.common.webbase.WebMethodMapper;
import org.apache.inlong.tubemq.server.master.TMaster;
import org.apache.inlong.tubemq.server.master.metamanage.MetaDataService;
import org.apache.inlong.tubemq.server.master.web.handler.AbstractWebHandler;
import org.apache.inlong.tubemq.server.master.web.handler.WebAdminFlowRuleHandler;
import org.apache.inlong.tubemq.server.master.web.handler.WebAdminGroupCtrlHandler;
import org.apache.inlong.tubemq.server.master.web.handler.WebAdminTopicAuthHandler;
import org.apache.inlong.tubemq.server.master.web.handler.WebBrokerConfHandler;
import org.apache.inlong.tubemq.server.master.web.handler.WebGroupConsumeCtrlHandler;
import org.apache.inlong.tubemq.server.master.web.handler.WebGroupResCtrlHandler;
import org.apache.inlong.tubemq.server.master.web.handler.WebMasterInfoHandler;
import org.apache.inlong.tubemq.server.master.web.handler.WebOtherInfoHandler;
import org.apache.inlong.tubemq.server.master.web.handler.WebTopicCtrlHandler;
import org.apache.inlong.tubemq.server.master.web.handler.WebTopicDeployHandler;
import org.apache.inlong.tubemq.server.master.web.simplemvc.Action;
import org.apache.inlong.tubemq.server.master.web.simplemvc.RequestContext;

public class Webapi
implements Action {
    private final TMaster master;

    public Webapi(TMaster master) {
        this.master = master;
        this.registerHandler(new WebBrokerConfHandler(this.master));
        this.registerHandler(new WebTopicCtrlHandler(this.master));
        this.registerHandler(new WebTopicDeployHandler(this.master));
        this.registerHandler(new WebGroupConsumeCtrlHandler(this.master));
        this.registerHandler(new WebGroupResCtrlHandler(this.master));
        this.registerHandler(new WebMasterInfoHandler(this.master));
        this.registerHandler(new WebOtherInfoHandler(this.master));
        this.registerHandler(new WebAdminGroupCtrlHandler(this.master));
        this.registerHandler(new WebAdminTopicAuthHandler(this.master));
        this.registerHandler(new WebAdminFlowRuleHandler(this.master));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(RequestContext requestContext) {
        long startTime;
        String method;
        block12: {
            method = null;
            ProcessResult result = new ProcessResult();
            StringBuilder sBuffer = new StringBuilder();
            startTime = System.currentTimeMillis();
            try {
                HttpServletRequest req = requestContext.getReq();
                if (this.master.isStopped()) {
                    throw new Exception("Server is stopping...");
                }
                MetaDataService defMetaDataService = this.master.getMetaDataService();
                if (!defMetaDataService.isSelfMaster()) {
                    throw new StandbyException("Please send your request to the master Node.");
                }
                method = req.getParameter("method");
                String strCallbackFun = req.getParameter("callback");
                if (TStringUtils.isNotEmpty((String)strCallbackFun) && strCallbackFun.length() <= 128 && strCallbackFun.matches("^[_A-Za-z0-9]+$")) {
                    strCallbackFun = strCallbackFun.trim();
                }
                if (method == null) {
                    throw new Exception("Please take with method parameter!");
                }
                WebMethodMapper.WebApiRegInfo webApiRegInfo = WebMethodMapper.getWebApiRegInfo(method);
                if (webApiRegInfo == null) {
                    throw new Exception("unsupported method!");
                }
                if (webApiRegInfo.onlyMasterOp && defMetaDataService.isPrimaryNodeActive()) {
                    throw new Exception("DesignatedPrimary happened...please check if the other member is down");
                }
                if (!WebParameterUtils.validReqAuthorizeInfo(req, webApiRegInfo.needAuthToken, this.master, sBuffer, result)) {
                    throw new Exception(result.getErrMsg());
                }
                sBuffer = (StringBuilder)webApiRegInfo.method.invoke(webApiRegInfo.webHandler, req, sBuffer, result);
                if (TStringUtils.isEmpty((String)strCallbackFun)) {
                    requestContext.put("sb", sBuffer.toString());
                    break block12;
                }
                requestContext.put("sb", strCallbackFun + "(" + sBuffer.toString() + ")");
                requestContext.getResp().addHeader("Content-type", "text/plain");
                requestContext.getResp().addHeader("charset", "UTF-8");
            }
            catch (Throwable e) {
                try {
                    sBuffer.append("{\"result\":false,\"errCode\":400,\"errMsg\":\"Bad request from client, ").append(e.getMessage()).append("\"}");
                    requestContext.put("sb", sBuffer.toString());
                }
                catch (Throwable throwable) {
                    WebCallStatsHolder.addMethodCall(method, System.currentTimeMillis() - startTime);
                    throw throwable;
                }
                WebCallStatsHolder.addMethodCall(method, System.currentTimeMillis() - startTime);
            }
        }
        WebCallStatsHolder.addMethodCall(method, System.currentTimeMillis() - startTime);
    }

    private void registerHandler(AbstractWebHandler abstractWebHandler) {
        abstractWebHandler.registerWebApiMethod();
    }
}

