/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.tubemq.server.master.web.common;

import java.io.Serializable;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.inlong.tubemq.corebase.utils.TStringUtils;

public class BaseResult
implements Serializable {
    private static final long serialVersionUID = 8807356835558347735L;
    private static final Integer defaultPageSize = 20;
    private static final Integer defaultFirstPage = 1;
    private static final Integer defaultTotalItem = 0;
    private static final int MAX_PAGE_SIZE = 501;
    private Integer totalItem;
    private Integer pageSize;
    private Integer currentPage;
    private int startRow;
    private int endRow;
    private Map tempParam;
    private Object removeObject;
    private String ajaxPrefix;
    private String ajaxSuffix;
    private String charset;
    private String from;
    private boolean escape = true;
    private boolean jsEscape = false;

    public static Date parseDate(String dateTime, String format, Date def) {
        Date date = def;
        try {
            SimpleDateFormat formatter = new SimpleDateFormat(format);
            date = formatter.parse(dateTime);
        }
        catch (Exception e) {
            DateFormat f = DateFormat.getDateInstance();
            try {
                date = f.parse(dateTime);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return date;
    }

    public static String jsEncode(String str) {
        if (null == str) {
            return null;
        }
        char[] cs = str.toCharArray();
        StringBuilder sBuilder = new StringBuilder(str.length());
        for (int i = 0; i < cs.length; ++i) {
            int c = cs[i] & 0xFFFF;
            if (c >= 48 && c <= 57 || c >= 97 && c <= 122 || c >= 65 && c <= 90) {
                sBuilder.append(cs[i]);
                continue;
            }
            sBuilder.append('%');
            if (c > 255) {
                sBuilder.append('u');
            }
            sBuilder.append(Integer.toHexString(c));
        }
        return sBuilder.toString();
    }

    public static String jsDecode(String str) {
        if (null == str) {
            return null;
        }
        StringBuilder sBuilder = new StringBuilder(str.length());
        char[] cs = str.toCharArray();
        for (int i = 0; i < cs.length; ++i) {
            int c = cs[i] & 0xFFFF;
            if (c == 37) {
                if (cs[i + 1] == 'u') {
                    if (i + 6 > cs.length) {
                        sBuilder.append(cs[i]);
                        continue;
                    }
                    try {
                        char cc = (char)Integer.parseInt(new String(cs, i + 2, 4), 16);
                        sBuilder.append(cc);
                        i += 5;
                    }
                    catch (Exception e) {
                        sBuilder.append(cs[i]);
                    }
                    continue;
                }
                if (i + 3 > cs.length) {
                    sBuilder.append(cs[i]);
                    continue;
                }
                try {
                    char cc = (char)Integer.parseInt(new String(cs, i + 1, 2), 16);
                    sBuilder.append(cc);
                    i += 2;
                }
                catch (Exception e) {
                    sBuilder.append(cs[i]);
                }
                continue;
            }
            sBuilder.append(cs[i]);
        }
        return sBuilder.toString();
    }

    protected Integer getDefaultPageSize() {
        return defaultPageSize;
    }

    public boolean isFirstPage() {
        return this.getCurrentPage() == 1;
    }

    public int getPreviousPage() {
        int back = this.getCurrentPage() - 1;
        if (back <= 0) {
            back = 1;
        }
        return back;
    }

    public boolean isLastPage() {
        return this.getTotalPage() == this.getCurrentPage().intValue();
    }

    public int getNextPage() {
        int back = this.getCurrentPage() + 1;
        if (back > this.getTotalPage()) {
            back = this.getTotalPage();
        }
        return back;
    }

    public Integer getCurrentPage() {
        if (this.currentPage == null) {
            return defaultFirstPage;
        }
        return this.currentPage;
    }

    public void setCurrentPage(Integer cPage) {
        this.currentPage = cPage == null || cPage <= 0 ? null : cPage;
        this.setStartEndRow();
    }

    public void setCurrentPageString(String pageString) {
        if (this.isBlankString(pageString)) {
            this.setCurrentPage(defaultFirstPage);
        }
        try {
            Integer integer = new Integer(pageString);
            this.setCurrentPage(integer);
        }
        catch (NumberFormatException ignore) {
            this.setCurrentPage(defaultFirstPage);
        }
    }

    private void setStartEndRow() {
        this.startRow = this.getPageSize() * (this.getCurrentPage() - 1);
        this.endRow = this.startRow + this.getPageSize();
    }

    public Integer getPageSize() {
        if (this.pageSize == null) {
            return this.getDefaultPageSize();
        }
        return this.pageSize;
    }

    public void setPageSize(Integer pSize) {
        if (pSize == null || pSize < 0) {
            this.pageSize = null;
        } else {
            if (pSize > 501 || pSize < 1) {
                throw new IllegalArgumentException("The number of displayed pages per page ranges from 1~501");
            }
            this.pageSize = pSize;
        }
        this.setStartEndRow();
    }

    public boolean hasSetPageSize() {
        return this.pageSize != null;
    }

    public void setPageSizeString(String pageSizeString) {
        if (this.isBlankString(pageSizeString)) {
            return;
        }
        try {
            Integer integer = new Integer(pageSizeString);
            if (integer > 501 || integer < 1) {
                throw new IllegalArgumentException("The number of displayed pages per page ranges from 1~501");
            }
            this.setPageSize(integer);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    private boolean isBlankString(String pageSizeString) {
        if (pageSizeString == null) {
            return true;
        }
        return pageSizeString.trim().length() == 0;
    }

    public Integer getTotalItem() {
        if (this.totalItem == null) {
            return defaultTotalItem;
        }
        return this.totalItem;
    }

    public void setTotalItem(Integer tItem) {
        int lastPage;
        if (tItem == null) {
            throw new IllegalArgumentException("TotalItem can't be null.");
        }
        this.totalItem = tItem;
        int current = this.getCurrentPage();
        if (current > (lastPage = this.getTotalPage())) {
            this.setCurrentPage(new Integer(lastPage));
        }
    }

    public int getTotalPage() {
        int pgSize = this.getPageSize();
        int total = this.getTotalItem();
        int result = total / pgSize;
        if (total == 0 || total % pgSize != 0) {
            ++result;
        }
        return result;
    }

    public int getPageFirstItem() {
        int cPage = this.getCurrentPage();
        if (cPage == 1) {
            return 1;
        }
        int pgSize = this.getPageSize();
        return pgSize * --cPage + 1;
    }

    public int getPageLastItem() {
        int cPage = this.getCurrentPage();
        int pgSize = this.getPageSize();
        int assumeLast = pgSize * cPage;
        int totalItem = this.getTotalItem();
        return Math.min(assumeLast, totalItem);
    }

    public int getEndRow() {
        return this.endRow;
    }

    public void setEndRow(int endRow) {
        this.endRow = endRow;
    }

    public int getStartRow() {
        return this.startRow;
    }

    public void setStartRow(int startRow) {
        this.startRow = startRow;
    }

    protected String getSQLBlurValue(String value) {
        if (value == null) {
            return null;
        }
        return value + '%';
    }

    protected String formatDate(String dateString) {
        if (TStringUtils.isBlank((String)dateString)) {
            return null;
        }
        return dateString + " 00:00:00";
    }

    protected String addDateEndPostfix(String dateString) {
        if (TStringUtils.isBlank((String)dateString)) {
            return null;
        }
        return dateString + " 23:59:59";
    }

    protected String addDateStartPostfix(String dateString) {
        if (TStringUtils.isBlank((String)dateString)) {
            return null;
        }
        return dateString + " 00:00:00";
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }

    public String[] getParameters() {
        return new String[0];
    }

    public String getAjaxPrefix() {
        return this.ajaxPrefix;
    }

    public BaseResult setAjaxPrefix(String ajaxPrefix) {
        this.ajaxPrefix = ajaxPrefix;
        return this;
    }

    public String getAjaxSuffix() {
        return this.ajaxSuffix;
    }

    public BaseResult setAjaxSuffix(String ajaxSuffix) {
        this.ajaxSuffix = ajaxSuffix;
        return this;
    }

    public String getCharset() {
        return this.charset;
    }

    public BaseResult setCharset(String charset) {
        this.charset = charset;
        return this;
    }

    public BaseResult remove(Object key) {
        if (null == this.removeObject) {
            this.removeObject = new Object();
        }
        this.replace(key, this.removeObject);
        return this;
    }

    public BaseResult replace(Object key, Object val) {
        if (null != key && null != val) {
            if (null == this.tempParam) {
                this.tempParam = new HashMap(5);
            }
            this.tempParam.put(String.valueOf(key), val);
        }
        return this;
    }

    public String getFrom() {
        return this.from;
    }

    public void setFrom(String from) {
        this.from = from;
    }

    public boolean isEscape() {
        return this.escape;
    }

    public BaseResult setEscape(boolean escape) {
        this.escape = escape;
        return this;
    }

    public final boolean isJsEscape() {
        return this.jsEscape;
    }

    public final BaseResult setJsEscape(boolean jsEscape) {
        this.jsEscape = jsEscape;
        return this;
    }
}

