/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.tubemq.server.master.web.handler;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.apache.inlong.tubemq.corebase.cluster.TopicInfo;
import org.apache.inlong.tubemq.corebase.rv.ProcessResult;
import org.apache.inlong.tubemq.corebase.utils.Tuple2;
import org.apache.inlong.tubemq.corebase.utils.Tuple3;
import org.apache.inlong.tubemq.server.common.fielddef.WebFieldDef;
import org.apache.inlong.tubemq.server.common.statusdef.TopicStatus;
import org.apache.inlong.tubemq.server.common.statusdef.TopicStsChgType;
import org.apache.inlong.tubemq.server.common.utils.WebParameterUtils;
import org.apache.inlong.tubemq.server.master.TMaster;
import org.apache.inlong.tubemq.server.master.metamanage.DataOpErrCode;
import org.apache.inlong.tubemq.server.master.metamanage.metastore.dao.entity.BaseEntity;
import org.apache.inlong.tubemq.server.master.metamanage.metastore.dao.entity.BrokerConfEntity;
import org.apache.inlong.tubemq.server.master.metamanage.metastore.dao.entity.ClusterSettingEntity;
import org.apache.inlong.tubemq.server.master.metamanage.metastore.dao.entity.GroupConsumeCtrlEntity;
import org.apache.inlong.tubemq.server.master.metamanage.metastore.dao.entity.TopicCtrlEntity;
import org.apache.inlong.tubemq.server.master.metamanage.metastore.dao.entity.TopicDeployEntity;
import org.apache.inlong.tubemq.server.master.metamanage.metastore.dao.entity.TopicPropGroup;
import org.apache.inlong.tubemq.server.master.nodemanage.nodebroker.BrokerRunManager;
import org.apache.inlong.tubemq.server.master.nodemanage.nodebroker.BrokerRunStatusInfo;
import org.apache.inlong.tubemq.server.master.web.handler.AbstractWebHandler;
import org.apache.inlong.tubemq.server.master.web.handler.TopicProcessResult;

public class WebTopicDeployHandler
extends AbstractWebHandler {
    public WebTopicDeployHandler(TMaster master) {
        super(master);
    }

    @Override
    public void registerWebApiMethod() {
        this.registerQueryWebMethod("admin_query_topic_deploy_info", "adminNewQueryTopicCfgAndRunInfo");
        this.registerQueryWebMethod("admin_query_topic_deploy_configure", "innQueryTopicDeployConfInfo");
        this.registerQueryWebMethod("admin_query_broker_topic_config_info", "adminQueryBrokerTopicCfgAndRunInfo");
        this.registerQueryWebMethod("admin_query_topic_broker_config_info", "adminQueryTopicBrokerCfgAndRunInfo");
        this.registerQueryWebMethod("admin_query_deployed_topics", "adminQuerySimpleTopicName");
        this.registerQueryWebMethod("admin_query_deployed_broker_ids", "adminQuerySimpleBrokerId");
        this.registerModifyWebMethod("admin_add_topic_deploy_info", "adminAddTopicDeployInfo");
        this.registerModifyWebMethod("admin_bath_add_topic_deploy_info", "adminBatchAddTopicDeployInfo");
        this.registerModifyWebMethod("admin_update_topic_deploy_info", "adminModifyTopicDeployInfo");
        this.registerModifyWebMethod("admin_batch_update_topic_deploy_info", "adminBatchUpdTopicDeployInfo");
        this.registerModifyWebMethod("admin_delete_topic_deploy_info", "adminDelTopicDeployInfo");
        this.registerModifyWebMethod("admin_redo_deleted_topic_deploy_info", "adminRedoDeletedTopicDeployInfo");
        this.registerModifyWebMethod("admin_remove_topic_deploy_info", "adminRmvTopicDeployInfo");
        this.registerQueryWebMethod("admin_query_topic_info", "adminOldQueryTopicCfgAndRunInfo");
        this.registerModifyWebMethod("admin_add_new_topic_record", "adminAddTopicDeployInfo");
        this.registerModifyWebMethod("admin_bath_add_new_topic_record", "adminBatchAddTopicDeployInfo");
        this.registerModifyWebMethod("admin_modify_topic_info", "adminModifyTopicDeployInfo");
        this.registerModifyWebMethod("admin_delete_topic_info", "adminDelTopicDeployInfo");
        this.registerModifyWebMethod("admin_redo_deleted_topic_info", "adminRedoDeletedTopicDeployInfo");
        this.registerModifyWebMethod("admin_remove_topic_info", "adminRmvTopicDeployInfo");
    }

    public StringBuilder adminNewQueryTopicCfgAndRunInfo(HttpServletRequest req, StringBuilder sBuffer, ProcessResult result) {
        return this.innQueryTopicConfAndRunInfo(req, sBuffer, result, true);
    }

    public StringBuilder adminOldQueryTopicCfgAndRunInfo(HttpServletRequest req, StringBuilder sBuffer, ProcessResult result) {
        return this.innQueryTopicConfAndRunInfo(req, sBuffer, result, false);
    }

    public StringBuilder adminAddTopicDeployInfo(HttpServletRequest req, StringBuilder sBuffer, ProcessResult result) {
        return this.innAddOrUpdTopicDeployInfo(req, sBuffer, result, true);
    }

    public StringBuilder adminModifyTopicDeployInfo(HttpServletRequest req, StringBuilder sBuffer, ProcessResult result) {
        return this.innAddOrUpdTopicDeployInfo(req, sBuffer, result, false);
    }

    public StringBuilder adminBatchAddTopicDeployInfo(HttpServletRequest req, StringBuilder sBuffer, ProcessResult result) {
        return this.innBatchAddOrUpdTopicDeployInfo(req, sBuffer, result, true);
    }

    public StringBuilder adminBatchUpdTopicDeployInfo(HttpServletRequest req, StringBuilder sBuffer, ProcessResult result) {
        return this.innBatchAddOrUpdTopicDeployInfo(req, sBuffer, result, false);
    }

    public StringBuilder adminDelTopicDeployInfo(HttpServletRequest req, StringBuilder sBuffer, ProcessResult result) {
        return this.innModifyTopicDeployStatusInfo(req, sBuffer, result, TopicStsChgType.STATUS_CHANGE_SOFT_DELETE);
    }

    public StringBuilder adminRmvTopicDeployInfo(HttpServletRequest req, StringBuilder sBuffer, ProcessResult result) {
        return this.innModifyTopicDeployStatusInfo(req, sBuffer, result, TopicStsChgType.STATUS_CHANGE_REMOVE);
    }

    public StringBuilder adminRedoDeletedTopicDeployInfo(HttpServletRequest req, StringBuilder sBuffer, ProcessResult result) {
        return this.innModifyTopicDeployStatusInfo(req, sBuffer, result, TopicStsChgType.STATUS_CHANGE_REDO_SFDEL);
    }

    public StringBuilder adminQueryBrokerTopicCfgAndRunInfo(HttpServletRequest req, StringBuilder sBuffer, ProcessResult result) {
        if (!WebParameterUtils.getStringParamValue(req, WebFieldDef.COMPSTOPICNAME, false, null, sBuffer, result)) {
            WebParameterUtils.buildFailResult(sBuffer, result.getErrMsg());
            return sBuffer;
        }
        Set topicNameSet = (Set)result.getRetData();
        if (!WebParameterUtils.getIntParamValue(req, WebFieldDef.COMPSBROKERID, false, sBuffer, result)) {
            WebParameterUtils.buildFailResult(sBuffer, result.getErrMsg());
            return sBuffer;
        }
        Set brokerIdSet = (Set)result.getRetData();
        Map<Integer, List<TopicDeployEntity>> queryResult = this.defMetaDataService.getTopicDeployInfoMap(topicNameSet, brokerIdSet);
        int recordCount = 0;
        int topicTotalCfgCnt = 0;
        int storeTotalCfgCnt = 0;
        int partTotalCfgCnt = 0;
        int topicAccPubTotalCnt = 0;
        int topicAccSubTotalCnt = 0;
        int storeAccPubTotalCnt = 0;
        int storeAccSubTotalCnt = 0;
        int partAccPubTotalCnt = 0;
        int partAccSubTotalCnt = 0;
        int tmpPartTtlCount = 0;
        Tuple2 publishTuple = new Tuple2();
        BrokerRunManager brokerRunManager = this.master.getBrokerRunManager();
        WebParameterUtils.buildSuccessWithDataRetBegin(sBuffer);
        for (Map.Entry<Integer, List<TopicDeployEntity>> entry : queryResult.entrySet()) {
            BrokerConfEntity brokerConf;
            if (entry.getKey() == null || entry.getValue() == null || (brokerConf = this.defMetaDataService.getBrokerConfByBrokerId(entry.getKey())) == null) continue;
            if (recordCount++ > 0) {
                sBuffer.append(",");
            }
            topicTotalCfgCnt = 0;
            storeTotalCfgCnt = 0;
            partTotalCfgCnt = 0;
            topicAccPubTotalCnt = 0;
            topicAccSubTotalCnt = 0;
            storeAccPubTotalCnt = 0;
            storeAccSubTotalCnt = 0;
            partAccPubTotalCnt = 0;
            partAccSubTotalCnt = 0;
            List<TopicDeployEntity> topicDeployInfo = entry.getValue();
            String strManageStatus = brokerConf.getManageStatus().getDescription();
            BrokerRunStatusInfo runStatusInfo = brokerRunManager.getBrokerRunStatusInfo(entry.getKey());
            brokerRunManager.getBrokerPublishStatus(entry.getKey(), (Tuple2<Boolean, Boolean>)publishTuple);
            for (TopicDeployEntity topicEntity : topicDeployInfo) {
                if (topicEntity == null) continue;
                ++topicTotalCfgCnt;
                storeTotalCfgCnt += topicEntity.getNumTopicStores();
                tmpPartTtlCount = topicEntity.getNumTopicStores() * topicEntity.getNumPartitions();
                partTotalCfgCnt += tmpPartTtlCount;
                if (runStatusInfo == null) continue;
                if (((Boolean)publishTuple.getF0()).booleanValue() && topicEntity.isAcceptPublish()) {
                    ++topicAccPubTotalCnt;
                    storeAccPubTotalCnt += topicEntity.getNumTopicStores();
                    partAccPubTotalCnt += tmpPartTtlCount;
                }
                if (!((Boolean)publishTuple.getF1()).booleanValue() || !topicEntity.isAcceptSubscribe()) continue;
                ++topicAccSubTotalCnt;
                storeAccSubTotalCnt += topicEntity.getNumTopicStores();
                partAccSubTotalCnt += tmpPartTtlCount;
            }
            sBuffer.append("{\"brokerId\":").append(brokerConf.getBrokerId()).append(",\"brokerIp\":\"").append(brokerConf.getBrokerIp()).append("\",\"brokerPort\":").append(brokerConf.getBrokerPort()).append(",\"manageStatus\":\"").append(strManageStatus).append("\",\"acceptPublish\":").append(publishTuple.getF0()).append(",\"acceptSubscribe\":").append(publishTuple.getF1());
            if (runStatusInfo == null) {
                sBuffer.append(",\"nodeRunInfo\":\"-\"");
            } else {
                sBuffer.append(",\"nodeRunInfo\":\"running\"");
            }
            sBuffer.append(",\"topicTotalCfgCnt\":").append(topicTotalCfgCnt).append(",\"storeTotalCfgCnt\":").append(storeTotalCfgCnt).append(",\"partTotalCfgCnt\":").append(partTotalCfgCnt).append(",\"topicAccPubTotalCnt\":").append(topicAccPubTotalCnt).append(",\"topicAccSubTotalCnt\":").append(topicAccSubTotalCnt).append(",\"storeAccPubTotalCnt\":").append(storeAccPubTotalCnt).append(",\"storeAccSubTotalCnt\":").append(storeAccSubTotalCnt).append(",\"partAccPubTotalCnt\":").append(partAccPubTotalCnt).append(",\"partAccSubTotalCnt\":").append(partAccSubTotalCnt).append("}");
        }
        WebParameterUtils.buildSuccessWithDataRetEnd(sBuffer, recordCount);
        return sBuffer;
    }

    public StringBuilder adminQueryTopicBrokerCfgAndRunInfo(HttpServletRequest req, StringBuilder sBuffer, ProcessResult result) {
        if (!WebParameterUtils.getIntParamValue(req, WebFieldDef.COMPSBROKERID, false, sBuffer, result)) {
            WebParameterUtils.buildFailResult(sBuffer, result.getErrMsg());
            return sBuffer;
        }
        Set brokerIds = (Set)result.getRetData();
        if (!WebParameterUtils.getStringParamValue(req, WebFieldDef.COMPSTOPICNAME, false, null, sBuffer, result)) {
            WebParameterUtils.buildFailResult(sBuffer, result.getErrMsg());
            return sBuffer;
        }
        Set topicNameSet = (Set)result.getRetData();
        Map<String, List<TopicDeployEntity>> topicConfMap = this.defMetaDataService.getTopicConfMapByTopicAndBrokerIds(topicNameSet, brokerIds);
        BrokerRunManager brokerRunManager = this.master.getBrokerRunManager();
        int recordCount = 0;
        int brokerTotalCfgCnt = 0;
        int storeTotalCfgCnt = 0;
        int partTotalCfgCnt = 0;
        int tmpPartTtlCount = 0;
        int brokerTotalRunCnt = 0;
        int storeTotalRunCnt = 0;
        int partTotalRunCnt = 0;
        int brokerAccPubTotalCnt = 0;
        int brokerAccSubTotalCnt = 0;
        int storeAccPubTotalCnt = 0;
        int storeAccSubTotalCnt = 0;
        int partAccPubTotalCnt = 0;
        int partAccSubTotalCnt = 0;
        boolean hasRunConfig = false;
        boolean topicSrvAccPubStatus = false;
        boolean topicSrvAccSubStatus = false;
        boolean enableAuthControl = false;
        Tuple3 topicInfoTuple = new Tuple3();
        WebParameterUtils.buildSuccessWithDataRetBegin(sBuffer);
        for (Map.Entry<String, List<TopicDeployEntity>> entry : topicConfMap.entrySet()) {
            if (recordCount++ > 0) {
                sBuffer.append(",");
            }
            brokerTotalCfgCnt = 0;
            brokerTotalRunCnt = 0;
            storeTotalCfgCnt = 0;
            storeTotalRunCnt = 0;
            partTotalCfgCnt = 0;
            partTotalRunCnt = 0;
            brokerAccPubTotalCnt = 0;
            brokerAccSubTotalCnt = 0;
            storeAccPubTotalCnt = 0;
            storeAccSubTotalCnt = 0;
            partAccPubTotalCnt = 0;
            partAccSubTotalCnt = 0;
            topicSrvAccPubStatus = false;
            topicSrvAccSubStatus = false;
            enableAuthControl = false;
            for (TopicDeployEntity entity : entry.getValue()) {
                BrokerConfEntity brokerConfEntity = this.defMetaDataService.getBrokerConfByBrokerId(entity.getBrokerId());
                if (brokerConfEntity == null) continue;
                TopicPropGroup topicProps = entity.getTopicProps();
                brokerRunManager.getPubBrokerTopicInfo(entity.getBrokerId(), entity.getTopicName(), (Tuple3<Boolean, Boolean, TopicInfo>)topicInfoTuple);
                ++brokerTotalCfgCnt;
                storeTotalCfgCnt += topicProps.getNumTopicStores();
                partTotalCfgCnt += topicProps.getNumPartitions() * topicProps.getNumTopicStores();
                if (topicInfoTuple.getF2() == null) continue;
                hasRunConfig = false;
                tmpPartTtlCount = ((TopicInfo)topicInfoTuple.getF2()).getPartitionNum() * ((TopicInfo)topicInfoTuple.getF2()).getTopicStoreNum();
                if (((Boolean)topicInfoTuple.getF0()).booleanValue() && ((TopicInfo)topicInfoTuple.getF2()).isAcceptPublish()) {
                    hasRunConfig = true;
                    topicSrvAccPubStatus = true;
                    ++brokerAccPubTotalCnt;
                    storeAccPubTotalCnt += ((TopicInfo)topicInfoTuple.getF2()).getTopicStoreNum();
                    partAccPubTotalCnt += tmpPartTtlCount;
                }
                if (((Boolean)topicInfoTuple.getF1()).booleanValue() && ((TopicInfo)topicInfoTuple.getF2()).isAcceptSubscribe()) {
                    hasRunConfig = true;
                    topicSrvAccSubStatus = true;
                    ++brokerAccSubTotalCnt;
                    storeAccSubTotalCnt += ((TopicInfo)topicInfoTuple.getF2()).getTopicStoreNum();
                    partAccSubTotalCnt += tmpPartTtlCount;
                }
                if (!hasRunConfig) continue;
                ++brokerTotalRunCnt;
                storeTotalRunCnt += ((TopicInfo)topicInfoTuple.getF2()).getTopicStoreNum();
                partTotalRunCnt += tmpPartTtlCount;
            }
            TopicCtrlEntity authEntity = this.defMetaDataService.getTopicCtrlByTopicName(entry.getKey());
            if (authEntity != null) {
                enableAuthControl = authEntity.isAuthCtrlEnable();
            }
            sBuffer.append("{\"topicName\":\"").append(entry.getKey()).append("\",\"brokerTotalCfgCnt\":").append(brokerTotalCfgCnt).append(",\"brokerTotalRunCnt\":").append(brokerTotalRunCnt).append(",\"storeTotalCfgCnt\":").append(storeTotalCfgCnt).append(",\"storeTotalRunCnt\":").append(storeTotalRunCnt).append(",\"partTotalCfgCnt\":").append(partTotalCfgCnt).append(",\"partTotalRunCnt\":").append(partTotalRunCnt).append(",\"brokerAccPubTotalCnt\":").append(brokerAccPubTotalCnt).append(",\"brokerAccSubTotalCnt\":").append(brokerAccSubTotalCnt).append(",\"storeAccPubTotalCnt\":").append(storeAccPubTotalCnt).append(",\"storeAccSubTotalCnt\":").append(storeAccSubTotalCnt).append(",\"partAccPubTotalCnt\":").append(partAccPubTotalCnt).append(",\"partAccSubTotalCnt\":").append(partAccSubTotalCnt).append(",\"topicSrvAccPubStatus\":").append(topicSrvAccPubStatus).append(",\"topicSrvAccSubStatus\":").append(topicSrvAccSubStatus).append(",\"enableAuthControl\":").append(enableAuthControl).append("}");
        }
        WebParameterUtils.buildSuccessWithDataRetEnd(sBuffer, recordCount);
        return sBuffer;
    }

    public StringBuilder adminQuerySimpleTopicName(HttpServletRequest req, StringBuilder sBuffer, ProcessResult result) {
        if (!WebParameterUtils.getIntParamValue(req, WebFieldDef.COMPSBROKERID, false, sBuffer, result)) {
            WebParameterUtils.buildFailResult(sBuffer, result.getErrMsg());
            return sBuffer;
        }
        Set brokerIds = (Set)result.getRetData();
        Map<Integer, Set<String>> brokerTopicConfigMap = this.defMetaDataService.getBrokerTopicConfigInfo(brokerIds);
        int dataCount = 0;
        int topicCnt = 0;
        WebParameterUtils.buildSuccessWithDataRetBegin(sBuffer);
        for (Map.Entry<Integer, Set<String>> entry : brokerTopicConfigMap.entrySet()) {
            if (dataCount++ > 0) {
                sBuffer.append(",");
            }
            topicCnt = 0;
            sBuffer.append("{\"brokerId\":").append(entry.getKey()).append(",\"topicName\":[");
            for (String topic : entry.getValue()) {
                if (topicCnt++ > 0) {
                    sBuffer.append(",");
                }
                sBuffer.append("\"").append(topic).append("\"");
            }
            sBuffer.append("],\"topicCount\":").append(topicCnt).append("}");
        }
        WebParameterUtils.buildSuccessWithDataRetEnd(sBuffer, dataCount);
        return sBuffer;
    }

    public StringBuilder adminQuerySimpleBrokerId(HttpServletRequest req, StringBuilder sBuffer, ProcessResult result) {
        if (!WebParameterUtils.getStringParamValue(req, WebFieldDef.COMPSTOPICNAME, false, null, sBuffer, result)) {
            WebParameterUtils.buildFailResult(sBuffer, result.getErrMsg());
            return sBuffer;
        }
        Set topicNameSet = (Set)result.getRetData();
        if (!WebParameterUtils.getBooleanParamValue(req, WebFieldDef.WITHIP, false, false, sBuffer, result)) {
            WebParameterUtils.buildFailResult(sBuffer, result.getErrMsg());
            return sBuffer;
        }
        boolean withIp = (Boolean)result.getRetData();
        Map<String, Map<Integer, String>> topicBrokerConfigMap = this.defMetaDataService.getTopicBrokerConfigInfo(topicNameSet);
        int dataCount = 0;
        WebParameterUtils.buildSuccessWithDataRetBegin(sBuffer);
        for (Map.Entry<String, Map<Integer, String>> entry : topicBrokerConfigMap.entrySet()) {
            if (dataCount++ > 0) {
                sBuffer.append(",");
            }
            sBuffer.append("{\"topicName\":\"").append(entry.getKey()).append("\",\"brokerInfo\":[");
            int topicCnt = 0;
            Map<Integer, String> brokerMap = entry.getValue();
            if (withIp) {
                for (Map.Entry<Integer, String> entry1 : brokerMap.entrySet()) {
                    if (topicCnt++ > 0) {
                        sBuffer.append(",");
                    }
                    sBuffer.append("{\"brokerId\":").append(entry1.getKey()).append(",\"brokerIp\":\"").append(entry1.getValue()).append("\"}");
                }
            } else {
                for (Map.Entry<Integer, String> entry1 : brokerMap.entrySet()) {
                    if (topicCnt++ > 0) {
                        sBuffer.append(",");
                    }
                    sBuffer.append(entry1.getKey());
                }
            }
            sBuffer.append("],\"brokerCnt\":").append(topicCnt).append("}");
        }
        WebParameterUtils.buildSuccessWithDataRetEnd(sBuffer, dataCount);
        return sBuffer;
    }

    public StringBuilder innQueryTopicDeployConfInfo(HttpServletRequest req, StringBuilder sBuffer, ProcessResult result) {
        TopicDeployEntity qryEntity = new TopicDeployEntity();
        if (!WebParameterUtils.getQueriedOperateInfo(req, qryEntity, sBuffer, result)) {
            WebParameterUtils.buildFailResult(sBuffer, result.getErrMsg());
            return sBuffer;
        }
        if (!WebParameterUtils.getStringParamValue(req, WebFieldDef.COMPSTOPICNAME, false, null, sBuffer, result)) {
            WebParameterUtils.buildFailResult(sBuffer, result.getErrMsg());
            return sBuffer;
        }
        Set topicNameSet = (Set)result.getRetData();
        if (!WebParameterUtils.getIntParamValue(req, WebFieldDef.COMPSBROKERID, false, sBuffer, result)) {
            WebParameterUtils.buildFailResult(sBuffer, result.getErrMsg());
            return sBuffer;
        }
        Set brokerIdSet = (Set)result.getRetData();
        if (!WebParameterUtils.getIntParamValue(req, WebFieldDef.BROKERPORT, false, -2, 1, sBuffer, result)) {
            WebParameterUtils.buildFailResult(sBuffer, result.getErrMsg());
            return sBuffer;
        }
        int brokerPort = (Integer)result.getRetData();
        if (!WebParameterUtils.getTopicPropInfo(req, null, sBuffer, result)) {
            WebParameterUtils.buildFailResult(sBuffer, result.getErrMsg());
            return sBuffer;
        }
        TopicPropGroup topicProps = (TopicPropGroup)result.getRetData();
        if (!WebParameterUtils.getTopicStatusParamValue(req, false, TopicStatus.STATUS_TOPIC_UNDEFINED, sBuffer, result)) {
            WebParameterUtils.buildFailResult(sBuffer, result.getErrMsg());
            return sBuffer;
        }
        TopicStatus topicStatus = (TopicStatus)((Object)result.getRetData());
        qryEntity.updModifyInfo(qryEntity.getDataVerId(), -2, brokerPort, null, topicStatus, topicProps);
        Map<String, List<TopicDeployEntity>> topicDeployInfoMap = this.defMetaDataService.getTopicDeployInfoMap(topicNameSet, brokerIdSet, qryEntity);
        int totalCnt = 0;
        WebParameterUtils.buildSuccessWithDataRetBegin(sBuffer);
        for (Map.Entry<String, List<TopicDeployEntity>> entry : topicDeployInfoMap.entrySet()) {
            if (entry.getValue() == null || entry.getValue().isEmpty()) continue;
            for (TopicDeployEntity entity : entry.getValue()) {
                if (totalCnt++ > 0) {
                    sBuffer.append(",");
                }
                entity.toWebJsonStr(sBuffer, true, true);
            }
        }
        WebParameterUtils.buildSuccessWithDataRetEnd(sBuffer, totalCnt);
        return sBuffer;
    }

    private StringBuilder innQueryTopicConfAndRunInfo(HttpServletRequest req, StringBuilder sBuffer, ProcessResult result, boolean isNewVer) {
        TopicDeployEntity qryEntity = new TopicDeployEntity();
        if (!WebParameterUtils.getQueriedOperateInfo(req, qryEntity, sBuffer, result)) {
            WebParameterUtils.buildFailResult(sBuffer, result.getErrMsg());
            return sBuffer;
        }
        if (!WebParameterUtils.getStringParamValue(req, WebFieldDef.COMPSTOPICNAME, false, null, sBuffer, result)) {
            WebParameterUtils.buildFailResult(sBuffer, result.getErrMsg());
            return sBuffer;
        }
        Set topicNameSet = (Set)result.getRetData();
        if (!WebParameterUtils.getIntParamValue(req, WebFieldDef.COMPSBROKERID, false, sBuffer, result)) {
            WebParameterUtils.buildFailResult(sBuffer, result.getErrMsg());
            return sBuffer;
        }
        Set brokerIdSet = (Set)result.getRetData();
        if (!WebParameterUtils.getIntParamValue(req, WebFieldDef.BROKERPORT, false, -2, 1, sBuffer, result)) {
            WebParameterUtils.buildFailResult(sBuffer, result.getErrMsg());
            return sBuffer;
        }
        int brokerPort = (Integer)result.getRetData();
        if (!WebParameterUtils.getTopicPropInfo(req, null, sBuffer, result)) {
            WebParameterUtils.buildFailResult(sBuffer, result.getErrMsg());
            return sBuffer;
        }
        TopicPropGroup topicProps = (TopicPropGroup)result.getRetData();
        if (!WebParameterUtils.getBooleanParamValue(req, WebFieldDef.WITHGROUPAUTHINFO, false, false, sBuffer, result)) {
            WebParameterUtils.buildFailResult(sBuffer, result.getErrMsg());
            return sBuffer;
        }
        Boolean withGroupAuthInfo = (Boolean)result.getRetData();
        if (!WebParameterUtils.getTopicStatusParamValue(req, false, TopicStatus.STATUS_TOPIC_UNDEFINED, sBuffer, result)) {
            WebParameterUtils.buildFailResult(sBuffer, result.getErrMsg());
            return sBuffer;
        }
        TopicStatus topicStatus = (TopicStatus)((Object)result.getRetData());
        qryEntity.updModifyInfo(qryEntity.getDataVerId(), -2, brokerPort, null, topicStatus, topicProps);
        Map<String, List<TopicDeployEntity>> topicDeployInfoMap = this.defMetaDataService.getTopicDeployInfoMap(topicNameSet, brokerIdSet, qryEntity);
        if (isNewVer) {
            return this.buildNewQueryResult(withGroupAuthInfo, sBuffer, topicDeployInfoMap);
        }
        return this.buildOldQueryResult(sBuffer, topicDeployInfoMap);
    }

    private StringBuilder buildOldQueryResult(StringBuilder sBuffer, Map<String, List<TopicDeployEntity>> topicDeployInfoMap) {
        int totalCnt = 0;
        int itemCount = 0;
        int condStatusId = 1;
        int maxMsgSizeInMB = 0;
        int totalCfgNumPartCount = 0;
        int totalRunNumPartCount = 0;
        boolean isSrvAcceptPublish = false;
        boolean isSrvAcceptSubscribe = false;
        Tuple3 topicInfoTuple = new Tuple3();
        BrokerRunManager brokerRunManager = this.master.getBrokerRunManager();
        ClusterSettingEntity defSetting = this.defMetaDataService.getClusterDefSetting(false);
        WebParameterUtils.buildSuccessWithDataRetBegin(sBuffer);
        for (Map.Entry<String, List<TopicDeployEntity>> entry : topicDeployInfoMap.entrySet()) {
            totalCfgNumPartCount = 0;
            totalRunNumPartCount = 0;
            isSrvAcceptPublish = false;
            isSrvAcceptSubscribe = false;
            TopicCtrlEntity ctrlEntity = this.defMetaDataService.getTopicCtrlByTopicName(entry.getKey());
            if (ctrlEntity == null) continue;
            if (totalCnt++ > 0) {
                sBuffer.append(",");
            }
            maxMsgSizeInMB = defSetting.getMaxMsgSizeInMB();
            if (ctrlEntity.getMaxMsgSizeInMB() != -2) {
                maxMsgSizeInMB = ctrlEntity.getMaxMsgSizeInMB();
            }
            boolean enableAuthCtrl = ctrlEntity.getAuthCtrlStatus().isEnable();
            sBuffer.append("{\"topicName\":\"").append(entry.getKey()).append("\",\"maxMsgSizeInMB\":").append(maxMsgSizeInMB).append(",\"topicInfo\":[");
            itemCount = 0;
            for (TopicDeployEntity entity : entry.getValue()) {
                if (itemCount++ > 0) {
                    sBuffer.append(",");
                }
                totalCfgNumPartCount += entity.getNumPartitions() * entity.getNumTopicStores();
                entity.toWebJsonStr(sBuffer, true, false);
                sBuffer.append(",\"runInfo\":{");
                String strManageStatus = "-";
                BrokerConfEntity brokerConfEntity = this.defMetaDataService.getBrokerConfByBrokerId(entity.getBrokerId());
                if (brokerConfEntity != null) {
                    strManageStatus = brokerConfEntity.getManageStatus().getDescription();
                }
                brokerRunManager.getPubBrokerTopicInfo(entity.getBrokerId(), entity.getTopicName(), (Tuple3<Boolean, Boolean, TopicInfo>)topicInfoTuple);
                if (topicInfoTuple.getF2() == null) {
                    sBuffer.append("\"acceptPublish\":\"-\"").append(",\"acceptSubscribe\":\"-\"").append(",\"numPartitions\":\"-\"").append(",\"brokerManageStatus\":\"-\"");
                } else {
                    if (((Boolean)topicInfoTuple.getF0()).booleanValue()) {
                        sBuffer.append("\"acceptPublish\":").append(((TopicInfo)topicInfoTuple.getF2()).isAcceptPublish());
                        if (((TopicInfo)topicInfoTuple.getF2()).isAcceptPublish()) {
                            isSrvAcceptPublish = true;
                        }
                    } else {
                        sBuffer.append("\"acceptPublish\":false");
                    }
                    if (((Boolean)topicInfoTuple.getF1()).booleanValue()) {
                        sBuffer.append(",\"acceptSubscribe\":").append(((TopicInfo)topicInfoTuple.getF2()).isAcceptSubscribe());
                        if (((TopicInfo)topicInfoTuple.getF2()).isAcceptSubscribe()) {
                            isSrvAcceptSubscribe = true;
                        }
                    } else {
                        sBuffer.append(",\"acceptSubscribe\":false");
                    }
                    totalRunNumPartCount += ((TopicInfo)topicInfoTuple.getF2()).getPartitionNum() * ((TopicInfo)topicInfoTuple.getF2()).getTopicStoreNum();
                    sBuffer.append(",\"numPartitions\":").append(((TopicInfo)topicInfoTuple.getF2()).getPartitionNum()).append(",\"numTopicStores\":").append(((TopicInfo)topicInfoTuple.getF2()).getTopicStoreNum()).append(",\"brokerManageStatus\":\"").append(strManageStatus).append("\"");
                }
                sBuffer.append("}}");
            }
            sBuffer.append("],\"infoCount\":").append(itemCount).append(",\"totalCfgNumPart\":").append(totalCfgNumPartCount).append(",\"isSrvAcceptPublish\":").append(isSrvAcceptPublish).append(",\"isSrvAcceptSubscribe\":").append(isSrvAcceptSubscribe).append(",\"totalRunNumPartCount\":").append(totalRunNumPartCount).append(",\"authData\":{");
            if (enableAuthCtrl) {
                sBuffer.append("\"enableAuthControl\":").append(enableAuthCtrl).append(",\"createUser\":\"").append(ctrlEntity.getModifyUser()).append("\",\"createDate\":\"").append(ctrlEntity.getModifyDateStr()).append("\",\"authConsumeGroup\":[");
                itemCount = 0;
                List<GroupConsumeCtrlEntity> groupCtrlInfoLst = this.defMetaDataService.getConsumeCtrlByTopic(entry.getKey());
                for (GroupConsumeCtrlEntity groupEntity : groupCtrlInfoLst) {
                    if (itemCount++ > 0) {
                        sBuffer.append(",");
                    }
                    sBuffer.append("{\"groupName\":\"").append(groupEntity.getGroupName()).append("\",\"createUser\":\"").append(groupEntity.getCreateUser()).append("\",\"createDate\":\"").append(groupEntity.getCreateDateStr()).append("\",\"modifyUser\":\"").append(groupEntity.getModifyUser()).append("\",\"modifyDate\":\"").append(groupEntity.getModifyDateStr()).append("\"}");
                }
                sBuffer.append("],\"groupCount\":").append(itemCount).append(",\"authFilterCondSet\":[");
                itemCount = 0;
                for (GroupConsumeCtrlEntity groupEntity : groupCtrlInfoLst) {
                    if (itemCount++ > 0) {
                        sBuffer.append(",");
                    }
                    condStatusId = 0;
                    if (groupEntity.getFilterEnable().isEnable()) {
                        condStatusId = 2;
                    }
                    sBuffer.append("{\"groupName\":\"").append(groupEntity.getGroupName()).append("\",\"condStatus\":").append(condStatusId);
                    if (!groupEntity.getFilterEnable().isEnable()) {
                        sBuffer.append(",\"filterConds\":\"\"");
                    } else {
                        sBuffer.append(",\"filterConds\":\"").append(groupEntity.getFilterCondStr()).append("\"");
                    }
                    sBuffer.append(",\"createDate\":\"").append(groupEntity.getCreateDateStr()).append("\",\"modifyUser\":\"").append(groupEntity.getModifyUser()).append("\",\"modifyDate\":\"").append(groupEntity.getModifyDateStr()).append("\"}");
                }
                sBuffer.append("],\"filterCount\":").append(itemCount);
            }
            sBuffer.append("}}");
        }
        WebParameterUtils.buildSuccessWithDataRetEnd(sBuffer, totalCnt);
        return sBuffer;
    }

    private StringBuilder buildNewQueryResult(boolean withAuthInfo, StringBuilder sBuffer, Map<String, List<TopicDeployEntity>> topicDeployMap) {
        int totalCnt = 0;
        int itemCount = 0;
        int totalCfgNumPartCount = 0;
        int totalRunNumPartCount = 0;
        boolean isSrvAcceptPublish = false;
        boolean isSrvAcceptSubscribe = false;
        Tuple3 topicInfoTuple = new Tuple3();
        BrokerRunManager brokerRunManager = this.master.getBrokerRunManager();
        WebParameterUtils.buildSuccessWithDataRetBegin(sBuffer);
        for (Map.Entry<String, List<TopicDeployEntity>> entry : topicDeployMap.entrySet()) {
            totalCfgNumPartCount = 0;
            totalRunNumPartCount = 0;
            isSrvAcceptPublish = false;
            isSrvAcceptSubscribe = false;
            TopicCtrlEntity ctrlEntity = this.defMetaDataService.getTopicCtrlByTopicName(entry.getKey());
            if (ctrlEntity == null) continue;
            if (totalCnt++ > 0) {
                sBuffer.append(",");
            }
            ctrlEntity.toWebJsonStr(sBuffer, true, false);
            sBuffer.append(",\"deployInfo\":[");
            itemCount = 0;
            for (TopicDeployEntity entity : entry.getValue()) {
                if (itemCount++ > 0) {
                    sBuffer.append(",");
                }
                totalCfgNumPartCount += entity.getNumPartitions() * entity.getNumTopicStores();
                entity.toWebJsonStr(sBuffer, true, false);
                sBuffer.append(",\"runInfo\":{");
                BrokerConfEntity brokerConfEntity = this.defMetaDataService.getBrokerConfByBrokerId(entity.getBrokerId());
                String strManageStatus = "-";
                if (brokerConfEntity != null) {
                    strManageStatus = brokerConfEntity.getManageStatus().getDescription();
                }
                brokerRunManager.getPubBrokerTopicInfo(entity.getBrokerId(), entity.getTopicName(), (Tuple3<Boolean, Boolean, TopicInfo>)topicInfoTuple);
                if (topicInfoTuple.getF2() == null) {
                    sBuffer.append("\"acceptPublish\":\"-\"").append(",\"acceptSubscribe\":\"-\"").append(",\"numPartitions\":\"-\"").append(",\"brokerManageStatus\":\"-\"");
                } else {
                    if (((Boolean)topicInfoTuple.getF0()).booleanValue()) {
                        sBuffer.append("\"acceptPublish\":").append(((TopicInfo)topicInfoTuple.getF2()).isAcceptPublish());
                        if (((TopicInfo)topicInfoTuple.getF2()).isAcceptPublish()) {
                            isSrvAcceptPublish = true;
                        }
                    } else {
                        sBuffer.append("\"acceptPublish\":false");
                    }
                    if (((Boolean)topicInfoTuple.getF1()).booleanValue()) {
                        sBuffer.append(",\"acceptSubscribe\":").append(((TopicInfo)topicInfoTuple.getF2()).isAcceptSubscribe());
                        if (((TopicInfo)topicInfoTuple.getF2()).isAcceptSubscribe()) {
                            isSrvAcceptSubscribe = true;
                        }
                    } else {
                        sBuffer.append(",\"acceptSubscribe\":false");
                    }
                    totalRunNumPartCount += ((TopicInfo)topicInfoTuple.getF2()).getPartitionNum() * ((TopicInfo)topicInfoTuple.getF2()).getTopicStoreNum();
                    sBuffer.append(",\"numPartitions\":").append(((TopicInfo)topicInfoTuple.getF2()).getPartitionNum()).append(",\"numTopicStores\":").append(((TopicInfo)topicInfoTuple.getF2()).getTopicStoreNum()).append(",\"brokerManageStatus\":\"").append(strManageStatus).append("\"");
                }
                sBuffer.append("}}");
            }
            sBuffer.append("],\"infoCount\":").append(itemCount).append(",\"totalCfgNumPart\":").append(totalCfgNumPartCount).append(",\"isSrvAcceptPublish\":").append(isSrvAcceptPublish).append(",\"isSrvAcceptSubscribe\":").append(isSrvAcceptSubscribe).append(",\"totalRunNumPartCount\":").append(totalRunNumPartCount);
            if (withAuthInfo) {
                sBuffer.append(",\"groupAuthInfo\":[");
                List<GroupConsumeCtrlEntity> groupCtrlInfoLst = this.defMetaDataService.getConsumeCtrlByTopic(entry.getKey());
                itemCount = 0;
                for (GroupConsumeCtrlEntity groupEntity : groupCtrlInfoLst) {
                    if (itemCount++ > 0) {
                        sBuffer.append(",");
                    }
                    groupEntity.toWebJsonStr(sBuffer, true, true);
                }
                sBuffer.append("],\"groupAuthCount\":").append(itemCount);
            }
            sBuffer.append("}");
        }
        WebParameterUtils.buildSuccessWithDataRetEnd(sBuffer, totalCnt);
        return sBuffer;
    }

    private StringBuilder innAddOrUpdTopicDeployInfo(HttpServletRequest req, StringBuilder sBuffer, ProcessResult result, boolean isAddOp) {
        if (!WebParameterUtils.getAUDBaseInfo(req, isAddOp, null, sBuffer, result)) {
            WebParameterUtils.buildFailResult(sBuffer, result.getErrMsg());
            return sBuffer;
        }
        BaseEntity opEntity = (BaseEntity)result.getRetData();
        if (!WebParameterUtils.getStringParamValue(req, WebFieldDef.COMPSTOPICNAME, true, null, sBuffer, result)) {
            WebParameterUtils.buildFailResult(sBuffer, result.getErrMsg());
            return sBuffer;
        }
        Set topicNameSet = (Set)result.getRetData();
        if (!WebParameterUtils.getIntParamValue(req, WebFieldDef.COMPSBROKERID, true, sBuffer, result)) {
            WebParameterUtils.buildFailResult(sBuffer, result.getErrMsg());
            return sBuffer;
        }
        Set brokerIdSet = (Set)result.getRetData();
        if (!WebParameterUtils.getTopicPropInfo(req, null, sBuffer, result)) {
            WebParameterUtils.buildFailResult(sBuffer, result.getErrMsg());
            return sBuffer;
        }
        TopicPropGroup topicPropInfo = (TopicPropGroup)result.getRetData();
        TopicStatus topicStatus = TopicStatus.STATUS_TOPIC_UNDEFINED;
        if (isAddOp) {
            topicStatus = TopicStatus.STATUS_TOPIC_OK;
        }
        ArrayList<TopicProcessResult> retInfo = new ArrayList<TopicProcessResult>();
        for (String topicName : topicNameSet) {
            for (Integer brokerId : brokerIdSet) {
                retInfo.add(this.defMetaDataService.addOrUpdTopicDeployInfo(isAddOp, opEntity, brokerId, topicName, topicStatus, topicPropInfo, sBuffer, result));
            }
        }
        return this.buildRetInfo(retInfo, sBuffer);
    }

    private StringBuilder innBatchAddOrUpdTopicDeployInfo(HttpServletRequest req, StringBuilder sBuffer, ProcessResult result, boolean isAddOp) {
        if (!WebParameterUtils.getAUDBaseInfo(req, isAddOp, null, sBuffer, result)) {
            WebParameterUtils.buildFailResult(sBuffer, result.getErrMsg());
            return sBuffer;
        }
        BaseEntity defOpEntity = (BaseEntity)result.getRetData();
        if (!this.getTopicDeployJsonSetInfo(req, isAddOp, defOpEntity, sBuffer, result)) {
            WebParameterUtils.buildFailResult(sBuffer, result.getErrMsg());
            return sBuffer;
        }
        Map addRecordMap = (Map)result.getRetData();
        ArrayList<TopicProcessResult> retInfo = new ArrayList<TopicProcessResult>();
        for (TopicDeployEntity topicDeployInfo : addRecordMap.values()) {
            retInfo.add(this.defMetaDataService.addOrUpdTopicDeployInfo(isAddOp, topicDeployInfo, sBuffer, result));
        }
        return this.buildRetInfo(retInfo, sBuffer);
    }

    private boolean getTopicDeployJsonSetInfo(HttpServletRequest req, boolean isAddOp, BaseEntity defOpEntity, StringBuilder sBuffer, ProcessResult result) {
        if (!WebParameterUtils.getJsonArrayParamValue(req, WebFieldDef.TOPICJSONSET, true, null, result)) {
            return result.isSuccess();
        }
        List deployJsonArray = (List)result.getRetData();
        HashMap<String, TopicDeployEntity> addRecordMap = new HashMap<String, TopicDeployEntity>();
        for (Map confMap : deployJsonArray) {
            if (!WebParameterUtils.getAUDBaseInfo(confMap, isAddOp, defOpEntity, sBuffer, result)) {
                return result.isSuccess();
            }
            BaseEntity itemOpEntity = (BaseEntity)result.getRetData();
            if (!WebParameterUtils.getStringParamValue(confMap, WebFieldDef.TOPICNAME, true, "", sBuffer, result)) {
                return result.isSuccess();
            }
            String topicName = (String)result.getRetData();
            if (!this.getBrokerConfInfo(confMap, sBuffer, result)) {
                return result.isSuccess();
            }
            BrokerConfEntity brokerConf = (BrokerConfEntity)result.getRetData();
            if (!WebParameterUtils.getTopicPropInfo(confMap, isAddOp ? brokerConf.getTopicProps() : null, sBuffer, result)) {
                return result.isSuccess();
            }
            TopicPropGroup topicPropInfo = (TopicPropGroup)result.getRetData();
            int topicNameId = -2;
            TopicCtrlEntity topicCtrlEntity = this.defMetaDataService.getTopicCtrlByTopicName(topicName);
            if (topicCtrlEntity != null) {
                topicNameId = topicCtrlEntity.getTopicId();
            }
            TopicStatus topicStatus = TopicStatus.STATUS_TOPIC_UNDEFINED;
            if (isAddOp) {
                topicStatus = TopicStatus.STATUS_TOPIC_OK;
            }
            TopicDeployEntity itemConf = new TopicDeployEntity(itemOpEntity, brokerConf.getBrokerId(), topicName);
            itemConf.updModifyInfo(itemOpEntity.getDataVerId(), topicNameId, brokerConf.getBrokerPort(), brokerConf.getBrokerIp(), topicStatus, topicPropInfo);
            addRecordMap.put(itemConf.getRecordKey(), itemConf);
        }
        if (addRecordMap.isEmpty()) {
            result.setFailResult(sBuffer.append("Not found record in ").append(WebFieldDef.TOPICJSONSET.name).append(" parameter!").toString());
            sBuffer.delete(0, sBuffer.length());
            return result.isSuccess();
        }
        result.setSuccResult(addRecordMap);
        return result.isSuccess();
    }

    private boolean getBrokerConfInfo(Map<String, String> keyValueMap, StringBuilder sBuffer, ProcessResult result) {
        if (!WebParameterUtils.getIntParamValue(keyValueMap, WebFieldDef.BROKERID, true, 0, 0, sBuffer, result)) {
            return result.isSuccess();
        }
        int brokerId = (Integer)result.getRetData();
        BrokerConfEntity curEntity = this.defMetaDataService.getBrokerConfByBrokerId(brokerId);
        if (curEntity == null) {
            result.setFailResult(DataOpErrCode.DERR_NOT_EXIST.getCode(), sBuffer.append("Not found broker configure by ").append(WebFieldDef.BROKERID.name).append(" = ").append(brokerId).append(", please create the broker's configure first!").toString());
            return result.isSuccess();
        }
        result.setSuccResult((Object)curEntity);
        return result.isSuccess();
    }

    private StringBuilder buildRetInfo(List<TopicProcessResult> retInfo, StringBuilder sBuffer) {
        int totalCnt = 0;
        WebParameterUtils.buildSuccessWithDataRetBegin(sBuffer);
        for (TopicProcessResult entry : retInfo) {
            if (totalCnt++ > 0) {
                sBuffer.append(",");
            }
            sBuffer.append("{\"brokerId\":").append(entry.getBrokerId()).append(",\"topicName\":\"").append(entry.getTopicName()).append("\"").append(",\"success\":").append(entry.isSuccess()).append(",\"errCode\":").append(entry.getErrCode()).append(",\"errInfo\":\"").append(entry.getErrMsg()).append("\"}");
        }
        WebParameterUtils.buildSuccessWithDataRetEnd(sBuffer, totalCnt);
        return sBuffer;
    }

    private StringBuilder innModifyTopicDeployStatusInfo(HttpServletRequest req, StringBuilder sBuffer, ProcessResult result, TopicStsChgType chgType) {
        if (!WebParameterUtils.getAUDBaseInfo(req, false, null, sBuffer, result)) {
            WebParameterUtils.buildFailResult(sBuffer, result.getErrMsg());
            return sBuffer;
        }
        BaseEntity opEntity = (BaseEntity)result.getRetData();
        if (!WebParameterUtils.getStringParamValue(req, WebFieldDef.COMPSTOPICNAME, true, null, sBuffer, result)) {
            WebParameterUtils.buildFailResult(sBuffer, result.getErrMsg());
            return sBuffer;
        }
        Set topicNameSet = (Set)result.getRetData();
        if (!WebParameterUtils.getIntParamValue(req, WebFieldDef.COMPSBROKERID, true, sBuffer, result)) {
            WebParameterUtils.buildFailResult(sBuffer, result.getErrMsg());
            return sBuffer;
        }
        Set brokerIdSet = (Set)result.getRetData();
        ArrayList<TopicProcessResult> retInfo = new ArrayList<TopicProcessResult>();
        for (Integer brokerId : brokerIdSet) {
            for (String topicName : topicNameSet) {
                retInfo.add(this.defMetaDataService.updTopicDeployStatusInfo(opEntity, brokerId, topicName, chgType, sBuffer, result));
            }
        }
        return this.buildRetInfo(retInfo, sBuffer);
    }
}

