/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.document;

import com.fasterxml.jackson.core.JsonEncoding;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.PrettyPrinter;
import com.fasterxml.jackson.core.util.DefaultPrettyPrinter;
import io.debezium.annotation.ThreadSafe;
import io.debezium.document.Array;
import io.debezium.document.ArrayWriter;
import io.debezium.document.Document;
import io.debezium.document.DocumentWriter;
import io.debezium.document.Value;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;

@ThreadSafe
final class JacksonWriter
implements DocumentWriter,
ArrayWriter {
    public static final JacksonWriter INSTANCE = new JacksonWriter(false);
    public static final JacksonWriter PRETTY_WRITER = new JacksonWriter(true);
    private static final JsonFactory factory = new JsonFactory();
    private final boolean pretty;

    private JacksonWriter(boolean pretty) {
        this.pretty = pretty;
    }

    @Override
    public void write(Document document, OutputStream jsonStream) throws IOException {
        try (JsonGenerator jsonGenerator = factory.createGenerator(jsonStream);){
            this.configure(jsonGenerator);
            this.writeDocument(document, jsonGenerator);
        }
    }

    @Override
    public void write(Document document, Writer jsonWriter) throws IOException {
        try (JsonGenerator jsonGenerator = factory.createGenerator(jsonWriter);){
            this.configure(jsonGenerator);
            this.writeDocument(document, jsonGenerator);
        }
    }

    @Override
    public String write(Document document) throws IOException {
        StringWriter writer = new StringWriter();
        try (JsonGenerator jsonGenerator = factory.createGenerator((Writer)writer);){
            this.configure(jsonGenerator);
            this.writeDocument(document, jsonGenerator);
        }
        return writer.getBuffer().toString();
    }

    @Override
    public byte[] writeAsBytes(Document document) {
        byte[] byArray;
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        try {
            try (JsonGenerator jsonGenerator = factory.createGenerator((OutputStream)stream, JsonEncoding.UTF8);){
                this.configure(jsonGenerator);
                this.writeDocument(document, jsonGenerator);
            }
            byArray = stream.toByteArray();
        }
        catch (Throwable throwable) {
            try {
                try {
                    stream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        stream.close();
        return byArray;
    }

    @Override
    public void write(Array array, OutputStream jsonStream) throws IOException {
        try (JsonGenerator jsonGenerator = factory.createGenerator(jsonStream);){
            this.configure(jsonGenerator);
            this.writeArray(array, jsonGenerator);
        }
    }

    @Override
    public void write(Array array, Writer jsonWriter) throws IOException {
        try (JsonGenerator jsonGenerator = factory.createGenerator(jsonWriter);){
            this.configure(jsonGenerator);
            this.writeArray(array, jsonGenerator);
        }
    }

    @Override
    public String write(Array array) throws IOException {
        StringWriter writer = new StringWriter();
        try (JsonGenerator jsonGenerator = factory.createGenerator((Writer)writer);){
            this.configure(jsonGenerator);
            this.writeArray(array, jsonGenerator);
        }
        return writer.getBuffer().toString();
    }

    protected void configure(JsonGenerator generator) {
        if (this.pretty) {
            generator.setPrettyPrinter((PrettyPrinter)new DefaultPrettyPrinter());
        }
    }

    protected void writeDocument(Document document, JsonGenerator generator) throws IOException {
        generator.writeStartObject();
        try {
            document.stream().forEach(field -> {
                try {
                    generator.writeFieldName(field.getName().toString());
                    this.writeValue(field.getValue(), generator);
                }
                catch (IOException e) {
                    throw new WritingError(e);
                }
            });
            generator.writeEndObject();
        }
        catch (WritingError e) {
            throw e.wrapped();
        }
    }

    protected void writeArray(Array array, JsonGenerator generator) throws IOException {
        generator.writeStartArray();
        try {
            array.streamValues().forEach(value -> {
                try {
                    this.writeValue((Value)value, generator);
                }
                catch (IOException e) {
                    throw new WritingError(e);
                }
            });
            generator.writeEndArray();
        }
        catch (WritingError e) {
            throw e.wrapped();
        }
    }

    protected void writeValue(Value value, JsonGenerator generator) throws IOException {
        switch (value.getType()) {
            case NULL: {
                generator.writeNull();
                break;
            }
            case STRING: {
                generator.writeString(value.asString());
                break;
            }
            case BOOLEAN: {
                generator.writeBoolean(value.asBoolean().booleanValue());
                break;
            }
            case BINARY: {
                generator.writeBinary(value.asBytes());
                break;
            }
            case INTEGER: {
                generator.writeNumber(value.asInteger().intValue());
                break;
            }
            case LONG: {
                generator.writeNumber(value.asLong().longValue());
                break;
            }
            case FLOAT: {
                generator.writeNumber(value.asFloat().floatValue());
                break;
            }
            case DOUBLE: {
                generator.writeNumber(value.asDouble().doubleValue());
                break;
            }
            case BIG_INTEGER: {
                generator.writeNumber(value.asBigInteger());
                break;
            }
            case DECIMAL: {
                generator.writeNumber(value.asBigDecimal());
                break;
            }
            case DOCUMENT: {
                this.writeDocument(value.asDocument(), generator);
                break;
            }
            case ARRAY: {
                this.writeArray(value.asArray(), generator);
            }
        }
    }

    protected static final class WritingError
    extends RuntimeException {
        private static final long serialVersionUID = 1L;
        private final IOException wrapped;

        protected WritingError(IOException wrapped) {
            this.wrapped = wrapped;
        }

        public IOException wrapped() {
            return this.wrapped;
        }
    }
}

