/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.relational;

import io.debezium.annotation.Immutable;
import io.debezium.function.Predicates;
import io.debezium.relational.TableId;
import java.util.function.Predicate;

@Immutable
public class Selectors {
    public static DatabaseSelectionPredicateBuilder databaseSelector() {
        return new DatabaseSelectionPredicateBuilder();
    }

    private static boolean isEmpty(String value) {
        return value == null || value.trim().isEmpty();
    }

    public static TableSelectionPredicateBuilder tableSelector() {
        return new TableSelectionPredicateBuilder();
    }

    public static class TableSelectionPredicateBuilder {
        private Predicate<String> dbInclusions;
        private Predicate<String> dbExclusions;
        private Predicate<String> schemaInclusions;
        private Predicate<String> schemaExclusions;
        private Predicate<TableId> tableInclusions;
        private Predicate<TableId> tableExclusions;

        public TableSelectionPredicateBuilder includeDatabases(String databaseNames) {
            this.dbInclusions = Selectors.isEmpty(databaseNames) ? null : Predicates.includes(databaseNames);
            return this;
        }

        public TableSelectionPredicateBuilder excludeDatabases(String databaseNames) {
            this.dbExclusions = Selectors.isEmpty(databaseNames) ? null : Predicates.excludes(databaseNames);
            return this;
        }

        public TableSelectionPredicateBuilder includeSchemas(String schemaNames) {
            this.schemaInclusions = Selectors.isEmpty(schemaNames) ? null : Predicates.includes(schemaNames);
            return this;
        }

        public TableSelectionPredicateBuilder excludeSchemas(String schemaNames) {
            this.schemaExclusions = Selectors.isEmpty(schemaNames) ? null : Predicates.excludes(schemaNames);
            return this;
        }

        public TableSelectionPredicateBuilder includeTables(String fullyQualifiedTableNames, TableIdToStringMapper tableIdMapper) {
            this.tableInclusions = Selectors.isEmpty(fullyQualifiedTableNames) ? null : Predicates.includes(fullyQualifiedTableNames, tableId -> tableIdMapper.toString((TableId)tableId));
            return this;
        }

        public TableSelectionPredicateBuilder includeTables(String fullyQualifiedTableNames) {
            return this.includeTables(fullyQualifiedTableNames, TableId::toString);
        }

        public TableSelectionPredicateBuilder excludeTables(String fullyQualifiedTableNames, TableIdToStringMapper tableIdMapper) {
            this.tableExclusions = Selectors.isEmpty(fullyQualifiedTableNames) ? null : Predicates.excludes(fullyQualifiedTableNames, tableId -> tableIdMapper.toString((TableId)tableId));
            return this;
        }

        public TableSelectionPredicateBuilder excludeTables(String fullyQualifiedTableNames) {
            return this.excludeTables(fullyQualifiedTableNames, TableId::toString);
        }

        public Predicate<TableId> build() {
            Predicate<String> schemaFilter;
            Predicate<TableId> tableFilter = this.tableInclusions != null ? this.tableInclusions : this.tableExclusions;
            Predicate<String> dbFilter = this.dbInclusions != null ? this.dbInclusions : this.dbExclusions;
            Predicate<String> predicate = schemaFilter = this.schemaInclusions != null ? this.schemaInclusions : this.schemaExclusions;
            if (dbFilter != null) {
                return this.buildStartingFromDbFilter(dbFilter, schemaFilter, tableFilter);
            }
            if (schemaFilter != null) {
                return this.buildStartingFromSchemaFilter(schemaFilter, tableFilter);
            }
            if (tableFilter != null) {
                return tableFilter;
            }
            return id -> true;
        }

        private Predicate<TableId> buildStartingFromSchemaFilter(Predicate<String> schemaFilter, Predicate<TableId> tableFilter) {
            assert (schemaFilter != null);
            if (tableFilter != null) {
                return id -> schemaFilter.test(id.schema()) && tableFilter.test((TableId)id);
            }
            return id -> schemaFilter.test(id.schema());
        }

        private Predicate<TableId> buildStartingFromDbFilter(Predicate<String> dbFilter, Predicate<String> schemaFilter, Predicate<TableId> tableFilter) {
            assert (dbFilter != null);
            if (schemaFilter != null) {
                if (tableFilter != null) {
                    return id -> dbFilter.test(id.catalog()) && schemaFilter.test(id.schema()) && tableFilter.test((TableId)id);
                }
                return id -> schemaFilter.test(id.schema());
            }
            if (tableFilter != null) {
                return id -> dbFilter.test(id.catalog()) && tableFilter.test((TableId)id);
            }
            return id -> dbFilter.test(id.catalog());
        }
    }

    public static class DatabaseSelectionPredicateBuilder {
        private Predicate<String> dbInclusions;
        private Predicate<String> dbExclusions;

        public DatabaseSelectionPredicateBuilder includeDatabases(String databaseNames) {
            this.dbInclusions = databaseNames == null || databaseNames.trim().isEmpty() ? null : Predicates.includes(databaseNames);
            return this;
        }

        public DatabaseSelectionPredicateBuilder excludeDatabases(String databaseNames) {
            this.dbExclusions = databaseNames == null || databaseNames.trim().isEmpty() ? null : Predicates.excludes(databaseNames);
            return this;
        }

        public Predicate<String> build() {
            Predicate<String> dbFilter = this.dbInclusions != null ? this.dbInclusions : this.dbExclusions;
            return dbFilter != null ? dbFilter : id -> true;
        }
    }

    @FunctionalInterface
    public static interface TableIdToStringMapper {
        public String toString(TableId var1);
    }
}

