/*
 * Decompiled with CFR 0.152.
 */
package com.moilioncircle.redis.replicator.rdb.skip;

import com.moilioncircle.redis.replicator.Constants;
import com.moilioncircle.redis.replicator.Replicator;
import com.moilioncircle.redis.replicator.io.RedisInputStream;
import com.moilioncircle.redis.replicator.rdb.DefaultRdbValueVisitor;
import com.moilioncircle.redis.replicator.rdb.datatype.Module;
import com.moilioncircle.redis.replicator.rdb.module.ModuleParser;
import com.moilioncircle.redis.replicator.rdb.skip.SkipRdbParser;
import java.io.IOException;
import java.util.NoSuchElementException;

public class SkipRdbValueVisitor
extends DefaultRdbValueVisitor {
    public SkipRdbValueVisitor(Replicator replicator) {
        super(replicator);
    }

    @Override
    public <T> T applyFunction(RedisInputStream in, int version) throws IOException {
        SkipRdbParser parser = new SkipRdbParser(in);
        parser.rdbGenericLoadStringObject();
        parser.rdbGenericLoadStringObject();
        long hasDesc = parser.rdbLoadLen().len;
        if (hasDesc == 1L) {
            parser.rdbGenericLoadStringObject();
        }
        parser.rdbGenericLoadStringObject();
        return null;
    }

    @Override
    public <T> T applyFunction2(RedisInputStream in, int version) throws IOException {
        SkipRdbParser parser = new SkipRdbParser(in);
        parser.rdbGenericLoadStringObject();
        return null;
    }

    @Override
    public <T> T applyString(RedisInputStream in, int version) throws IOException {
        SkipRdbParser parser = new SkipRdbParser(in);
        parser.rdbLoadEncodedStringObject();
        return null;
    }

    @Override
    public <T> T applyList(RedisInputStream in, int version) throws IOException {
        SkipRdbParser skip = new SkipRdbParser(in);
        for (long len = skip.rdbLoadLen().len; len > 0L; --len) {
            skip.rdbLoadEncodedStringObject();
        }
        return null;
    }

    @Override
    public <T> T applySet(RedisInputStream in, int version) throws IOException {
        SkipRdbParser skip = new SkipRdbParser(in);
        for (long len = skip.rdbLoadLen().len; len > 0L; --len) {
            skip.rdbLoadEncodedStringObject();
        }
        return null;
    }

    @Override
    public <T> T applyZSet(RedisInputStream in, int version) throws IOException {
        SkipRdbParser skip = new SkipRdbParser(in);
        for (long len = skip.rdbLoadLen().len; len > 0L; --len) {
            skip.rdbLoadEncodedStringObject();
            skip.rdbLoadDoubleValue();
        }
        return null;
    }

    @Override
    public <T> T applyZSet2(RedisInputStream in, int version) throws IOException {
        SkipRdbParser skip = new SkipRdbParser(in);
        for (long len = skip.rdbLoadLen().len; len > 0L; --len) {
            skip.rdbLoadEncodedStringObject();
            skip.rdbLoadBinaryDoubleValue();
        }
        return null;
    }

    @Override
    public <T> T applyHash(RedisInputStream in, int version) throws IOException {
        SkipRdbParser skip = new SkipRdbParser(in);
        for (long len = skip.rdbLoadLen().len; len > 0L; --len) {
            skip.rdbLoadEncodedStringObject();
            skip.rdbLoadEncodedStringObject();
        }
        return null;
    }

    @Override
    public <T> T applyHashZipMap(RedisInputStream in, int version) throws IOException {
        SkipRdbParser skip = new SkipRdbParser(in);
        skip.rdbLoadPlainStringObject();
        return null;
    }

    @Override
    public <T> T applyListZipList(RedisInputStream in, int version) throws IOException {
        SkipRdbParser skip = new SkipRdbParser(in);
        skip.rdbLoadPlainStringObject();
        return null;
    }

    @Override
    public <T> T applySetIntSet(RedisInputStream in, int version) throws IOException {
        SkipRdbParser skip = new SkipRdbParser(in);
        skip.rdbLoadPlainStringObject();
        return null;
    }

    @Override
    public <T> T applyZSetZipList(RedisInputStream in, int version) throws IOException {
        SkipRdbParser skip = new SkipRdbParser(in);
        skip.rdbLoadPlainStringObject();
        return null;
    }

    @Override
    public <T> T applyZSetListPack(RedisInputStream in, int version) throws IOException {
        SkipRdbParser skip = new SkipRdbParser(in);
        skip.rdbLoadPlainStringObject();
        return null;
    }

    @Override
    public <T> T applyHashZipList(RedisInputStream in, int version) throws IOException {
        SkipRdbParser skip = new SkipRdbParser(in);
        skip.rdbLoadPlainStringObject();
        return null;
    }

    @Override
    public <T> T applyHashListPack(RedisInputStream in, int version) throws IOException {
        SkipRdbParser skip = new SkipRdbParser(in);
        skip.rdbLoadPlainStringObject();
        return null;
    }

    @Override
    public <T> T applyListQuickList(RedisInputStream in, int version) throws IOException {
        SkipRdbParser skip = new SkipRdbParser(in);
        long len = skip.rdbLoadLen().len;
        for (long i = 0L; i < len; ++i) {
            skip.rdbGenericLoadStringObject();
        }
        return null;
    }

    @Override
    public <T> T applyListQuickList2(RedisInputStream in, int version) throws IOException {
        SkipRdbParser skip = new SkipRdbParser(in);
        long len = skip.rdbLoadLen().len;
        for (long i = 0L; i < len; ++i) {
            skip.rdbLoadLen();
            skip.rdbGenericLoadStringObject();
        }
        return null;
    }

    @Override
    public <T> T applyModule(RedisInputStream in, int version) throws IOException {
        SkipRdbParser skip = new SkipRdbParser(in);
        char[] c = new char[9];
        long moduleid = skip.rdbLoadLen().len;
        for (int i = 0; i < c.length; ++i) {
            c[i] = Constants.MODULE_SET[(int)(moduleid >>> 10 + (c.length - 1 - i) * 6 & 0x3FL)];
        }
        String moduleName = new String(c);
        int moduleVersion = (int)(moduleid & 0x3FFL);
        ModuleParser<? extends Module> moduleParser = this.replicator.getModuleParser(moduleName, moduleVersion);
        if (moduleParser == null) {
            throw new NoSuchElementException("module parser[" + moduleName + ", " + moduleVersion + "] not register. rdb type: [RDB_TYPE_MODULE]");
        }
        moduleParser.parse(in, 1);
        return null;
    }

    @Override
    public <T> T applyModule2(RedisInputStream in, int version) throws IOException {
        SkipRdbParser skip = new SkipRdbParser(in);
        skip.rdbLoadLen();
        SkipRdbParser skipRdbParser = new SkipRdbParser(in);
        skipRdbParser.rdbLoadCheckModuleValue();
        return null;
    }

    @Override
    public <T> T applyStreamListPacks(RedisInputStream in, int version) throws IOException {
        SkipRdbParser skip = new SkipRdbParser(in);
        long listPacks = skip.rdbLoadLen().len;
        while (listPacks-- > 0L) {
            skip.rdbLoadPlainStringObject();
            skip.rdbLoadPlainStringObject();
        }
        skip.rdbLoadLen();
        skip.rdbLoadLen();
        skip.rdbLoadLen();
        long groupCount = skip.rdbLoadLen().len;
        while (groupCount-- > 0L) {
            skip.rdbLoadPlainStringObject();
            skip.rdbLoadLen();
            skip.rdbLoadLen();
            long groupPel = skip.rdbLoadLen().len;
            while (groupPel-- > 0L) {
                in.skip(16L);
                skip.rdbLoadMillisecondTime();
                skip.rdbLoadLen();
            }
            long consumerCount = skip.rdbLoadLen().len;
            while (consumerCount-- > 0L) {
                skip.rdbLoadPlainStringObject();
                skip.rdbLoadMillisecondTime();
                long consumerPel = skip.rdbLoadLen().len;
                while (consumerPel-- > 0L) {
                    in.skip(16L);
                }
            }
        }
        return null;
    }

    @Override
    public <T> T applyStreamListPacks2(RedisInputStream in, int version) throws IOException {
        SkipRdbParser skip = new SkipRdbParser(in);
        long listPacks = skip.rdbLoadLen().len;
        while (listPacks-- > 0L) {
            skip.rdbLoadPlainStringObject();
            skip.rdbLoadPlainStringObject();
        }
        skip.rdbLoadLen();
        skip.rdbLoadLen();
        skip.rdbLoadLen();
        skip.rdbLoadLen();
        skip.rdbLoadLen();
        skip.rdbLoadLen();
        skip.rdbLoadLen();
        skip.rdbLoadLen();
        long groupCount = skip.rdbLoadLen().len;
        while (groupCount-- > 0L) {
            skip.rdbLoadPlainStringObject();
            skip.rdbLoadLen();
            skip.rdbLoadLen();
            skip.rdbLoadLen();
            long groupPel = skip.rdbLoadLen().len;
            while (groupPel-- > 0L) {
                in.skip(16L);
                skip.rdbLoadMillisecondTime();
                skip.rdbLoadLen();
            }
            long consumerCount = skip.rdbLoadLen().len;
            while (consumerCount-- > 0L) {
                skip.rdbLoadPlainStringObject();
                skip.rdbLoadMillisecondTime();
                long consumerPel = skip.rdbLoadLen().len;
                while (consumerPel-- > 0L) {
                    in.skip(16L);
                }
            }
        }
        return null;
    }
}

