/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sdk.commons.protocol;

import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.inlong.sdk.commons.protocol.InlongId;
import org.apache.inlong.sdk.commons.protocol.ProxySdk;
import org.apache.inlong.sdk.commons.protocol.SdkEvent;

public class ProxyEvent
extends SdkEvent {
    protected long sourceTime;
    protected String topic;

    public ProxyEvent() {
    }

    public ProxyEvent(String inlongGroupId, String inlongStreamId, byte[] body, long msgTime, String sourceIp) {
        this.inlongGroupId = inlongGroupId;
        this.inlongStreamId = inlongStreamId;
        super.setBody(body);
        this.uid = InlongId.generateUid(inlongGroupId, inlongStreamId);
        this.msgTime = msgTime;
        this.sourceIp = sourceIp;
        Map headers = super.getHeaders();
        headers.put("inlongGroupId", inlongGroupId);
        headers.put("inlongStreamId", inlongStreamId);
        headers.put("msgTime", String.valueOf(msgTime));
        headers.put("sourceIp", sourceIp);
        this.sourceTime = System.currentTimeMillis();
        this.getHeaders().put("sourceTime", String.valueOf(this.sourceTime));
    }

    public ProxyEvent(String inlongGroupId, String inlongStreamId, ProxySdk.MessageObj obj) {
        this.inlongGroupId = inlongGroupId;
        this.inlongStreamId = inlongStreamId;
        this.uid = InlongId.generateUid(inlongGroupId, inlongStreamId);
        if (obj != null) {
            super.setBody(obj.getBody().toByteArray());
            this.msgTime = obj.getMsgTime();
            this.sourceIp = obj.getSourceIp();
        }
        Map headers = super.getHeaders();
        headers.put("inlongGroupId", inlongGroupId);
        headers.put("inlongStreamId", inlongStreamId);
        headers.put("msgTime", String.valueOf(this.msgTime));
        headers.put("sourceIp", this.sourceIp);
        if (obj != null && obj.getParamsList() != null) {
            List<ProxySdk.MapFieldEntry> list = obj.getParamsList();
            for (ProxySdk.MapFieldEntry entry : list) {
                if ("rtms".equalsIgnoreCase(entry.getKey())) {
                    headers.put("rtms", entry.getValue());
                    continue;
                }
                if (!"auditVersion".equalsIgnoreCase(entry.getKey())) continue;
                headers.put("auditVersion", entry.getValue());
            }
        }
        this.sourceTime = System.currentTimeMillis();
        this.getHeaders().put("sourceTime", String.valueOf(this.sourceTime));
    }

    public ProxyEvent(String groupId, String streamId, String msgTimeStr, String sourceIp, String sourceTimeStr, Map<String, String> headers, byte[] body) {
        this.inlongGroupId = groupId;
        this.inlongStreamId = streamId;
        this.sourceIp = sourceIp;
        this.uid = InlongId.generateUid(this.inlongGroupId, this.inlongStreamId);
        this.msgTime = NumberUtils.toLong((String)msgTimeStr, (long)System.currentTimeMillis());
        this.sourceTime = NumberUtils.toLong((String)sourceTimeStr, (long)System.currentTimeMillis());
        super.setBody(body);
        super.setHeaders(headers);
    }

    public long getSourceTime() {
        return this.sourceTime;
    }

    public String getTopic() {
        return this.topic;
    }

    public void setTopic(String topic) {
        this.topic = topic;
        this.getHeaders().put("topic", topic);
    }

    public void setSourceTime(long sourceTime) {
        this.sourceTime = sourceTime;
    }
}

