/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.agent.utils;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.nio.charset.Charset;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLContext;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.ssl.SSLContexts;
import org.apache.http.util.EntityUtils;
import org.apache.inlong.agent.conf.AgentConfiguration;
import org.apache.inlong.common.util.BasicAuth;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpManager.class);
    private static final Gson gson;
    private final CloseableHttpClient httpClient;
    private final String baseUrl;
    private final String secretId;
    private final String secretKey;
    private static boolean enableHttps;

    public HttpManager(AgentConfiguration conf) {
        this(conf.get("agent.manager.addr"), conf.get("agent.manager.vip.http.prefix.path", "/inlong/manager/openapi"), conf.getInt("agent.manager.request.timeout", 30), conf.get("agent.manager.auth.secretId"), conf.get("agent.manager.auth.secretKey"));
    }

    public HttpManager(String managerAddr, String managerHttpPrefixPath, int timeout, String secretId, String secretKey) {
        this.baseUrl = managerAddr + managerHttpPrefixPath;
        enableHttps = StringUtils.startsWith((CharSequence)managerAddr, (CharSequence)"https");
        this.httpClient = enableHttps ? HttpManager.constructHttpsClient(timeout) : this.constructHttpClient(timeout);
        this.secretId = secretId;
        this.secretKey = secretKey;
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    private synchronized CloseableHttpClient constructHttpClient(int timeout) {
        if (this.httpClient != null) {
            return this.httpClient;
        }
        long timeoutInMs = TimeUnit.SECONDS.toMillis(timeout);
        RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout((int)timeoutInMs).setSocketTimeout((int)timeoutInMs).build();
        HttpClientBuilder httpClientBuilder = HttpClientBuilder.create();
        httpClientBuilder.setDefaultRequestConfig(requestConfig);
        return httpClientBuilder.build();
    }

    private static CloseableHttpClient constructHttpsClient(int timeout) {
        long timeoutInMs = TimeUnit.SECONDS.toMillis(timeout);
        RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout((int)timeoutInMs).setSocketTimeout((int)timeoutInMs).build();
        SSLContext sslContext = null;
        try {
            sslContext = SSLContexts.custom().build();
        }
        catch (NoSuchAlgorithmException e) {
            LOGGER.error("constructHttpsClient error ", (Throwable)e);
        }
        catch (KeyManagementException e) {
            LOGGER.error("constructHttpsClient error ", (Throwable)e);
        }
        SSLConnectionSocketFactory sslsf = new SSLConnectionSocketFactory(sslContext, new String[]{"TLSv1.2"}, null, SSLConnectionSocketFactory.getDefaultHostnameVerifier());
        return HttpClients.custom().setDefaultRequestConfig(requestConfig).setSSLSocketFactory((LayeredConnectionSocketFactory)sslsf).build();
    }

    public String doSentPost(String url, Object dto) {
        try {
            HttpPost post = this.getHttpPost(url);
            Map<String, String> authHeader = this.getAuthHeader();
            authHeader.forEach((k, v) -> post.addHeader(k, v));
            StringEntity stringEntity = new StringEntity(this.toJsonStr(dto), Charset.forName("UTF-8"));
            stringEntity.setContentType("application/json");
            post.setEntity((HttpEntity)stringEntity);
            CloseableHttpResponse response = this.httpClient.execute((HttpUriRequest)post);
            String returnStr = EntityUtils.toString((HttpEntity)response.getEntity());
            if (returnStr != null && !returnStr.isEmpty() && response.getStatusLine().getStatusCode() == 200) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("request url {}, dto: {}, return str {}", new Object[]{url, dto, returnStr});
                }
                return returnStr;
            }
        }
        catch (Exception e) {
            LOGGER.error("request url {}, request dto {} error :" + e.getMessage(), (Object)url, dto);
            return null;
        }
        return null;
    }

    public String toJsonStr(Object obj) {
        return gson.toJson(obj);
    }

    public String doSendPost(String url) {
        try {
            HttpPost post = this.getHttpPost(url);
            Map<String, String> authHeader = this.getAuthHeader();
            authHeader.forEach((k, v) -> post.addHeader(k, v));
            CloseableHttpResponse response = this.httpClient.execute((HttpUriRequest)post);
            String returnStr = EntityUtils.toString((HttpEntity)response.getEntity());
            if (returnStr != null && !returnStr.isEmpty() && response.getStatusLine().getStatusCode() == 200) {
                return returnStr;
            }
        }
        catch (Exception e) {
            LOGGER.error("request url {} error :" + e.getMessage(), (Object)url);
            return null;
        }
        return null;
    }

    private HttpPost getHttpPost(String url) {
        return new HttpPost(url);
    }

    private HttpGet getHttpGet(String url) {
        return new HttpGet(url);
    }

    public Map<String, String> getAuthHeader() {
        HashMap<String, String> header = new HashMap<String, String>();
        try {
            header.put("authorization", BasicAuth.genBasicAuthCredential((String)this.secretId, (String)this.secretKey));
        }
        catch (Exception e) {
            LOGGER.error("Get auth header error", (Throwable)e);
        }
        return header;
    }

    static {
        GsonBuilder gsonBuilder = new GsonBuilder().setDateFormat("yyyy-MM-dd HH:mm:ss");
        gson = gsonBuilder.create();
    }
}

