/*
 * Decompiled with CFR 0.152.
 */
package kafka.network;

import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.Histogram;
import com.yammer.metrics.core.Meter;
import com.yammer.metrics.core.MetricName;
import com.yammer.metrics.core.Timer;
import java.io.Serializable;
import java.net.InetSocketAddress;
import java.net.SocketException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.Iterator;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import kafka.cluster.EndPoint;
import kafka.metrics.KafkaMetricsGroup;
import kafka.network.AbstractServerThread;
import kafka.network.ConnectionQuotas;
import kafka.network.Processor;
import kafka.network.Processor$;
import kafka.network.RequestChannel;
import kafka.network.TooManyConnectionsException;
import kafka.utils.CoreUtils$;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.utils.KafkaThread;
import org.slf4j.event.Level;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.Buffer;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.IntRef;
import scala.runtime.java8.JFunction0;
import scala.util.control.ControlThrowable;

@ScalaSignature(bytes="\u0006\u0001\u0005%g!\u0002\u0011\"\u0001\r*\u0003\u0002\u0003\u0019\u0001\u0005\u000b\u0007I\u0011\u0001\u001a\t\u0011e\u0002!\u0011!Q\u0001\nMB\u0001B\u000f\u0001\u0003\u0006\u0004%\ta\u000f\u0005\t\u0005\u0002\u0011\t\u0011)A\u0005y!A1\t\u0001BC\u0002\u0013\u00051\b\u0003\u0005E\u0001\t\u0005\t\u0015!\u0003=\u0011!)\u0005A!A!\u0002\u0013a\u0004\u0002\u0003$\u0001\u0005\u0003\u0005\u000b\u0011B$\t\u0011)\u0003!\u0011!Q\u0001\n-CQA\u0016\u0001\u0005\u0002]Cqa\u0018\u0001C\u0002\u0013%\u0001\r\u0003\u0004l\u0001\u0001\u0006I!\u0019\u0005\bY\u0002\u0011\r\u0011\"\u0001n\u0011\u0019\t\b\u0001)A\u0005]\"9!\u000f\u0001b\u0001\n\u0013\u0019\bBB@\u0001A\u0003%A\u000fC\u0005\u0002\u0002\u0001\u0011\r\u0011\"\u0003\u0002\u0004!A\u0011\u0011\u0004\u0001!\u0002\u0013\t)\u0001C\u0005\u0002\u001c\u0001\u0011\r\u0011\"\u0003\u0002\u001e!A\u0011Q\u0007\u0001!\u0002\u0013\ty\u0002\u0003\u0005\u00028\u0001!\t!IA\u001d\u0011!\ty\u0005\u0001C\u0001C\u0005E\u0003bBA(\u0001\u0011%\u0011Q\u000b\u0005\t\u0003G\u0002A\u0011A\u0011\u0002f!9\u0011Q\u000f\u0001\u0005B\u0005]\u0004bBA=\u0001\u0011\u0005\u0013q\u000f\u0005\b\u0003w\u0002A\u0011AA<\u0011\u001d\ti\b\u0001C\u0005\u0003\u007fBq!!#\u0001\t\u0013\tY\tC\u0004\u0002$\u0002!I!!*\t\u000f\u0005e\u0006\u0001\"\u0001\u0002x\tA\u0011iY2faR|'O\u0003\u0002#G\u00059a.\u001a;x_J\\'\"\u0001\u0013\u0002\u000b-\fgm[1\u0014\u0007\u00011#\u0006\u0005\u0002(Q5\t\u0011%\u0003\u0002*C\t!\u0012IY:ue\u0006\u001cGoU3sm\u0016\u0014H\u000b\u001b:fC\u0012\u0004\"a\u000b\u0018\u000e\u00031R!!L\u0012\u0002\u000f5,GO]5dg&\u0011q\u0006\f\u0002\u0012\u0017\u000647.Y'fiJL7m]$s_V\u0004\u0018\u0001C3oIB{\u0017N\u001c;\u0004\u0001U\t1\u0007\u0005\u00025o5\tQG\u0003\u00027G\u000591\r\\;ti\u0016\u0014\u0018B\u0001\u001d6\u0005!)e\u000e\u001a)pS:$\u0018!C3oIB{\u0017N\u001c;!\u00039\u0019XM\u001c3Ck\u001a4WM]*ju\u0016,\u0012\u0001\u0010\t\u0003{\u0001k\u0011A\u0010\u0006\u0002\u007f\u0005)1oY1mC&\u0011\u0011I\u0010\u0002\u0004\u0013:$\u0018aD:f]\u0012\u0014UO\u001a4feNK'0\u001a\u0011\u0002\u001dI,7M\u001e\"vM\u001a,'oU5{K\u0006y!/Z2w\u0005V4g-\u001a:TSj,\u0007%\u0001\u0005ce>\\WM]%e\u0003A\u0019wN\u001c8fGRLwN\\)v_R\f7\u000f\u0005\u0002(\u0011&\u0011\u0011*\t\u0002\u0011\u0007>tg.Z2uS>t\u0017+^8uCN\fA\"\\3ue&\u001c\u0007K]3gSb\u0004\"\u0001T*\u000f\u00055\u000b\u0006C\u0001(?\u001b\u0005y%B\u0001)2\u0003\u0019a$o\\8u}%\u0011!KP\u0001\u0007!J,G-\u001a4\n\u0005Q+&AB*ue&twM\u0003\u0002S}\u00051A(\u001b8jiz\"r\u0001W-[7rkf\f\u0005\u0002(\u0001!)\u0001G\u0003a\u0001g!)!H\u0003a\u0001y!)1I\u0003a\u0001y!)QI\u0003a\u0001y!)aI\u0003a\u0001\u000f\")!J\u0003a\u0001\u0017\u0006Ya.[8TK2,7\r^8s+\u0005\t\u0007C\u00012j\u001b\u0005\u0019'B\u00013f\u0003!\u0019\u0007.\u00198oK2\u001c(B\u00014h\u0003\rq\u0017n\u001c\u0006\u0002Q\u0006!!.\u0019<b\u0013\tQ7M\u0001\u0005TK2,7\r^8s\u00031q\u0017n\\*fY\u0016\u001cGo\u001c:!\u00035\u0019XM\u001d<fe\u000eC\u0017M\u001c8fYV\ta\u000e\u0005\u0002c_&\u0011\u0001o\u0019\u0002\u0014'\u0016\u0014h/\u001a:T_\u000e\\W\r^\"iC:tW\r\\\u0001\u000fg\u0016\u0014h/\u001a:DQ\u0006tg.\u001a7!\u0003)\u0001(o\\2fgN|'o]\u000b\u0002iB\u0019QO\u001f?\u000e\u0003YT!a\u001e=\u0002\u000f5,H/\u00192mK*\u0011\u0011PP\u0001\u000bG>dG.Z2uS>t\u0017BA>w\u0005-\t%O]1z\u0005V4g-\u001a:\u0011\u0005\u001dj\u0018B\u0001@\"\u0005%\u0001&o\\2fgN|'/A\u0006qe>\u001cWm]:peN\u0004\u0013!\u00059s_\u000e,7o]8sgN#\u0018M\u001d;fIV\u0011\u0011Q\u0001\t\u0005\u0003\u000f\t)\"\u0004\u0002\u0002\n)!\u00111BA\u0007\u0003\u0019\tGo\\7jG*!\u0011qBA\t\u0003)\u0019wN\\2veJ,g\u000e\u001e\u0006\u0004\u0003'9\u0017\u0001B;uS2LA!a\u0006\u0002\n\ti\u0011\t^8nS\u000e\u0014un\u001c7fC:\f!\u0003\u001d:pG\u0016\u001c8o\u001c:t'R\f'\u000f^3eA\u0005\u0019\"\r\\8dW\u0016$\u0007+\u001a:dK:$X*\u001a;feV\u0011\u0011q\u0004\t\u0005\u0003C\t\t$\u0004\u0002\u0002$)!\u0011QEA\u0014\u0003\u0011\u0019wN]3\u000b\u00075\nIC\u0003\u0003\u0002,\u00055\u0012AB=b[6,'O\u0003\u0002\u00020\u0005\u00191m\\7\n\t\u0005M\u00121\u0005\u0002\u0006\u001b\u0016$XM]\u0001\u0015E2|7m[3e!\u0016\u00148-\u001a8u\u001b\u0016$XM\u001d\u0011\u0002\u001b\u0005$G\r\u0015:pG\u0016\u001c8o\u001c:t)\u0019\tY$!\u0011\u0002LA\u0019Q(!\u0010\n\u0007\u0005}bH\u0001\u0003V]&$\bbBA\"+\u0001\u0007\u0011QI\u0001\u000e]\u0016<\bK]8dKN\u001cxN]:\u0011\tU\f9\u0005`\u0005\u0004\u0003\u00132(A\u0002\"vM\u001a,'\u000f\u0003\u0004\u0002NU\u0001\raS\u0001\u0016aJ|7-Z:t_J$\u0006N]3bIB\u0013XMZ5y\u0003=\u0019H/\u0019:u!J|7-Z:t_J\u001cH\u0003BA\u001e\u0003'Ba!!\u0014\u0017\u0001\u0004YECBA\u001e\u0003/\n\t\u0007\u0003\u0004s/\u0001\u0007\u0011\u0011\f\t\u0006\u00037\ni\u0006`\u0007\u0002q&\u0019\u0011q\f=\u0003\u0007M+\u0017\u000f\u0003\u0004\u0002N]\u0001\raS\u0001\u0011e\u0016lwN^3Qe>\u001cWm]:peN$b!a\u000f\u0002h\u0005-\u0004BBA51\u0001\u0007A(A\u0006sK6|g/Z\"pk:$\bbBA71\u0001\u0007\u0011qN\u0001\u000fe\u0016\fX/Z:u\u0007\"\fgN\\3m!\r9\u0013\u0011O\u0005\u0004\u0003g\n#A\u0004*fcV,7\u000f^\"iC:tW\r\\\u0001\u0011S:LG/[1uKNCW\u000f\u001e3po:$\"!a\u000f\u0002\u001b\u0005<\u0018-\u001b;TQV$Hm\\<o\u0003\r\u0011XO\\\u0001\u0011_B,gnU3sm\u0016\u00148k\\2lKR$RA\\AA\u0003\u000bCa!a!\u001d\u0001\u0004Y\u0015\u0001\u00025pgRDa!a\"\u001d\u0001\u0004a\u0014\u0001\u00029peR\fa!Y2dKB$H\u0003BAG\u00033\u0003R!PAH\u0003'K1!!%?\u0005\u0019y\u0005\u000f^5p]B\u0019!-!&\n\u0007\u0005]5MA\u0007T_\u000e\\W\r^\"iC:tW\r\u001c\u0005\b\u00037k\u0002\u0019AAO\u0003\rYW-\u001f\t\u0004E\u0006}\u0015bAAQG\na1+\u001a7fGRLwN\\&fs\u0006\u0019\u0012m]:jO:tUm^\"p]:,7\r^5p]RA\u0011qUAW\u0003c\u000b)\fE\u0002>\u0003SK1!a+?\u0005\u001d\u0011un\u001c7fC:Dq!a,\u001f\u0001\u0004\t\u0019*A\u0007t_\u000e\\W\r^\"iC:tW\r\u001c\u0005\u0007\u0003gs\u0002\u0019\u0001?\u0002\u0013A\u0014xnY3tg>\u0014\bbBA\\=\u0001\u0007\u0011qU\u0001\t[\u0006L(\t\\8dW\u00061q/Y6fkBD3aHA_!\u0011\ty,!2\u000e\u0005\u0005\u0005'bAAbO\u0006!A.\u00198h\u0013\u0011\t9-!1\u0003\u0011=3XM\u001d:jI\u0016\u0004")
public class Acceptor
extends AbstractServerThread
implements KafkaMetricsGroup {
    private final EndPoint endPoint;
    private final int sendBufferSize;
    private final int recvBufferSize;
    private final int brokerId;
    private final ConnectionQuotas connectionQuotas;
    private final Selector nioSelector;
    private final ServerSocketChannel serverChannel;
    private final ArrayBuffer<Processor> processors;
    private final AtomicBoolean processorsStarted;
    private final Meter blockedPercentMeter;

    @Override
    public MetricName metricName(String name, Map<String, String> tags) {
        return KafkaMetricsGroup.metricName$(this, name, tags);
    }

    @Override
    public MetricName explicitMetricName(String group, String typeName, String name, Map<String, String> tags) {
        return KafkaMetricsGroup.explicitMetricName$(this, group, typeName, name, tags);
    }

    @Override
    public <T> Gauge<T> newGauge(String name, Gauge<T> metric, Map<String, String> tags) {
        return KafkaMetricsGroup.newGauge$(this, name, metric, tags);
    }

    @Override
    public <T> Map<String, String> newGauge$default$3() {
        return KafkaMetricsGroup.newGauge$default$3$(this);
    }

    @Override
    public Meter newMeter(String name, String eventType, TimeUnit timeUnit, Map<String, String> tags) {
        return KafkaMetricsGroup.newMeter$(this, name, eventType, timeUnit, tags);
    }

    @Override
    public Map<String, String> newMeter$default$4() {
        return KafkaMetricsGroup.newMeter$default$4$(this);
    }

    @Override
    public Histogram newHistogram(String name, boolean biased, Map<String, String> tags) {
        return KafkaMetricsGroup.newHistogram$(this, name, biased, tags);
    }

    @Override
    public boolean newHistogram$default$2() {
        return KafkaMetricsGroup.newHistogram$default$2$(this);
    }

    @Override
    public Map<String, String> newHistogram$default$3() {
        return KafkaMetricsGroup.newHistogram$default$3$(this);
    }

    @Override
    public Timer newTimer(String name, TimeUnit durationUnit, TimeUnit rateUnit, Map<String, String> tags) {
        return KafkaMetricsGroup.newTimer$(this, name, durationUnit, rateUnit, tags);
    }

    @Override
    public Map<String, String> newTimer$default$4() {
        return KafkaMetricsGroup.newTimer$default$4$(this);
    }

    @Override
    public void removeMetric(String name, Map<String, String> tags) {
        KafkaMetricsGroup.removeMetric$(this, name, tags);
    }

    @Override
    public Map<String, String> removeMetric$default$2() {
        return KafkaMetricsGroup.removeMetric$default$2$(this);
    }

    public EndPoint endPoint() {
        return this.endPoint;
    }

    public int sendBufferSize() {
        return this.sendBufferSize;
    }

    public int recvBufferSize() {
        return this.recvBufferSize;
    }

    private Selector nioSelector() {
        return this.nioSelector;
    }

    public ServerSocketChannel serverChannel() {
        return this.serverChannel;
    }

    private ArrayBuffer<Processor> processors() {
        return this.processors;
    }

    private AtomicBoolean processorsStarted() {
        return this.processorsStarted;
    }

    private Meter blockedPercentMeter() {
        return this.blockedPercentMeter;
    }

    public synchronized void addProcessors(Buffer<Processor> newProcessors, String processorThreadPrefix) {
        this.processors().$plus$plus$eq(newProcessors);
        if (this.processorsStarted().get()) {
            this.startProcessors((Seq<Processor>)newProcessors, processorThreadPrefix);
        }
    }

    public synchronized void startProcessors(String processorThreadPrefix) {
        if (!this.processorsStarted().getAndSet(true)) {
            this.startProcessors((Seq<Processor>)this.processors(), processorThreadPrefix);
        }
    }

    private synchronized void startProcessors(Seq<Processor> processors, String processorThreadPrefix) {
        processors.foreach((Function1 & Serializable & scala.Serializable)processor -> {
            Acceptor.$anonfun$startProcessors$1(this, processorThreadPrefix, processor);
            return BoxedUnit.UNIT;
        });
    }

    public synchronized void removeProcessors(int removeCount, RequestChannel requestChannel) {
        ArrayBuffer toRemove = (ArrayBuffer)this.processors().takeRight(removeCount);
        this.processors().remove(this.processors().size() - removeCount, removeCount);
        toRemove.foreach((Function1 & Serializable & scala.Serializable)x$13 -> {
            x$13.initiateShutdown();
            return BoxedUnit.UNIT;
        });
        toRemove.foreach((Function1 & Serializable & scala.Serializable)x$14 -> {
            x$14.awaitShutdown();
            return BoxedUnit.UNIT;
        });
        toRemove.foreach((Function1 & Serializable & scala.Serializable)processor -> {
            requestChannel.removeProcessor(processor.id());
            return BoxedUnit.UNIT;
        });
    }

    @Override
    public void initiateShutdown() {
        super.initiateShutdown();
        synchronized (this) {
            this.processors().foreach((Function1 & Serializable & scala.Serializable)x$15 -> {
                x$15.initiateShutdown();
                return BoxedUnit.UNIT;
            });
            return;
        }
    }

    @Override
    public void awaitShutdown() {
        super.awaitShutdown();
        synchronized (this) {
            this.processors().foreach((Function1 & Serializable & scala.Serializable)x$16 -> {
                x$16.awaitShutdown();
                return BoxedUnit.UNIT;
            });
            return;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void run() {
        this.serverChannel().register(this.nioSelector(), 16);
        this.startupComplete();
        try {
            IntRef currentProcessorIndex = IntRef.create((int)0);
            while (this.isRunning()) {
                try {
                    if (this.nioSelector().select(500L) <= 0) continue;
                    Iterator<SelectionKey> iter = this.nioSelector().selectedKeys().iterator();
                    while (iter.hasNext() && this.isRunning()) {
                        try {
                            Option<SocketChannel> foreach_this;
                            SelectionKey key = iter.next();
                            iter.remove();
                            if (!key.isAcceptable()) throw new IllegalStateException("Unrecognized key state for acceptor thread.");
                            if (this.accept(key) == null) {
                                throw null;
                            }
                            if (foreach_this.isEmpty()) continue;
                            SocketChannel socketChannel = (SocketChannel)foreach_this.get();
                            Acceptor.$anonfun$run$1(this, currentProcessorIndex, socketChannel);
                        }
                        catch (Throwable e) {
                            this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Error while accepting connection", (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
                        }
                    }
                }
                catch (Throwable throwable) {
                    if (throwable instanceof ControlThrowable) {
                        throw (Throwable)((ControlThrowable)throwable);
                    }
                    if (throwable == null) throw null;
                    this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Error occurred", (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> throwable);
                    continue;
                    return;
                }
            }
        }
        finally {
            this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Closing server socket and selector.");
            CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.serverChannel().close(), this, Level.ERROR);
            CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.nioSelector().close(), this, Level.ERROR);
            this.shutdownComplete();
        }
    }

    private ServerSocketChannel openServerSocket(String host, int port) {
        InetSocketAddress socketAddress = host == null || host.trim().isEmpty() ? new InetSocketAddress(port) : new InetSocketAddress(host, port);
        ServerSocketChannel serverChannel = ServerSocketChannel.open();
        serverChannel.configureBlocking(false);
        if (this.recvBufferSize() != -1) {
            serverChannel.socket().setReceiveBufferSize(this.recvBufferSize());
        }
        try {
            serverChannel.socket().bind(socketAddress);
            this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(33).append("Awaiting socket connections on ").append(socketAddress.getHostString()).append(":").append(serverChannel.socket().getLocalPort()).append(".").toString());
        }
        catch (SocketException e) {
            throw new KafkaException(new StringBuilder(36).append("Socket server failed to bind to ").append(socketAddress.getHostString()).append(":").append(port).append(": ").append(e.getMessage()).append(".").toString(), (Throwable)e);
        }
        return serverChannel;
    }

    private Option<SocketChannel> accept(SelectionKey key) {
        SocketChannel socketChannel = ((ServerSocketChannel)key.channel()).accept();
        try {
            this.connectionQuotas.inc(this.endPoint().listenerName(), socketChannel.socket().getInetAddress(), this.blockedPercentMeter());
            socketChannel.configureBlocking(false);
            socketChannel.socket().setTcpNoDelay(true);
            socketChannel.socket().setKeepAlive(true);
            if (this.sendBufferSize() != -1) {
                socketChannel.socket().setSendBufferSize(this.sendBufferSize());
            }
            return new Some((Object)socketChannel);
        }
        catch (TooManyConnectionsException e) {
            this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(86).append("Rejected connection from ").append(e.ip()).append(", address already has the configured maximum of ").append(e.count()).append(" connections.").toString());
            this.close(this.endPoint().listenerName(), socketChannel);
            return None$.MODULE$;
        }
    }

    private boolean assignNewConnection(SocketChannel socketChannel, Processor processor, boolean mayBlock) {
        if (processor.accept(socketChannel, mayBlock, this.blockedPercentMeter())) {
            this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(138).append("Accepted connection from ").append(socketChannel.socket().getRemoteSocketAddress()).append(" on").append(" ").append(socketChannel.socket().getLocalSocketAddress()).append(" and assigned it to processor ").append(processor.id()).append(",").append(" sendBufferSize [actual|requested]: [").append(socketChannel.socket().getSendBufferSize()).append("|").append(this.sendBufferSize()).append("]").append(" recvBufferSize [actual|requested]: [").append(socketChannel.socket().getReceiveBufferSize()).append("|").append(this.recvBufferSize()).append("]").toString());
            return true;
        }
        return false;
    }

    @Override
    public void wakeup() {
        this.nioSelector().wakeup();
    }

    public static final /* synthetic */ void $anonfun$startProcessors$1(Acceptor $this, String processorThreadPrefix$1, Processor processor) {
        String nonDaemon_name = new StringBuilder(25).append(processorThreadPrefix$1).append("-kafka-network-thread-").append($this.brokerId).append("-").append($this.endPoint().listenerName()).append("-").append($this.endPoint().securityProtocol()).append("-").append(processor.id()).toString();
        new KafkaThread(nonDaemon_name, (Runnable)processor, false).start();
    }

    public static final /* synthetic */ void $anonfun$run$1(Acceptor $this, IntRef currentProcessorIndex$1, SocketChannel socketChannel) {
        Processor processor;
        int n;
        synchronized ($this) {
            n = $this.processors().length();
        }
        int retriesLeft = n;
        do {
            --retriesLeft;
            synchronized ($this) {
                currentProcessorIndex$1.elem %= $this.processors().length();
                processor = (Processor)$this.processors().apply(currentProcessorIndex$1.elem);
            }
            ++currentProcessorIndex$1.elem;
        } while (!$this.assignNewConnection(socketChannel, processor, retriesLeft == 0));
    }

    /*
     * WARNING - void declaration
     */
    public Acceptor(EndPoint endPoint, int sendBufferSize, int recvBufferSize, int brokerId, ConnectionQuotas connectionQuotas, String metricPrefix) {
        void $minus$greater$extension_y;
        void $minus$greater$extension_$this;
        this.endPoint = endPoint;
        this.sendBufferSize = sendBufferSize;
        this.recvBufferSize = recvBufferSize;
        this.brokerId = brokerId;
        this.connectionQuotas = connectionQuotas;
        super(connectionQuotas);
        KafkaMetricsGroup.$init$(this);
        this.nioSelector = Selector.open();
        this.serverChannel = this.openServerSocket(endPoint.host(), endPoint.port());
        this.processors = new ArrayBuffer();
        this.processorsStarted = new AtomicBoolean();
        Tuple2[] tuple2Array = new Tuple2[1];
        String string = endPoint.listenerName().value();
        Object object = Predef$.MODULE$.ArrowAssoc((Object)Processor$.MODULE$.ListenerMetricTag());
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[0] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
        this.blockedPercentMeter = this.newMeter(new StringBuilder(22).append(metricPrefix).append("AcceptorBlockedPercent").toString(), "blocked time", TimeUnit.NANOSECONDS, (Map<String, String>)((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array))));
    }

    public static final /* synthetic */ Object $anonfun$run$1$adapted(Acceptor $this, IntRef currentProcessorIndex$1, SocketChannel socketChannel) {
        Acceptor.$anonfun$run$1($this, currentProcessorIndex$1, socketChannel);
        return BoxedUnit.UNIT;
    }
}

