/*
 * Decompiled with CFR 0.152.
 */
package kafka.zk;

import com.fasterxml.jackson.core.JsonProcessingException;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import kafka.utils.Json$;
import kafka.utils.json.DecodeJson$;
import kafka.utils.json.DecodeJson$DecodeInt$;
import kafka.utils.json.JsonObject;
import kafka.utils.json.JsonValue;
import kafka.zk.FeatureZNode;
import kafka.zk.FeatureZNodeStatus$;
import org.apache.kafka.common.feature.Features;
import org.apache.kafka.common.feature.FinalizedVersionRange;
import scala.Enumeration;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.jdk.CollectionConverters$;
import scala.runtime.BoxesRunTime;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

public final class FeatureZNode$
implements scala.Serializable {
    public static FeatureZNode$ MODULE$;
    private final String VersionKey;
    private final String StatusKey;
    private final String FeaturesKey;
    private final int V1;
    private final int CurrentVersion;

    static {
        new FeatureZNode$();
    }

    private String VersionKey() {
        return this.VersionKey;
    }

    private String StatusKey() {
        return this.StatusKey;
    }

    private String FeaturesKey() {
        return this.FeaturesKey;
    }

    public int V1() {
        return this.V1;
    }

    public int CurrentVersion() {
        return this.CurrentVersion;
    }

    public String path() {
        return "/feature";
    }

    public java.util.Map<String, java.util.Map<String, Short>> asJavaMap(Map<String, Map<String, Object>> scalaMap) {
        return (java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)scalaMap.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            void $minus$greater$extension_y;
            void $minus$greater$extension_$this;
            if (x0$1 != null) {
                String featureName = (String)x0$1._1();
                Map versionInfo = (Map)x0$1._2();
                Object object = CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)versionInfo.map((Function1 & Serializable & scala.Serializable)x0$2 -> {
                    void $minus$greater$extension_y;
                    void $minus$greater$extension_$this;
                    if (x0$2 != null) {
                        String label = (String)x0$2._1();
                        short version = BoxesRunTime.unboxToShort((Object)x0$2._2());
                        Short s = version;
                        Object object = Predef$.MODULE$.ArrowAssoc((Object)label);
                        if (Predef.ArrowAssoc$.MODULE$ == null) {
                            throw null;
                        }
                    } else {
                        throw new MatchError(null);
                    }
                    Tuple2 tuple2 = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
                    return tuple2;
                }, Map$.MODULE$.canBuildFrom())).asJava();
                Object object2 = Predef$.MODULE$.ArrowAssoc((Object)featureName);
                if (Predef.ArrowAssoc$.MODULE$ == null) {
                    throw null;
                }
            } else {
                throw new MatchError(null);
            }
            Tuple2 tuple2 = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
            return tuple2;
        }, Map$.MODULE$.canBuildFrom())).asJava();
    }

    /*
     * WARNING - void declaration
     */
    public byte[] encode(FeatureZNode featureZNode) {
        void $minus$greater$extension_y;
        void $minus$greater$extension_$this;
        void $minus$greater$extension_y2;
        void $minus$greater$extension_$this2;
        void $minus$greater$extension_y3;
        void $minus$greater$extension_$this3;
        Tuple2[] tuple2Array = new Tuple2[3];
        Integer n = BoxesRunTime.boxToInteger((int)this.CurrentVersion());
        Object object = Predef$.MODULE$.ArrowAssoc((Object)this.VersionKey());
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[0] = new Tuple2((Object)$minus$greater$extension_$this3, (Object)$minus$greater$extension_y3);
        Integer n2 = BoxesRunTime.boxToInteger((int)featureZNode.status().id());
        Object object2 = Predef$.MODULE$.ArrowAssoc((Object)this.StatusKey());
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[1] = new Tuple2((Object)$minus$greater$extension_$this2, (Object)$minus$greater$extension_y2);
        java.util.Map map = featureZNode.features().toMap();
        Object object3 = Predef$.MODULE$.ArrowAssoc((Object)this.FeaturesKey());
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[2] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
        scala.collection.mutable.Map jsonMap = (scala.collection.mutable.Map)scala.collection.mutable.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array));
        return Json$.MODULE$.encodeAsBytes(CollectionConverters$.MODULE$.mutableMapAsJavaMapConverter(jsonMap).asJava());
    }

    public FeatureZNode decode(byte[] jsonBytes) {
        Features finalizedFeatures;
        Option<Enumeration.Value> status;
        Either<JsonProcessingException, JsonValue> either = Json$.MODULE$.tryParseBytes(jsonBytes);
        if (either instanceof Right) {
            JsonObject featureInfo = ((JsonValue)((Right)either).value()).asJsonObject();
            int version = BoxesRunTime.unboxToInt((Object)featureInfo.apply(this.VersionKey()).to(DecodeJson$DecodeInt$.MODULE$));
            if (version < this.V1()) {
                throw new IllegalArgumentException(new StringBuilder(46).append("Unsupported version: ").append(version).append(" of feature information: ").append(new String(jsonBytes, StandardCharsets.UTF_8)).toString());
            }
            Option<JsonValue> option = featureInfo.get(this.FeaturesKey());
            if (option == null) {
                throw null;
            }
            Option<JsonValue> flatMap_this = option;
            Object object = flatMap_this.isEmpty() ? None$.MODULE$ : ((JsonValue)flatMap_this.get()).to(DecodeJson$.MODULE$.decodeOption(DecodeJson$.MODULE$.decodeMap(DecodeJson$.MODULE$.decodeMap(DecodeJson$DecodeInt$.MODULE$, Map$.MODULE$.canBuildFrom()), Map$.MODULE$.canBuildFrom())));
            if (object.isEmpty()) {
                throw new IllegalArgumentException(new StringBuilder(35).append("Features map can not be absent in: ").append(new String(jsonBytes, StandardCharsets.UTF_8)).toString());
            }
            Object object2 = object.isEmpty() ? None$.MODULE$ : new Some((Object)FeatureZNode$.$anonfun$decode$33((Map)object.get()));
            if (object2 == null) {
                throw null;
            }
            Object object3 = object2.isEmpty() ? FeatureZNode$.$anonfun$decode$36() : object2.get();
            java.util.Map<String, java.util.Map<String, Short>> features = this.asJavaMap((Map<String, Map<String, Object>>)object3);
            Option<JsonValue> option2 = featureInfo.get(this.StatusKey());
            if (option2 == null) {
                throw null;
            }
            Option<JsonValue> flatMap_this2 = option2;
            Object object4 = flatMap_this2.isEmpty() ? None$.MODULE$ : ((JsonValue)flatMap_this2.get()).to(DecodeJson$.MODULE$.decodeOption(DecodeJson$DecodeInt$.MODULE$));
            if (object4.isEmpty()) {
                throw new IllegalArgumentException(new StringBuilder(49).append("Status can not be absent in feature information: ").append(new String(jsonBytes, StandardCharsets.UTF_8)).toString());
            }
            status = FeatureZNodeStatus$.MODULE$.withNameOpt(BoxesRunTime.unboxToInt((Object)object4.get()));
            if (status.isEmpty()) {
                throw new IllegalArgumentException(new StringBuilder(49).append("Malformed status: ").append(object4).append(" found in feature information: ").append(new String(jsonBytes, StandardCharsets.UTF_8)).toString());
            }
            try {
                finalizedFeatures = Features.fromFinalizedFeaturesMap(features);
            }
            catch (Exception e) {
                throw new IllegalArgumentException(new StringBuilder(50).append("Unable to convert to finalized features from map: ").append(features).toString(), e);
            }
        } else {
            if (either instanceof Left) {
                JsonProcessingException e = (JsonProcessingException)((Left)either).value();
                throw new IllegalArgumentException(new StringBuilder(37).append("Failed to parse feature information: ").append(new String(jsonBytes, StandardCharsets.UTF_8)).toString(), (Throwable)e);
            }
            throw new MatchError(either);
        }
        FeatureZNode featureZNode = new FeatureZNode((Enumeration.Value)status.get(), (Features<FinalizedVersionRange>)finalizedFeatures);
        return featureZNode;
    }

    public FeatureZNode apply(Enumeration.Value status, Features<FinalizedVersionRange> features) {
        return new FeatureZNode(status, features);
    }

    public Option<Tuple2<Enumeration.Value, Features<FinalizedVersionRange>>> unapply(FeatureZNode x$0) {
        if (x$0 == null) {
            return None$.MODULE$;
        }
        return new Some((Object)new Tuple2((Object)x$0.status(), x$0.features()));
    }

    private Object readResolve() {
        return MODULE$;
    }

    public static final /* synthetic */ Map $anonfun$decode$33(Map theMap) {
        return (Map)theMap.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            void $minus$greater$extension_y;
            void $minus$greater$extension_$this;
            if (x0$1 != null) {
                String featureName = (String)x0$1._1();
                Map versionInfo = (Map)x0$1._2();
                Object object = versionInfo.map((Function1 & Serializable & scala.Serializable)x0$2 -> {
                    void $minus$greater$extension_y;
                    void $minus$greater$extension_$this;
                    if (x0$2 != null) {
                        String label = (String)x0$2._1();
                        int version = x0$2._2$mcI$sp();
                        Short s = BoxesRunTime.boxToShort((short)((short)version));
                        Object object = Predef$.MODULE$.ArrowAssoc((Object)label);
                        if (Predef.ArrowAssoc$.MODULE$ == null) {
                            throw null;
                        }
                    } else {
                        throw new MatchError(null);
                    }
                    Tuple2 tuple2 = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
                    return tuple2;
                }, Map$.MODULE$.canBuildFrom());
                Object object2 = Predef$.MODULE$.ArrowAssoc((Object)featureName);
                if (Predef.ArrowAssoc$.MODULE$ == null) {
                    throw null;
                }
            } else {
                throw new MatchError(null);
            }
            Tuple2 tuple2 = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
            return tuple2;
        }, Map$.MODULE$.canBuildFrom());
    }

    public static final /* synthetic */ Map $anonfun$decode$36() {
        return (Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
    }

    private FeatureZNode$() {
        MODULE$ = this;
        this.VersionKey = "version";
        this.StatusKey = "status";
        this.FeaturesKey = "features";
        this.V1 = 1;
        this.CurrentVersion = this.V1();
    }
}

