/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.lucene.all;

import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.index.IndexableFieldType;
import org.elasticsearch.common.lucene.all.AllTokenStream;

public class AllField
extends Field {
    private final float boost;

    public AllField(String name, String value, float boost, FieldType fieldType) {
        super(name, (CharSequence)value, (IndexableFieldType)fieldType);
        this.boost = boost;
    }

    public TokenStream tokenStream(Analyzer analyzer, TokenStream previous) {
        TokenStream ts = analyzer.tokenStream(this.name(), this.stringValue());
        if (this.boost != 1.0f && this.fieldType().indexOptions().compareTo((Enum)IndexOptions.DOCS_AND_FREQS_AND_POSITIONS) >= 0) {
            return new AllTokenStream(ts, this.boost);
        }
        return ts;
    }
}

