/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.query;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.index.query.AbstractQueryBuilder;

public abstract class BaseTermQueryBuilder<QB extends BaseTermQueryBuilder<QB>>
extends AbstractQueryBuilder<QB> {
    public static final ParseField VALUE_FIELD = new ParseField("value", new String[0]);
    protected final String fieldName;
    protected final Object value;

    public BaseTermQueryBuilder(String fieldName, String value) {
        this(fieldName, (Object)value);
    }

    public BaseTermQueryBuilder(String fieldName, int value) {
        this(fieldName, (Object)value);
    }

    public BaseTermQueryBuilder(String fieldName, long value) {
        this(fieldName, (Object)value);
    }

    public BaseTermQueryBuilder(String fieldName, float value) {
        this(fieldName, Float.valueOf(value));
    }

    public BaseTermQueryBuilder(String fieldName, double value) {
        this(fieldName, (Object)value);
    }

    public BaseTermQueryBuilder(String fieldName, boolean value) {
        this(fieldName, (Object)value);
    }

    public BaseTermQueryBuilder(String fieldName, Object value) {
        if (Strings.isEmpty(fieldName)) {
            throw new IllegalArgumentException("field name is null or empty");
        }
        if (value == null) {
            throw new IllegalArgumentException("value cannot be null");
        }
        this.fieldName = fieldName;
        this.value = BaseTermQueryBuilder.maybeConvertToBytesRef(value);
    }

    protected BaseTermQueryBuilder(StreamInput in) throws IOException {
        super(in);
        this.fieldName = in.readString();
        this.value = in.readGenericValue();
    }

    @Override
    protected void doWriteTo(StreamOutput out) throws IOException {
        out.writeString(this.fieldName);
        out.writeGenericValue(this.value);
    }

    public String fieldName() {
        return this.fieldName;
    }

    public Object value() {
        return BaseTermQueryBuilder.maybeConvertToString(this.value);
    }

    @Override
    protected void doXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(this.getName());
        builder.startObject(this.fieldName);
        builder.field(VALUE_FIELD.getPreferredName(), BaseTermQueryBuilder.maybeConvertToString(this.value));
        this.printBoostAndQueryName(builder);
        builder.endObject();
        builder.endObject();
    }

    @Override
    protected final int doHashCode() {
        return Objects.hash(this.fieldName, this.value);
    }

    @Override
    protected final boolean doEquals(BaseTermQueryBuilder other) {
        return Objects.equals(this.fieldName, other.fieldName) && Objects.equals(this.value, other.value);
    }
}

