/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.shard;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Objects;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.NoMergePolicy;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.store.Lock;
import org.apache.lucene.store.LockFactory;
import org.apache.lucene.store.LockObtainFailedException;
import org.apache.lucene.store.NativeFSLockFactory;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.cli.EnvironmentAwareCommand;
import org.elasticsearch.cli.Terminal;
import org.elasticsearch.cluster.ClusterModule;
import org.elasticsearch.cluster.metadata.IndexMetaData;
import org.elasticsearch.cluster.routing.AllocationId;
import org.elasticsearch.cluster.routing.allocation.command.AllocateEmptyPrimaryAllocationCommand;
import org.elasticsearch.cluster.routing.allocation.command.AllocateStalePrimaryAllocationCommand;
import org.elasticsearch.cluster.routing.allocation.command.AllocationCommands;
import org.elasticsearch.common.CheckedConsumer;
import org.elasticsearch.common.CheckedFunction;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.SuppressForbidden;
import org.elasticsearch.common.UUIDs;
import org.elasticsearch.common.collect.Tuple;
import org.elasticsearch.common.io.PathUtils;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.env.Environment;
import org.elasticsearch.env.NodeEnvironment;
import org.elasticsearch.env.NodeMetaData;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.seqno.SequenceNumbers;
import org.elasticsearch.index.shard.RemoveCorruptedLuceneSegmentsAction;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.index.shard.ShardPath;
import org.elasticsearch.index.shard.ShardStateMetaData;
import org.elasticsearch.index.translog.TruncateTranslogAction;

public class RemoveCorruptedShardDataCommand
extends EnvironmentAwareCommand {
    private static final Logger logger = LogManager.getLogger(RemoveCorruptedShardDataCommand.class);
    private final OptionSpec<String> folderOption;
    private final OptionSpec<String> indexNameOption;
    private final OptionSpec<Integer> shardIdOption;
    private final RemoveCorruptedLuceneSegmentsAction removeCorruptedLuceneSegmentsAction;
    private final TruncateTranslogAction truncateTranslogAction;
    private final NamedXContentRegistry namedXContentRegistry;

    public RemoveCorruptedShardDataCommand() {
        this(false);
    }

    public RemoveCorruptedShardDataCommand(boolean translogOnly) {
        super("Removes corrupted shard files");
        this.folderOption = this.parser.acceptsAll(Arrays.asList("d", "dir"), "Index directory location on disk").withRequiredArg();
        this.indexNameOption = this.parser.accepts("index", "Index name").withRequiredArg();
        this.shardIdOption = this.parser.accepts("shard-id", "Shard id").withRequiredArg().ofType(Integer.class);
        this.namedXContentRegistry = new NamedXContentRegistry(ClusterModule.getNamedXWriteables());
        this.removeCorruptedLuceneSegmentsAction = translogOnly ? null : new RemoveCorruptedLuceneSegmentsAction();
        this.truncateTranslogAction = new TruncateTranslogAction(this.namedXContentRegistry);
    }

    protected void printAdditionalHelp(Terminal terminal) {
        if (this.removeCorruptedLuceneSegmentsAction == null) {
            terminal.println("This tool truncates the translog and translog checkpoint files to create a new translog");
        } else {
            terminal.println("This tool attempts to detect and remove unrecoverable corrupted data in a shard.");
        }
    }

    public OptionParser getParser() {
        return this.parser;
    }

    @SuppressForbidden(reason="Necessary to use the path passed in")
    protected Path getPath(String dirValue) {
        return PathUtils.get((String)dirValue, (String[])new String[]{"", ""});
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void findAndProcessShardPath(OptionSet options, Environment environment, CheckedConsumer<ShardPath, IOException> consumer) throws IOException {
        int toNodeId;
        int fromNodeId;
        String indexName;
        int shardId;
        Settings settings = environment.settings();
        if (options.has(this.folderOption)) {
            Path path = this.getPath((String)this.folderOption.value(options)).getParent();
            Path shardParent = path.getParent();
            Path shardParentParent = shardParent.getParent();
            Path indexPath = path.resolve("index");
            if (!Files.exists(indexPath, new LinkOption[0]) || !Files.isDirectory(indexPath, new LinkOption[0])) {
                throw new ElasticsearchException("index directory [" + indexPath + "], must exist and be a directory", new Object[0]);
            }
            IndexMetaData indexMetaData = IndexMetaData.FORMAT.loadLatestState(logger, this.namedXContentRegistry, shardParent);
            String shardIdFileName = path.getFileName().toString();
            String nodeIdFileName = shardParentParent.getParent().getFileName().toString();
            if (!Files.isDirectory(path, new LinkOption[0]) || !shardIdFileName.chars().allMatch(Character::isDigit) || !"indices".equals(shardParentParent.getFileName().toString()) || !nodeIdFileName.chars().allMatch(Character::isDigit) || !"nodes".equals(shardParentParent.getParent().getParent().getFileName().toString())) throw new ElasticsearchException("Unable to resolve shard id. Wrong folder structure at [ " + path.toString() + " ], expected .../nodes/[NODE-ID]/indices/[INDEX-UUID]/[SHARD-ID]", new Object[0]);
            shardId = Integer.parseInt(shardIdFileName);
            indexName = indexMetaData.getIndex().getName();
            fromNodeId = Integer.parseInt(nodeIdFileName);
            toNodeId = fromNodeId + 1;
        } else {
            indexName = Objects.requireNonNull((String)this.indexNameOption.value(options), "Index name is required");
            shardId = Objects.requireNonNull((Integer)this.shardIdOption.value(options), "Shard ID is required");
            fromNodeId = 0;
            toNodeId = NodeEnvironment.MAX_LOCAL_STORAGE_NODES_SETTING.get(settings);
        }
        for (int possibleLockId = fromNodeId; possibleLockId < toNodeId; ++possibleLockId) {
            try (NodeEnvironment.NodeLock nodeLock = new NodeEnvironment.NodeLock(possibleLockId, logger, environment, (CheckedFunction<Path, Boolean, IOException>)((CheckedFunction)x$0 -> Files.exists(x$0, new LinkOption[0])));){
                NodeEnvironment.NodePath[] nodePaths;
                block15: for (NodeEnvironment.NodePath nodePath : nodePaths = nodeLock.getNodePaths()) {
                    if (!Files.exists(nodePath.indicesPath, new LinkOption[0])) continue;
                    try (DirectoryStream<Path> stream = Files.newDirectoryStream(nodePath.indicesPath);){
                        Iterator<Path> iterator = stream.iterator();
                        while (true) {
                            ShardId shId;
                            Path shardPathLocation;
                            IndexMetaData indexMetaData;
                            if (!iterator.hasNext()) continue block15;
                            Path file = iterator.next();
                            if (!Files.exists(file.resolve("_state"), new LinkOption[0]) || (indexMetaData = IndexMetaData.FORMAT.loadLatestState(logger, this.namedXContentRegistry, file)) == null) continue;
                            IndexSettings indexSettings = new IndexSettings(indexMetaData, settings);
                            Index index = indexMetaData.getIndex();
                            if (!indexName.equals(index.getName()) || !Files.exists(shardPathLocation = nodePath.resolve(shId = new ShardId(index, shardId)), new LinkOption[0])) continue;
                            ShardPath shardPath = ShardPath.loadShardPath(logger, shId, indexSettings, new Path[]{shardPathLocation}, possibleLockId, nodePath.path);
                            if (shardPath == null) continue;
                            consumer.accept(shardPath);
                            return;
                        }
                    }
                }
                continue;
            }
            catch (LockObtainFailedException lofe) {
                throw new ElasticsearchException("Failed to lock node's directory [" + lofe.getMessage() + "], is Elasticsearch still running ?", new Object[0]);
            }
        }
        throw new ElasticsearchException("Unable to resolve shard path for index [" + indexName + "] and shard id [" + shardId + "]", new Object[0]);
    }

    public static boolean isCorruptMarkerFileIsPresent(Directory directory) throws IOException {
        String[] files;
        boolean found = false;
        for (String file : files = directory.listAll()) {
            if (!file.startsWith("corrupted_")) continue;
            found = true;
            break;
        }
        return found;
    }

    protected void dropCorruptMarkerFiles(Terminal terminal, Path path, Directory directory, boolean clean) throws IOException {
        if (clean) {
            RemoveCorruptedShardDataCommand.confirm("This shard has been marked as corrupted but no corruption can now be detected.\nThis may indicate an intermittent hardware problem. The corruption marker can be \nremoved, but there is a risk that data has been undetectably lost.\n\nAre you taking a risk of losing documents and proceed with removing a corrupted marker ?", terminal);
        }
        String[] files = directory.listAll();
        boolean found = false;
        for (String file : files) {
            if (!file.startsWith("corrupted_")) continue;
            directory.deleteFile(file);
            terminal.println("Deleted corrupt marker " + file + " from " + path);
        }
    }

    private static void loseDataDetailsBanner(Terminal terminal, Tuple<CleanStatus, String> cleanStatus) {
        if (cleanStatus.v2() != null) {
            terminal.println("");
            terminal.println("  " + (String)cleanStatus.v2());
            terminal.println("");
        }
    }

    private static void confirm(String msg, Terminal terminal) {
        terminal.println(msg);
        String text = terminal.readText("Confirm [y/N] ");
        if (!text.equalsIgnoreCase("y")) {
            throw new ElasticsearchException("aborted by user", new Object[0]);
        }
    }

    private void warnAboutESShouldBeStopped(Terminal terminal) {
        terminal.println("-----------------------------------------------------------------------");
        terminal.println("");
        terminal.println("    WARNING: Elasticsearch MUST be stopped before running this tool.");
        terminal.println("");
        if (this.removeCorruptedLuceneSegmentsAction == null) {
            terminal.println("  This tool is deprecated and will be completely removed in 7.0.");
            terminal.println("  It is replaced by the elasticsearch-shard tool. ");
            terminal.println("");
        }
        terminal.println("  Please make a complete backup of your index before using this tool.");
        terminal.println("");
        terminal.println("-----------------------------------------------------------------------");
    }

    @Override
    public void execute(Terminal terminal, OptionSet options, Environment environment) throws Exception {
        this.warnAboutESShouldBeStopped(terminal);
        this.findAndProcessShardPath(options, environment, shardPath -> {
            Directory indexDirectory;
            Path indexPath = shardPath.resolveIndex();
            Path translogPath = shardPath.resolveTranslog();
            Path nodePath = this.getNodePath((ShardPath)shardPath);
            if (!Files.exists(translogPath, new LinkOption[0]) || !Files.isDirectory(translogPath, new LinkOption[0])) {
                throw new ElasticsearchException("translog directory [" + translogPath + "], must exist and be a directory", new Object[0]);
            }
            final PrintWriter writer = terminal.getWriter();
            PrintStream printStream = new PrintStream(new OutputStream(){

                @Override
                public void write(int b) {
                    writer.write(b);
                }
            }, false, "UTF-8");
            boolean verbose = terminal.isPrintable(Terminal.Verbosity.VERBOSE);
            try (Directory indexDir = indexDirectory = this.getDirectory(indexPath);){
                Tuple<CleanStatus, String> translogCleanStatus;
                Tuple<CleanStatus, String> indexCleanStatus;
                try (Lock writeIndexLock = indexDir.obtainLock("write.lock");){
                    if (this.removeCorruptedLuceneSegmentsAction != null) {
                        terminal.println("");
                        terminal.println("Opening Lucene index at " + indexPath);
                        terminal.println("");
                        try {
                            indexCleanStatus = this.removeCorruptedLuceneSegmentsAction.getCleanStatus((ShardPath)shardPath, indexDir, writeIndexLock, printStream, verbose);
                        }
                        catch (Exception e) {
                            terminal.println(e.getMessage());
                            throw e;
                        }
                        terminal.println("");
                        terminal.println(" >> Lucene index is " + ((CleanStatus)((Object)((Object)indexCleanStatus.v1()))).getMessage() + " at " + indexPath);
                        terminal.println("");
                    } else {
                        indexCleanStatus = Tuple.tuple((Object)((Object)CleanStatus.CLEAN), null);
                    }
                    if (indexCleanStatus.v1() != CleanStatus.UNRECOVERABLE) {
                        terminal.println("");
                        terminal.println("Opening translog at " + translogPath);
                        terminal.println("");
                        try {
                            translogCleanStatus = this.truncateTranslogAction.getCleanStatus((ShardPath)shardPath, indexDir);
                        }
                        catch (Exception e) {
                            terminal.println(e.getMessage());
                            throw e;
                        }
                        terminal.println("");
                        terminal.println(" >> Translog is " + ((CleanStatus)((Object)((Object)translogCleanStatus.v1()))).getMessage() + " at " + translogPath);
                        terminal.println("");
                    } else {
                        translogCleanStatus = Tuple.tuple((Object)((Object)CleanStatus.UNRECOVERABLE), null);
                    }
                    CleanStatus indexStatus = (CleanStatus)((Object)((Object)indexCleanStatus.v1()));
                    CleanStatus translogStatus = (CleanStatus)((Object)((Object)translogCleanStatus.v1()));
                    if (indexStatus == CleanStatus.CLEAN && translogStatus == CleanStatus.CLEAN) {
                        throw new ElasticsearchException("Shard does not seem to be corrupted at " + shardPath.getDataPath(), new Object[0]);
                    }
                    if (indexStatus == CleanStatus.UNRECOVERABLE) {
                        if (indexCleanStatus.v2() != null) {
                            terminal.println("Details: " + (String)indexCleanStatus.v2());
                        }
                        terminal.println("You can allocate a new, empty, primary shard with the following command:");
                        this.printRerouteCommand((ShardPath)shardPath, terminal, false);
                        throw new ElasticsearchException("Index is unrecoverable", new Object[0]);
                    }
                    terminal.println("-----------------------------------------------------------------------");
                    if (indexStatus != CleanStatus.CLEAN) {
                        RemoveCorruptedShardDataCommand.loseDataDetailsBanner(terminal, indexCleanStatus);
                    }
                    if (translogStatus != CleanStatus.CLEAN) {
                        RemoveCorruptedShardDataCommand.loseDataDetailsBanner(terminal, translogCleanStatus);
                    }
                    terminal.println("            WARNING:              YOU MAY LOSE DATA.");
                    terminal.println("-----------------------------------------------------------------------");
                    RemoveCorruptedShardDataCommand.confirm("Continue and remove corrupted data from the shard ?", terminal);
                    if (indexStatus != CleanStatus.CLEAN) {
                        this.removeCorruptedLuceneSegmentsAction.execute(terminal, (ShardPath)shardPath, indexDir, writeIndexLock, printStream, verbose);
                    }
                    if (translogStatus != CleanStatus.CLEAN) {
                        this.truncateTranslogAction.execute(terminal, (ShardPath)shardPath, indexDir);
                    }
                }
                catch (LockObtainFailedException lofe) {
                    String msg = "Failed to lock shard's directory at [" + indexPath + "], is Elasticsearch still running?";
                    terminal.println(msg);
                    throw new ElasticsearchException(msg, new Object[0]);
                }
                CleanStatus indexStatus = (CleanStatus)((Object)((Object)indexCleanStatus.v1()));
                CleanStatus translogStatus = (CleanStatus)((Object)((Object)translogCleanStatus.v1()));
                this.addNewHistoryCommit(indexDir, terminal, translogStatus != CleanStatus.CLEAN);
                this.newAllocationId(environment, (ShardPath)shardPath, terminal);
                if (indexStatus != CleanStatus.CLEAN) {
                    this.dropCorruptMarkerFiles(terminal, indexPath, indexDir, indexStatus == CleanStatus.CLEAN_WITH_CORRUPTED_MARKER);
                }
            }
        });
    }

    private Directory getDirectory(Path indexPath) {
        FSDirectory directory;
        try {
            directory = FSDirectory.open((Path)indexPath, (LockFactory)NativeFSLockFactory.INSTANCE);
        }
        catch (Throwable t) {
            throw new ElasticsearchException("ERROR: could not open directory \"" + indexPath + "\"; exiting", new Object[0]);
        }
        return directory;
    }

    protected void addNewHistoryCommit(Directory indexDirectory, Terminal terminal, boolean updateLocalCheckpoint) throws IOException {
        String historyUUID = UUIDs.randomBase64UUID();
        terminal.println("Marking index with the new history uuid : " + historyUUID);
        IndexWriterConfig iwc = new IndexWriterConfig(null).setCommitOnClose(false).setSoftDeletesField("__soft_deletes").setMergePolicy(NoMergePolicy.INSTANCE).setOpenMode(IndexWriterConfig.OpenMode.APPEND);
        try (IndexWriter indexWriter = new IndexWriter(indexDirectory, iwc);){
            HashMap<String, String> userData = new HashMap<String, String>();
            indexWriter.getLiveCommitData().forEach(e -> userData.put((String)e.getKey(), (String)e.getValue()));
            if (updateLocalCheckpoint) {
                SequenceNumbers.CommitInfo commitInfo = SequenceNumbers.loadSeqNoInfoFromLuceneCommit(userData.entrySet());
                userData.put("local_checkpoint", Long.toString(commitInfo.maxSeqNo));
            }
            userData.put("history_uuid", historyUUID);
            indexWriter.setLiveCommitData(userData.entrySet());
            indexWriter.commit();
        }
    }

    protected void newAllocationId(Environment environment, ShardPath shardPath, Terminal terminal) throws IOException {
        Path shardStatePath = shardPath.getShardStatePath();
        ShardStateMetaData shardStateMetaData = ShardStateMetaData.FORMAT.loadLatestState(logger, this.namedXContentRegistry, shardStatePath);
        if (shardStateMetaData == null) {
            throw new ElasticsearchException("No shard state meta data at " + shardStatePath, new Object[0]);
        }
        AllocationId newAllocationId = AllocationId.newInitializing();
        terminal.println("Changing allocation id " + shardStateMetaData.allocationId.getId() + " to " + newAllocationId.getId());
        ShardStateMetaData newShardStateMetaData = new ShardStateMetaData(shardStateMetaData.primary, shardStateMetaData.indexUUID, newAllocationId);
        ShardStateMetaData.FORMAT.write(newShardStateMetaData, shardStatePath);
        terminal.println("");
        terminal.println("You should run the following command to allocate this shard:");
        this.printRerouteCommand(shardPath, terminal, true);
    }

    private void printRerouteCommand(ShardPath shardPath, Terminal terminal, boolean allocateStale) throws IOException {
        IndexMetaData indexMetaData = IndexMetaData.FORMAT.loadLatestState(logger, this.namedXContentRegistry, shardPath.getDataPath().getParent());
        Path nodePath = this.getNodePath(shardPath);
        NodeMetaData nodeMetaData = NodeMetaData.FORMAT.loadLatestState(logger, this.namedXContentRegistry, nodePath);
        if (nodeMetaData == null) {
            throw new ElasticsearchException("No node meta data at " + nodePath, new Object[0]);
        }
        String nodeId = nodeMetaData.nodeId();
        String index = indexMetaData.getIndex().getName();
        int id = shardPath.getShardId().id();
        AllocationCommands commands = new AllocationCommands(allocateStale ? new AllocateStalePrimaryAllocationCommand(index, id, nodeId, false) : new AllocateEmptyPrimaryAllocationCommand(index, id, nodeId, false));
        terminal.println("");
        terminal.println("POST /_cluster/reroute\n" + Strings.toString((ToXContent)commands, true, true));
        terminal.println("");
        terminal.println("You must accept the possibility of data loss by changing parameter `accept_data_loss` to `true`.");
        terminal.println("");
    }

    private Path getNodePath(ShardPath shardPath) {
        Path nodePath = shardPath.getDataPath().getParent().getParent().getParent();
        if (!Files.exists(nodePath, new LinkOption[0]) || !Files.exists(nodePath.resolve("_state"), new LinkOption[0])) {
            throw new ElasticsearchException("Unable to resolve node path for " + shardPath, new Object[0]);
        }
        return nodePath;
    }

    public static enum CleanStatus {
        CLEAN("clean"),
        CLEAN_WITH_CORRUPTED_MARKER("marked corrupted, but no corruption detected"),
        CORRUPTED("corrupted"),
        UNRECOVERABLE("corrupted and unrecoverable");

        private final String msg;

        private CleanStatus(String msg) {
            this.msg = msg;
        }

        public String getMessage() {
            return this.msg;
        }
    }
}

