/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.dbutils;

public class StatementConfiguration {
    private final Integer fetchDirection;
    private final Integer fetchSize;
    private final Integer maxFieldSize;
    private final Integer maxRows;
    private final Integer queryTimeout;

    public StatementConfiguration(Integer fetchDirection, Integer fetchSize, Integer maxFieldSize, Integer maxRows, Integer queryTimeout) {
        this.fetchDirection = fetchDirection;
        this.fetchSize = fetchSize;
        this.maxFieldSize = maxFieldSize;
        this.maxRows = maxRows;
        this.queryTimeout = queryTimeout;
    }

    public Integer getFetchDirection() {
        return this.fetchDirection;
    }

    public boolean isFetchDirectionSet() {
        return this.fetchDirection != null;
    }

    public Integer getFetchSize() {
        return this.fetchSize;
    }

    public boolean isFetchSizeSet() {
        return this.fetchSize != null;
    }

    public Integer getMaxFieldSize() {
        return this.maxFieldSize;
    }

    public boolean isMaxFieldSizeSet() {
        return this.maxFieldSize != null;
    }

    public Integer getMaxRows() {
        return this.maxRows;
    }

    public boolean isMaxRowsSet() {
        return this.maxRows != null;
    }

    public Integer getQueryTimeout() {
        return this.queryTimeout;
    }

    public boolean isQueryTimeoutSet() {
        return this.queryTimeout != null;
    }

    public static final class Builder {
        private Integer fetchDirection;
        private Integer fetchSize;
        private Integer maxRows;
        private Integer queryTimeout;
        private Integer maxFieldSize;

        public Builder fetchDirection(Integer fetchDirection) {
            this.fetchDirection = fetchDirection;
            return this;
        }

        public Builder fetchSize(Integer fetchSize) {
            this.fetchSize = fetchSize;
            return this;
        }

        public Builder maxRows(Integer maxRows) {
            this.maxRows = maxRows;
            return this;
        }

        public Builder queryTimeout(Integer queryTimeout) {
            this.queryTimeout = queryTimeout;
            return this;
        }

        public Builder maxFieldSize(Integer maxFieldSize) {
            this.maxFieldSize = maxFieldSize;
            return this;
        }

        public StatementConfiguration build() {
            return new StatementConfiguration(this.fetchDirection, this.fetchSize, this.maxFieldSize, this.maxRows, this.queryTimeout);
        }
    }
}

