/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import org.apache.iceberg.BaseTransaction;
import org.apache.iceberg.ManageSnapshots;
import org.apache.iceberg.Snapshot;
import org.apache.iceberg.TableOperations;
import org.apache.iceberg.UpdateSnapshotReferencesOperation;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;

public class SnapshotManager
implements ManageSnapshots {
    private final boolean isExternalTransaction;
    private final BaseTransaction transaction;
    private UpdateSnapshotReferencesOperation updateSnapshotReferencesOperation;

    SnapshotManager(String tableName, TableOperations ops) {
        Preconditions.checkState((ops.current() != null ? 1 : 0) != 0, (String)"Cannot manage snapshots: table %s does not exist", (Object)tableName);
        this.transaction = new BaseTransaction(tableName, ops, BaseTransaction.TransactionType.SIMPLE, ops.refresh());
        this.isExternalTransaction = false;
    }

    SnapshotManager(BaseTransaction transaction) {
        Preconditions.checkArgument((transaction != null ? 1 : 0) != 0, (Object)"Invalid input transaction: null");
        this.transaction = transaction;
        this.isExternalTransaction = true;
    }

    public ManageSnapshots cherrypick(long snapshotId) {
        this.commitIfRefUpdatesExist();
        this.transaction.cherryPick().cherrypick(snapshotId).commit();
        return this;
    }

    public ManageSnapshots setCurrentSnapshot(long snapshotId) {
        this.commitIfRefUpdatesExist();
        this.transaction.setBranchSnapshot().setCurrentSnapshot(snapshotId).commit();
        return this;
    }

    public ManageSnapshots rollbackToTime(long timestampMillis) {
        this.commitIfRefUpdatesExist();
        this.transaction.setBranchSnapshot().rollbackToTime(timestampMillis).commit();
        return this;
    }

    public ManageSnapshots rollbackTo(long snapshotId) {
        this.commitIfRefUpdatesExist();
        this.transaction.setBranchSnapshot().rollbackTo(snapshotId).commit();
        return this;
    }

    public ManageSnapshots createBranch(String name, long snapshotId) {
        this.updateSnapshotReferencesOperation().createBranch(name, snapshotId);
        return this;
    }

    public ManageSnapshots createTag(String name, long snapshotId) {
        this.updateSnapshotReferencesOperation().createTag(name, snapshotId);
        return this;
    }

    public ManageSnapshots removeBranch(String name) {
        this.updateSnapshotReferencesOperation().removeBranch(name);
        return this;
    }

    public ManageSnapshots removeTag(String name) {
        this.updateSnapshotReferencesOperation().removeTag(name);
        return this;
    }

    public ManageSnapshots setMinSnapshotsToKeep(String name, int minSnapshotsToKeep) {
        this.updateSnapshotReferencesOperation().setMinSnapshotsToKeep(name, minSnapshotsToKeep);
        return this;
    }

    public ManageSnapshots setMaxSnapshotAgeMs(String name, long maxSnapshotAgeMs) {
        this.updateSnapshotReferencesOperation().setMaxSnapshotAgeMs(name, maxSnapshotAgeMs);
        return this;
    }

    public ManageSnapshots setMaxRefAgeMs(String name, long maxRefAgeMs) {
        this.updateSnapshotReferencesOperation().setMaxRefAgeMs(name, maxRefAgeMs);
        return this;
    }

    public ManageSnapshots replaceTag(String name, long snapshotId) {
        this.updateSnapshotReferencesOperation().replaceTag(name, snapshotId);
        return this;
    }

    public ManageSnapshots replaceBranch(String name, long snapshotId) {
        this.updateSnapshotReferencesOperation().replaceBranch(name, snapshotId);
        return this;
    }

    public ManageSnapshots replaceBranch(String name, String source) {
        this.updateSnapshotReferencesOperation().replaceBranch(name, source);
        return this;
    }

    public ManageSnapshots fastForwardBranch(String name, String source) {
        this.updateSnapshotReferencesOperation().fastForward(name, source);
        return this;
    }

    public ManageSnapshots renameBranch(String name, String newName) {
        this.updateSnapshotReferencesOperation().renameBranch(name, newName);
        return this;
    }

    private UpdateSnapshotReferencesOperation updateSnapshotReferencesOperation() {
        if (this.updateSnapshotReferencesOperation == null) {
            this.updateSnapshotReferencesOperation = this.transaction.updateSnapshotReferencesOperation();
        }
        return this.updateSnapshotReferencesOperation;
    }

    private void commitIfRefUpdatesExist() {
        if (this.updateSnapshotReferencesOperation != null) {
            this.updateSnapshotReferencesOperation.commit();
            this.updateSnapshotReferencesOperation = null;
        }
    }

    public Snapshot apply() {
        return this.transaction.table().currentSnapshot();
    }

    public void commit() {
        this.commitIfRefUpdatesExist();
        if (!this.isExternalTransaction) {
            this.transaction.commitTransaction();
        }
    }
}

