/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.client.cli;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import java.util.List;
import org.apache.inlong.manager.client.api.InlongGroup;
import org.apache.inlong.manager.client.api.InlongGroupContext;
import org.apache.inlong.manager.client.api.impl.InlongClientImpl;
import org.apache.inlong.manager.client.api.inner.client.InlongClusterClient;
import org.apache.inlong.manager.client.api.inner.client.UserClient;
import org.apache.inlong.manager.client.cli.AbstractCommand;
import org.apache.inlong.manager.client.cli.AbstractCommandRunner;
import org.apache.inlong.manager.client.cli.util.ClientUtils;
import org.apache.inlong.manager.common.enums.SimpleGroupStatus;

@Parameters(commandDescription="Delete resource by group id")
public class DeleteCommand
extends AbstractCommand {
    @Parameter
    private List<String> params;

    public DeleteCommand() {
        super("delete");
        this.jcommander.addCommand("group", (Object)new DeleteGroup());
        this.jcommander.addCommand("cluster", (Object)new DeleteCluster());
        this.jcommander.addCommand("cluster-tag", (Object)new DeleteClusterTag());
        this.jcommander.addCommand("cluster-node", (Object)new DeleteClusterNode());
        this.jcommander.addCommand("user", (Object)new DeleteUser());
    }

    @Parameters(commandDescription="Delete user by user id")
    private static class DeleteUser
    extends AbstractCommandRunner {
        @Parameter
        private List<String> params;
        @Parameter(names={"-id", "--id"}, required=true, description="user id")
        private int userId;

        private DeleteUser() {
        }

        @Override
        void run() {
            try {
                ClientUtils.initClientFactory();
                UserClient userClient = ClientUtils.clientFactory.getUserClient();
                if (userClient.delete(Integer.valueOf(this.userId)).booleanValue()) {
                    System.out.println("Delete user success!");
                }
            }
            catch (Exception e) {
                System.out.println(e.getMessage());
            }
        }
    }

    @Parameters(commandDescription="Delete cluster node by node id")
    private static class DeleteClusterNode
    extends AbstractCommandRunner {
        @Parameter
        private List<String> params;
        @Parameter(names={"-id", "--id"}, required=true, description="cluster node id")
        private int nodeId;

        private DeleteClusterNode() {
        }

        @Override
        void run() {
            try {
                ClientUtils.initClientFactory();
                InlongClusterClient clusterClient = ClientUtils.clientFactory.getClusterClient();
                if (clusterClient.deleteNode(Integer.valueOf(this.nodeId)).booleanValue()) {
                    System.out.println("Delete cluster node success!");
                }
            }
            catch (Exception e) {
                System.out.println(e.getMessage());
            }
        }
    }

    @Parameters(commandDescription="Delete cluster tag by tag id")
    private static class DeleteClusterTag
    extends AbstractCommandRunner {
        @Parameter
        private List<String> params;
        @Parameter(names={"-id", "--id"}, required=true, description="cluster tag id")
        private int tagId;

        private DeleteClusterTag() {
        }

        @Override
        void run() {
            try {
                ClientUtils.initClientFactory();
                InlongClusterClient clusterClient = ClientUtils.clientFactory.getClusterClient();
                if (clusterClient.deleteTag(Integer.valueOf(this.tagId)).booleanValue()) {
                    System.out.println("Delete cluster tag success!");
                }
            }
            catch (Exception e) {
                System.out.println(e.getMessage());
            }
        }
    }

    @Parameters(commandDescription="Delete cluster by cluster id")
    private static class DeleteCluster
    extends AbstractCommandRunner {
        @Parameter
        private List<String> params;
        @Parameter(names={"-id", "--id"}, required=true, description="cluster id")
        private int clusterId;

        private DeleteCluster() {
        }

        @Override
        void run() {
            try {
                ClientUtils.initClientFactory();
                InlongClusterClient clusterClient = ClientUtils.clientFactory.getClusterClient();
                if (clusterClient.delete(Integer.valueOf(this.clusterId)).booleanValue()) {
                    System.out.println("Delete cluster success!");
                }
            }
            catch (Exception e) {
                System.out.println(e.getMessage());
            }
        }
    }

    @Parameters(commandDescription="Delete group by group id")
    private static class DeleteGroup
    extends AbstractCommandRunner {
        @Parameter
        private List<String> params;
        @Parameter(names={"--group", "-g"}, required=true, description="inlong group id")
        private String inlongGroupId;

        private DeleteGroup() {
        }

        @Override
        void run() {
            try {
                InlongClientImpl inlongClient = ClientUtils.getClient();
                InlongGroup group = inlongClient.getGroup(this.inlongGroupId);
                InlongGroupContext context = group.delete();
                if (!SimpleGroupStatus.STOPPED.equals((Object)context.getStatus())) {
                    throw new Exception("Delete group failed, current status: " + context.getStatus());
                }
                System.out.println("Delete group success!");
            }
            catch (Exception e) {
                System.out.format("Delete group failed! message: %s \n", e.getMessage());
            }
        }
    }
}

