/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.client.cli.util;

import java.lang.reflect.Field;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.inlong.manager.client.cli.util.ParseStatus;
import org.apache.inlong.manager.common.enums.SimpleGroupStatus;
import org.apache.inlong.manager.common.enums.SimpleSourceStatus;
import org.apache.inlong.manager.common.util.JsonUtils;

public class PrintUtils {
    private static final String joint = "+";
    private static final String horizontal = "\u2014";
    private static final String vertical = "|";

    public static <T, K> void print(List<T> item, Class<K> clazz) {
        if (item.isEmpty()) {
            return;
        }
        List<K> list = PrintUtils.copyObject(item, clazz);
        int[] maxColumnWidth = PrintUtils.getColumnWidth(list);
        PrintUtils.printTable(list, maxColumnWidth);
    }

    public static <T> void printJson(T item) {
        try {
            System.out.println(JsonUtils.toPrettyJsonString(item));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static <K> void printTable(List<K> list, int[] columnWidth) {
        Field[] fields = list.get(0).getClass().getDeclaredFields();
        PrintUtils.printLine(columnWidth, fields.length);
        System.out.print(vertical);
        String format = "%s|";
        for (int i = 0; i < fields.length; ++i) {
            System.out.printf(format, StringUtils.center((String)fields[i].getName(), (int)columnWidth[i]));
        }
        System.out.println();
        PrintUtils.printLine(columnWidth, fields.length);
        list.forEach(item -> {
            for (int i = 0; i < fields.length; ++i) {
                fields[i].setAccessible(true);
                try {
                    System.out.print(vertical);
                    Object obj = fields[i].get(item);
                    if (obj != null) {
                        int charNum = PrintUtils.getSpecialCharNum(obj.toString());
                        if (fields[i].getType().equals(Date.class)) {
                            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                            String date = dateFormat.format(obj);
                            System.out.printf("%s", StringUtils.center((String)date, (int)columnWidth[i]));
                            continue;
                        }
                        if (charNum > 0) {
                            System.out.printf("%s", StringUtils.center((String)obj.toString(), (int)(columnWidth[i] - charNum)));
                            continue;
                        }
                        System.out.printf("%s", StringUtils.center((String)obj.toString(), (int)columnWidth[i]));
                        continue;
                    }
                    System.out.printf("%s", StringUtils.center((String)"NULL", (int)columnWidth[i]));
                    continue;
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
            }
            System.out.println(vertical);
        });
        PrintUtils.printLine(columnWidth, fields.length);
    }

    private static <T, K> List<K> copyObject(List<T> list, Class<K> clazz) {
        ArrayList newList = new ArrayList();
        list.forEach(item -> {
            try {
                Object value = JsonUtils.parseObject((String)JsonUtils.toJsonString((Object)item), (Class)clazz);
                assert (value != null);
                PrintUtils.parseStatus(value);
                newList.add(value);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        });
        return newList;
    }

    private static <K> int[] getColumnWidth(List<K> list) {
        int i;
        Field[] fields = list.get(0).getClass().getDeclaredFields();
        int[] maxWidth = new int[fields.length];
        for (i = 0; i < fields.length; ++i) {
            maxWidth[i] = Math.max(fields[i].getName().length(), maxWidth[i]);
        }
        list.forEach(item -> {
            try {
                for (int i = 0; i < fields.length; ++i) {
                    fields[i].setAccessible(true);
                    if (fields[i].get(item) == null) continue;
                    int length = fields[i].get(item).toString().getBytes().length;
                    maxWidth[i] = Math.max(length, maxWidth[i]);
                }
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        });
        i = 0;
        while (i < maxWidth.length) {
            int n = i++;
            maxWidth[n] = maxWidth[n] + 4;
        }
        return maxWidth;
    }

    private static void printLine(int[] columnWidth, int fieldNum) {
        System.out.print(joint);
        for (int i = 0; i < fieldNum; ++i) {
            System.out.printf("%s", StringUtils.leftPad((String)joint, (int)(columnWidth[i] + 1), (String)horizontal));
        }
        System.out.println();
    }

    private static int getSpecialCharNum(String str) {
        int i = str.getBytes().length - str.length();
        return i / 2;
    }

    private static <T> void parseStatus(T target) {
        Field[] fields;
        for (Field field : fields = target.getClass().getDeclaredFields()) {
            field.setAccessible(true);
            if (!field.isAnnotationPresent(ParseStatus.class)) continue;
            try {
                int code = Integer.parseInt(field.get(target).toString());
                String name = "";
                Class<?> clazz = field.getAnnotation(ParseStatus.class).clazz();
                if (SimpleGroupStatus.class.equals(clazz)) {
                    name = SimpleGroupStatus.parseStatusByCode((int)code).toString();
                } else if (SimpleSourceStatus.class.equals(clazz)) {
                    name = SimpleSourceStatus.parseByStatus((int)code).toString();
                }
                field.set(target, String.format("%s (%d)", name, code));
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

