/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql.type;

import java.util.Collections;
import java.util.List;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.sql.SqlCallBinding;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlOperatorBinding;
import org.apache.calcite.sql.SqlUtil;
import org.apache.calcite.sql.type.SameOperandTypeChecker;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.sql.type.SqlTypeUtil;
import org.apache.calcite.util.Static;
import org.apache.flink.calcite.shaded.com.google.common.collect.ImmutableList;

public class SameOperandTypeExceptLastOperandChecker
extends SameOperandTypeChecker {
    protected final String lastOperandTypeName;

    public SameOperandTypeExceptLastOperandChecker(int nOperands, String lastOperandTypeName) {
        super(nOperands);
        this.lastOperandTypeName = lastOperandTypeName;
    }

    @Override
    protected boolean checkOperandTypesImpl(SqlOperatorBinding operatorBinding, boolean throwOnFailure, SqlCallBinding callBinding) {
        int nOperandsActual = this.nOperands;
        if (nOperandsActual == -1) {
            nOperandsActual = operatorBinding.getOperandCount();
        }
        assert (!throwOnFailure || callBinding != null);
        RelDataType[] types = new RelDataType[nOperandsActual];
        List<Integer> operandList = this.getOperandList(operatorBinding.getOperandCount());
        for (int i : operandList) {
            if (operatorBinding.isOperandNull(i, false)) {
                if (callBinding.isTypeCoercionEnabled()) {
                    types[i] = operatorBinding.getTypeFactory().createSqlType(SqlTypeName.NULL);
                    continue;
                }
                if (throwOnFailure) {
                    throw callBinding.getValidator().newValidationError(callBinding.operand(i), Static.RESOURCE.nullIllegal());
                }
                return false;
            }
            types[i] = operatorBinding.getOperandType(i);
        }
        int prev = -1;
        for (int i : operandList) {
            if (prev >= 0 && i != operandList.get(operandList.size() - 1) && !SqlTypeUtil.isComparable(types[i], types[prev])) {
                if (!throwOnFailure) {
                    return false;
                }
                throw callBinding.newValidationError(Static.RESOURCE.needSameTypeParameter());
            }
            prev = i;
        }
        return true;
    }

    @Override
    public String getAllowedSignatures(SqlOperator op, String opName) {
        String typeName = this.getTypeName();
        if (this.nOperands == -1) {
            return SqlUtil.getAliasedSignature(op, opName, ImmutableList.of(typeName, typeName, "..."));
        }
        List<String> types = Collections.nCopies(this.nOperands - 1, typeName);
        types.add(this.lastOperandTypeName);
        return SqlUtil.getAliasedSignature(op, opName, types);
    }
}

