/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.delegation;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.calcite.plan.ConventionTraitDef;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.plan.RelTraitDef;
import org.apache.calcite.rel.RelCollationTraitDef;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.sql.SqlExplainLevel;
import org.apache.flink.api.common.RuntimeExecutionMode;
import org.apache.flink.api.dag.Transformation;
import org.apache.flink.configuration.ExecutionOptions;
import org.apache.flink.streaming.api.graph.StreamGraph;
import org.apache.flink.table.api.ExplainDetail;
import org.apache.flink.table.api.PlanReference;
import org.apache.flink.table.api.TableConfig;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.api.config.OptimizerConfigOptions;
import org.apache.flink.table.catalog.CatalogManager;
import org.apache.flink.table.catalog.FunctionCatalog;
import org.apache.flink.table.delegation.Executor;
import org.apache.flink.table.delegation.InternalPlan;
import org.apache.flink.table.module.ModuleManager;
import org.apache.flink.table.operations.ModifyOperation;
import org.apache.flink.table.operations.Operation;
import org.apache.flink.table.planner.delegation.DefaultExecutor;
import org.apache.flink.table.planner.delegation.PlannerBase;
import org.apache.flink.table.planner.plan.nodes.exec.ExecNode;
import org.apache.flink.table.planner.plan.nodes.exec.ExecNodeGraph;
import org.apache.flink.table.planner.plan.nodes.exec.batch.BatchExecNode;
import org.apache.flink.table.planner.plan.nodes.exec.processor.DeadlockBreakupProcessor;
import org.apache.flink.table.planner.plan.nodes.exec.processor.ExecNodeGraphProcessor;
import org.apache.flink.table.planner.plan.nodes.exec.processor.ForwardHashExchangeProcessor;
import org.apache.flink.table.planner.plan.nodes.exec.processor.MultipleInputNodeCreationProcessor;
import org.apache.flink.table.planner.plan.nodes.exec.utils.ExecNodePlanDumper;
import org.apache.flink.table.planner.plan.optimize.BatchCommonSubGraphBasedOptimizer;
import org.apache.flink.table.planner.plan.optimize.Optimizer;
import org.apache.flink.table.planner.plan.trait.FlinkRelDistributionTraitDef$;
import org.apache.flink.table.planner.plan.utils.FlinkRelOptUtil$;
import org.apache.flink.table.planner.utils.DummyStreamExecutionEnvironment;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple4;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005]g\u0001B\u0001\u0003\u0001=\u0011ABQ1uG\"\u0004F.\u00198oKJT!a\u0001\u0003\u0002\u0015\u0011,G.Z4bi&|gN\u0003\u0002\u0006\r\u00059\u0001\u000f\\1o]\u0016\u0014(BA\u0004\t\u0003\u0015!\u0018M\u00197f\u0015\tI!\"A\u0003gY&t7N\u0003\u0002\f\u0019\u00051\u0011\r]1dQ\u0016T\u0011!D\u0001\u0004_J<7\u0001A\n\u0003\u0001A\u0001\"!\u0005\n\u000e\u0003\tI!a\u0005\u0002\u0003\u0017Ac\u0017M\u001c8fe\n\u000b7/\u001a\u0005\t+\u0001\u0011\t\u0011)A\u0005-\u0005AQ\r_3dkR|'\u000f\u0005\u0002\u001835\t\u0001D\u0003\u0002\u0004\r%\u0011!\u0004\u0007\u0002\t\u000bb,7-\u001e;pe\"AA\u0004\u0001B\u0001B\u0003%Q$A\u0006uC\ndWmQ8oM&<\u0007C\u0001\u0010\"\u001b\u0005y\"B\u0001\u0011\u0007\u0003\r\t\u0007/[\u0005\u0003E}\u00111\u0002V1cY\u0016\u001cuN\u001c4jO\"IA\u0005\u0001B\u0001B\u0003%QeK\u0001\u000e[>$W\u000f\\3NC:\fw-\u001a:\u0011\u0005\u0019JS\"A\u0014\u000b\u0005!2\u0011AB7pIVdW-\u0003\u0002+O\tiQj\u001c3vY\u0016l\u0015M\\1hKJL!\u0001\n\n\t\u00135\u0002!\u0011!Q\u0001\n9\"\u0014a\u00044v]\u000e$\u0018n\u001c8DCR\fGn\\4\u0011\u0005=\u0012T\"\u0001\u0019\u000b\u0005E2\u0011aB2bi\u0006dwnZ\u0005\u0003gA\u0012qBR;oGRLwN\\\"bi\u0006dwnZ\u0005\u0003[IA\u0011B\u000e\u0001\u0003\u0002\u0003\u0006Ia\u000e\u001e\u0002\u001d\r\fG/\u00197pO6\u000bg.Y4feB\u0011q\u0006O\u0005\u0003sA\u0012abQ1uC2|w-T1oC\u001e,'/\u0003\u00027%!)A\b\u0001C\u0001{\u00051A(\u001b8jiz\"bAP A\u0003\n\u001b\u0005CA\t\u0001\u0011\u0015)2\b1\u0001\u0017\u0011\u0015a2\b1\u0001\u001e\u0011\u0015!3\b1\u0001&\u0011\u0015i3\b1\u0001/\u0011\u001514\b1\u00018\u0011\u0015)\u0005\u0001\"\u0015G\u000319W\r\u001e+sC&$H)\u001a4t+\u00059\u0005c\u0001%L\u001b6\t\u0011JC\u0001K\u0003\u0015\u00198-\u00197b\u0013\ta\u0015JA\u0003BeJ\f\u0017\u0010\r\u0002O1B\u0019q\n\u0016,\u000e\u0003AS!!\u0015*\u0002\tAd\u0017M\u001c\u0006\u0003'*\tqaY1mG&$X-\u0003\u0002V!\nY!+\u001a7Ue\u0006LG\u000fR3g!\t9\u0006\f\u0004\u0001\u0005\u0013e#\u0015\u0011!A\u0001\u0006\u0003Q&aA0%cE\u00111L\u0018\t\u0003\u0011rK!!X%\u0003\u000f9{G\u000f[5oOB\u0011qjX\u0005\u0003AB\u0013\u0001BU3m)J\f\u0017\u000e\u001e\u0005\u0006E\u0002!\tfY\u0001\rO\u0016$x\n\u001d;j[&TXM]\u000b\u0002IB\u0011Q-[\u0007\u0002M*\u0011q\r[\u0001\t_B$\u0018.\\5{K*\u0011\u0011\u000bB\u0005\u0003U\u001a\u0014\u0011b\u00149uS6L'0\u001a:\t\u000b1\u0004A\u0011K7\u00025\u001d,G/\u0012=fG:{G-Z$sCBD\u0007K]8dKN\u001cxN]:\u0016\u00039\u00042a\\<{\u001d\t\u0001XO\u0004\u0002ri6\t!O\u0003\u0002t\u001d\u00051AH]8pizJ\u0011AS\u0005\u0003m&\u000bq\u0001]1dW\u0006<W-\u0003\u0002ys\n\u00191+Z9\u000b\u0005YL\u0005cA>\u0002\u00065\tAP\u0003\u0002~}\u0006I\u0001O]8dKN\u001cxN\u001d\u0006\u0004\u007f\u0006\u0005\u0011\u0001B3yK\u000eT1!a\u0001i\u0003\u0015qw\u000eZ3t\u0013\r\t9\u0001 \u0002\u0017\u000bb,7MT8eK\u001e\u0013\u0018\r\u001d5Qe>\u001cWm]:pe\"9\u00111\u0002\u0001\u0005R\u00055\u0011a\u0004;sC:\u001cH.\u0019;f)>\u0004F.\u00198\u0015\t\u0005=\u0011Q\b\t\u0007\u0003#\tY\"a\b\u000e\u0005\u0005M!\u0002BA\u000b\u0003/\tA!\u001e;jY*\u0011\u0011\u0011D\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002\u001e\u0005M!\u0001\u0002'jgR\u0004D!!\t\u00022A1\u00111EA\u0016\u0003_i!!!\n\u000b\t\u0005\u001d\u0012\u0011F\u0001\u0004I\u0006<'B\u0001\u0011\t\u0013\u0011\ti#!\n\u0003\u001dQ\u0013\u0018M\\:g_Jl\u0017\r^5p]B\u0019q+!\r\u0005\u0019\u0005M\u0012\u0011BA\u0001\u0002\u0003\u0015\t!!\u000e\u0003\u0007}##'E\u0002\\\u0003o\u00012\u0001SA\u001d\u0013\r\tY$\u0013\u0002\u0004\u0003:L\b\u0002CA \u0003\u0013\u0001\r!!\u0011\u0002\u0013\u0015DXmY$sCBD\u0007\u0003BA\"\u0003\u000bj\u0011A`\u0005\u0004\u0003\u000fr(!D#yK\u000etu\u000eZ3He\u0006\u0004\b\u000eC\u0004\u0002L\u0001!\t%!\u0014\u0002\u000f\u0015D\b\u000f\\1j]R1\u0011qJA0\u0003_\u0002B!!\u0015\u0002Z9!\u00111KA+!\t\t\u0018*C\u0002\u0002X%\u000ba\u0001\u0015:fI\u00164\u0017\u0002BA.\u0003;\u0012aa\u0015;sS:<'bAA,\u0013\"A\u0011\u0011MA%\u0001\u0004\t\u0019'\u0001\u0006pa\u0016\u0014\u0018\r^5p]N\u0004b!!\u0005\u0002\u001c\u0005\u0015\u0004\u0003BA4\u0003Wj!!!\u001b\u000b\u0007\u0005\u0005d!\u0003\u0003\u0002n\u0005%$!C(qKJ\fG/[8o\u0011!\t\t(!\u0013A\u0002\u0005M\u0014\u0001D3yiJ\fG)\u001a;bS2\u001c\b#\u0002%\u0002v\u0005e\u0014bAA<\u0013\nQAH]3qK\u0006$X\r\u001a \u0011\u0007y\tY(C\u0002\u0002~}\u0011Q\"\u0012=qY\u0006Lg\u000eR3uC&d\u0007bBAA\u0001\u0011%\u00111Q\u0001\u0013GJ,\u0017\r^3Ek6l\u0017\u0010\u00157b]:,'\u000fF\u0001?\u0011\u001d\t9\t\u0001C!\u0003\u0013\u000b\u0001\u0002\\8bIBc\u0017M\u001c\u000b\u0005\u0003\u0017\u000b\t\nE\u0002\u0018\u0003\u001bK1!a$\u0019\u00051Ie\u000e^3s]\u0006d\u0007\u000b\\1o\u0011!\t\u0019*!\"A\u0002\u0005U\u0015!\u00049mC:\u0014VMZ3sK:\u001cW\rE\u0002\u001f\u0003/K1!!' \u00055\u0001F.\u00198SK\u001a,'/\u001a8dK\"9\u0011Q\u0014\u0001\u0005B\u0005}\u0015aC2p[BLG.\u001a)mC:$B!a#\u0002\"\"A\u00111UAN\u0001\u0004\t)+\u0001\tn_\u0012Lg-_(qKJ\fG/[8ogB1\u0011\u0011CA\u000e\u0003O\u0003B!a\u001a\u0002*&!\u00111VA5\u0005=iu\u000eZ5gs>\u0003XM]1uS>t\u0007bBAX\u0001\u0011\u0005\u0013\u0011W\u0001\u000eiJ\fgn\u001d7bi\u0016\u0004F.\u00198\u0015\t\u0005M\u0016q\u0018\t\u0007\u0003#\tY\"!.1\t\u0005]\u00161\u0018\t\u0007\u0003G\tY#!/\u0011\u0007]\u000bY\f\u0002\u0007\u0002>\u00065\u0016\u0011!A\u0001\u0006\u0003\t)DA\u0002`IMBq!UAW\u0001\u0004\tY\tC\u0004\u0002D\u0002!\t%!2\u0002\u0017\u0015D\b\u000f\\1j]Bc\u0017M\u001c\u000b\u0007\u0003\u001f\n9-!3\t\u000fE\u000b\t\r1\u0001\u0002\f\"A\u0011\u0011OAa\u0001\u0004\t\u0019\bC\u0004\u0002N\u0002!\t%a4\u0002#\t,gm\u001c:f)J\fgn\u001d7bi&|g\u000e\u0006\u0002\u0002RB\u0019\u0001*a5\n\u0007\u0005U\u0017J\u0001\u0003V]&$\b")
public class BatchPlanner
extends PlannerBase {
    private final TableConfig tableConfig;

    @Override
    public RelTraitDef<? extends RelTrait>[] getTraitDefs() {
        return (RelTraitDef[])((Object[])new RelTraitDef[]{ConventionTraitDef.INSTANCE, FlinkRelDistributionTraitDef$.MODULE$.INSTANCE(), RelCollationTraitDef.INSTANCE});
    }

    @Override
    public Optimizer getOptimizer() {
        return new BatchCommonSubGraphBasedOptimizer(this);
    }

    @Override
    public Seq<ExecNodeGraphProcessor> getExecNodeGraphProcessors() {
        ArrayList<ExecNodeGraphProcessor> processors = new ArrayList<ExecNodeGraphProcessor>();
        processors.add(new DeadlockBreakupProcessor());
        Object object = Predef$.MODULE$.Boolean2boolean((Boolean)this.getTableConfig().get(OptimizerConfigOptions.TABLE_OPTIMIZER_MULTIPLE_INPUT_ENABLED)) ? BoxesRunTime.boxToBoolean((boolean)processors.add(new MultipleInputNodeCreationProcessor(false))) : BoxedUnit.UNIT;
        processors.add(new ForwardHashExchangeProcessor());
        return JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(processors);
    }

    @Override
    public List<Transformation<?>> translateToPlan(ExecNodeGraph execGraph) {
        this.beforeTranslation();
        BatchPlanner planner = this.createDummyPlanner();
        Buffer transformations = (Buffer)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(execGraph.getRootNodes()).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            ExecNode execNode = x0$1;
            if (!(execNode instanceof BatchExecNode)) {
                throw new TableException("Cannot generate BoundedStream due to an invalid logical plan. This is a bug and should not happen. Please file an issue.");
            }
            BatchExecNode batchExecNode = (BatchExecNode)execNode;
            Transformation transformation = batchExecNode.translateToPlan(planner);
            return transformation;
        }, Buffer$.MODULE$.canBuildFrom());
        this.afterTranslation();
        return JavaConversions$.MODULE$.deprecated$u0020bufferAsJavaList(transformations);
    }

    public String explain(List<Operation> operations, Seq<ExplainDetail> extraDetails) {
        BoxedUnit boxedUnit;
        Tuple4<Buffer<RelNode>, Seq<RelNode>, ExecNodeGraph, StreamGraph> tuple4 = this.getExplainGraphs(operations);
        if (tuple4 == null) {
            throw new MatchError(tuple4);
        }
        Buffer sinkRelNodes = (Buffer)tuple4._1();
        Seq optimizedRelNodes = (Seq)tuple4._2();
        ExecNodeGraph execGraph = (ExecNodeGraph)tuple4._3();
        StreamGraph streamGraph = (StreamGraph)tuple4._4();
        Tuple4 tuple42 = new Tuple4((Object)sinkRelNodes, (Object)optimizedRelNodes, (Object)execGraph, (Object)streamGraph);
        Tuple4 tuple43 = tuple42;
        Buffer sinkRelNodes2 = (Buffer)tuple43._1();
        Seq optimizedRelNodes2 = (Seq)tuple43._2();
        ExecNodeGraph execGraph2 = (ExecNodeGraph)tuple43._3();
        StreamGraph streamGraph2 = (StreamGraph)tuple43._4();
        StringBuilder sb = new StringBuilder();
        sb.append("== Abstract Syntax Tree ==");
        sb.append(System.lineSeparator());
        sinkRelNodes2.foreach((Function1 & Serializable & scala.Serializable)sink -> {
            sb.append(FlinkRelOptUtil$.MODULE$.toString((RelNode)sink, SqlExplainLevel.EXPPLAN_ATTRIBUTES, FlinkRelOptUtil$.MODULE$.toString$default$3(), FlinkRelOptUtil$.MODULE$.toString$default$4(), FlinkRelOptUtil$.MODULE$.toString$default$5()));
            return sb.append(System.lineSeparator());
        });
        sb.append("== Optimized Physical Plan ==");
        sb.append(System.lineSeparator());
        SqlExplainLevel explainLevel = extraDetails.contains((Object)ExplainDetail.ESTIMATED_COST) ? SqlExplainLevel.ALL_ATTRIBUTES : SqlExplainLevel.EXPPLAN_ATTRIBUTES;
        optimizedRelNodes2.foreach((Function1 & Serializable & scala.Serializable)rel -> {
            sb.append(FlinkRelOptUtil$.MODULE$.toString((RelNode)rel, explainLevel, FlinkRelOptUtil$.MODULE$.toString$default$3(), FlinkRelOptUtil$.MODULE$.toString$default$4(), FlinkRelOptUtil$.MODULE$.toString$default$5()));
            return sb.append(System.lineSeparator());
        });
        sb.append("== Optimized Execution Plan ==");
        sb.append(System.lineSeparator());
        sb.append(ExecNodePlanDumper.dagToString(execGraph2));
        if (extraDetails.contains((Object)ExplainDetail.JSON_EXECUTION_PLAN)) {
            sb.append(System.lineSeparator());
            sb.append("== Physical Execution Plan ==");
            sb.append(System.lineSeparator());
            boxedUnit = sb.append(streamGraph2.getStreamingPlanAsJSON());
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return sb.toString();
    }

    private BatchPlanner createDummyPlanner() {
        DummyStreamExecutionEnvironment dummyExecEnv = new DummyStreamExecutionEnvironment(this.getExecEnv());
        DefaultExecutor executor = new DefaultExecutor(dummyExecEnv);
        return new BatchPlanner(executor, this.tableConfig, super.moduleManager(), super.functionCatalog(), super.catalogManager());
    }

    public InternalPlan loadPlan(PlanReference planReference) {
        throw new UnsupportedOperationException("The compiled plan feature is not supported in batch mode.");
    }

    public InternalPlan compilePlan(List<ModifyOperation> modifyOperations) {
        throw new UnsupportedOperationException("The compiled plan feature is not supported in batch mode.");
    }

    public List<Transformation<?>> translatePlan(InternalPlan plan) {
        throw new UnsupportedOperationException("The compiled plan feature is not supported in batch mode.");
    }

    public String explainPlan(InternalPlan plan, Seq<ExplainDetail> extraDetails) {
        throw new UnsupportedOperationException("The compiled plan feature is not supported in batch mode.");
    }

    @Override
    public void beforeTranslation() {
        RuntimeExecutionMode runtimeMode;
        super.beforeTranslation();
        RuntimeExecutionMode runtimeExecutionMode = runtimeMode = (RuntimeExecutionMode)this.getTableConfig().get(ExecutionOptions.RUNTIME_MODE);
        RuntimeExecutionMode runtimeExecutionMode2 = RuntimeExecutionMode.BATCH;
        if (runtimeExecutionMode == null ? runtimeExecutionMode2 != null : !runtimeExecutionMode.equals(runtimeExecutionMode2)) {
            throw new IllegalArgumentException("Mismatch between configured runtime mode and actual runtime mode. Currently, the 'execution.runtime-mode' can only be set when instantiating the table environment. Subsequent changes are not supported. Please instantiate a new TableEnvironment if necessary.");
        }
    }

    public String explainPlan(InternalPlan plan, ExplainDetail[] extraDetails) {
        return this.explainPlan(plan, (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])extraDetails));
    }

    public String explain(List<Operation> operations, ExplainDetail[] extraDetails) {
        return this.explain(operations, (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])extraDetails));
    }

    public BatchPlanner(Executor executor, TableConfig tableConfig, ModuleManager moduleManager, FunctionCatalog functionCatalog, CatalogManager catalogManager) {
        this.tableConfig = tableConfig;
        super(executor, tableConfig, moduleManager, functionCatalog, catalogManager, false);
    }
}

