/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.expressions.converter.converters;

import java.util.List;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.expressions.CallExpression;
import org.apache.flink.table.planner.calcite.FlinkTypeFactory;
import org.apache.flink.table.planner.expressions.converter.CallExpressionConvertRule;
import org.apache.flink.table.planner.expressions.converter.ExpressionConverter;
import org.apache.flink.table.planner.expressions.converter.converters.CustomizedConverter;
import org.apache.flink.table.planner.functions.sql.FlinkSqlOperatorTable;
import org.apache.flink.table.runtime.typeutils.TypeCheckUtils;
import org.apache.flink.table.types.logical.LogicalType;

@Internal
class PlusConverter
extends CustomizedConverter {
    PlusConverter() {
    }

    @Override
    public RexNode convert(CallExpression call, CallExpressionConvertRule.ConvertContext context) {
        PlusConverter.checkArgumentNumber(call, 2);
        List<RexNode> childrenRexNode = ExpressionConverter.toRexNodes(context, call.getChildren());
        if (TypeCheckUtils.isCharacterString((LogicalType)FlinkTypeFactory.toLogicalType(childrenRexNode.get(0).getType()))) {
            return context.getRelBuilder().call(FlinkSqlOperatorTable.CONCAT, childrenRexNode.get(0), context.getRelBuilder().cast(childrenRexNode.get(1), SqlTypeName.VARCHAR));
        }
        if (TypeCheckUtils.isCharacterString((LogicalType)FlinkTypeFactory.toLogicalType(childrenRexNode.get(1).getType()))) {
            return context.getRelBuilder().call(FlinkSqlOperatorTable.CONCAT, context.getRelBuilder().cast(childrenRexNode.get(0), SqlTypeName.VARCHAR), childrenRexNode.get(1));
        }
        if (TypeCheckUtils.isTimeInterval((LogicalType)FlinkTypeFactory.toLogicalType(childrenRexNode.get(0).getType())) && childrenRexNode.get(0).getType() == childrenRexNode.get(1).getType()) {
            return context.getRelBuilder().call(FlinkSqlOperatorTable.PLUS, (Iterable<? extends RexNode>)childrenRexNode);
        }
        if (TypeCheckUtils.isTimeInterval((LogicalType)FlinkTypeFactory.toLogicalType(childrenRexNode.get(0).getType())) && TypeCheckUtils.isTemporal((LogicalType)FlinkTypeFactory.toLogicalType(childrenRexNode.get(1).getType()))) {
            return context.getRelBuilder().call(FlinkSqlOperatorTable.DATETIME_PLUS, childrenRexNode.get(1), childrenRexNode.get(0));
        }
        if (TypeCheckUtils.isTemporal((LogicalType)FlinkTypeFactory.toLogicalType(childrenRexNode.get(0).getType())) && TypeCheckUtils.isTemporal((LogicalType)FlinkTypeFactory.toLogicalType(childrenRexNode.get(1).getType()))) {
            return context.getRelBuilder().call(FlinkSqlOperatorTable.DATETIME_PLUS, (Iterable<? extends RexNode>)childrenRexNode);
        }
        return context.getRelBuilder().call(FlinkSqlOperatorTable.PLUS, (Iterable<? extends RexNode>)childrenRexNode);
    }
}

