/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.functions.casting;

import org.apache.flink.table.data.StringData;
import org.apache.flink.table.planner.codegen.calls.BuiltInMethods;
import org.apache.flink.table.planner.functions.casting.AbstractExpressionCodeGeneratorCastRule;
import org.apache.flink.table.planner.functions.casting.CastRulePredicate;
import org.apache.flink.table.planner.functions.casting.CastRuleUtils;
import org.apache.flink.table.planner.functions.casting.CodeGeneratorCastRule;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.LogicalTypeFamily;
import org.apache.flink.table.types.logical.LogicalTypeRoot;

class StringToDateCastRule
extends AbstractExpressionCodeGeneratorCastRule<StringData, Integer> {
    static final StringToDateCastRule INSTANCE = new StringToDateCastRule();

    private StringToDateCastRule() {
        super(CastRulePredicate.builder().input(LogicalTypeFamily.CHARACTER_STRING).target(LogicalTypeRoot.DATE).build());
    }

    @Override
    public String generateExpression(CodeGeneratorCastRule.Context context, String inputTerm, LogicalType inputLogicalType, LogicalType targetLogicalType) {
        return CastRuleUtils.staticCall(BuiltInMethods.STRING_DATA_TO_DATE(), inputTerm);
    }

    @Override
    public boolean canFail(LogicalType inputLogicalType, LogicalType targetLogicalType) {
        return true;
    }
}

