/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.nodes.exec.common;

import java.util.List;
import org.apache.calcite.rex.RexNode;
import org.apache.flink.api.dag.Transformation;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.planner.codegen.CodeGeneratorContext;
import org.apache.flink.table.planner.codegen.ExpandCodeGenerator;
import org.apache.flink.table.planner.delegation.PlannerBase;
import org.apache.flink.table.planner.plan.nodes.exec.ExecEdge;
import org.apache.flink.table.planner.plan.nodes.exec.ExecNodeBase;
import org.apache.flink.table.planner.plan.nodes.exec.ExecNodeConfig;
import org.apache.flink.table.planner.plan.nodes.exec.ExecNodeContext;
import org.apache.flink.table.planner.plan.nodes.exec.InputProperty;
import org.apache.flink.table.planner.plan.nodes.exec.SingleTransformationTranslator;
import org.apache.flink.table.planner.plan.nodes.exec.utils.ExecNodeUtil;
import org.apache.flink.table.runtime.operators.CodeGenOperatorFactory;
import org.apache.flink.table.runtime.typeutils.InternalTypeInfo;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.util.Preconditions;

public abstract class CommonExecExpand
extends ExecNodeBase<RowData>
implements SingleTransformationTranslator<RowData> {
    public static final String EXPAND_TRANSFORMATION = "expand";
    public static final String FIELD_NAME_PROJECTS = "projects";
    @JsonProperty(value="projects")
    private final List<List<RexNode>> projects;
    private final boolean retainHeader;

    public CommonExecExpand(int id, ExecNodeContext context, ReadableConfig persistedConfig, List<List<RexNode>> projects, boolean retainHeader, List<InputProperty> inputProperties, RowType outputType, String description) {
        super(id, context, persistedConfig, inputProperties, (LogicalType)outputType, description);
        Preconditions.checkArgument((inputProperties.size() == 1 ? 1 : 0) != 0);
        this.projects = (List)Preconditions.checkNotNull(projects);
        Preconditions.checkArgument((projects.size() > 0 && projects.get(0).size() > 0 && projects.stream().map(List::size).distinct().count() == 1L ? 1 : 0) != 0);
        this.retainHeader = retainHeader;
    }

    @Override
    protected Transformation<RowData> translateToPlanInternal(PlannerBase planner, ExecNodeConfig config) {
        ExecEdge inputEdge = this.getInputEdges().get(0);
        Transformation<?> inputTransform = inputEdge.translateToPlan(planner);
        CodeGenOperatorFactory<RowData> operatorFactory = ExpandCodeGenerator.generateExpandOperator(new CodeGeneratorContext(config.getTableConfig()), (RowType)inputEdge.getOutputType(), (RowType)this.getOutputType(), this.projects, this.retainHeader, this.getClass().getSimpleName());
        return ExecNodeUtil.createOneInputTransformation(inputTransform, this.createTransformationMeta(EXPAND_TRANSFORMATION, config), operatorFactory, InternalTypeInfo.of((LogicalType)this.getOutputType()), inputTransform.getParallelism());
    }
}

