/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.rules.logical;

import java.util.List;
import java.util.function.Predicate;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelRule;
import org.apache.calcite.rel.core.Calc;
import org.apache.calcite.rel.core.Filter;
import org.apache.calcite.rel.core.Join;
import org.apache.calcite.rel.core.Project;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexShuttle;
import org.apache.calcite.sql.SqlOperator;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.functions.BuiltInFunctionDefinitions;
import org.apache.flink.table.planner.functions.bridging.BridgingSqlFunction;
import org.apache.flink.table.planner.plan.utils.FlinkRexUtil;

@Internal
public class RemoveUnreachableCoalesceArgumentsRule
extends RelRule<Config> {
    public static final RelOptRule PROJECT_INSTANCE = Config.EMPTY.as(Config.class).withProject().toRule();
    public static final RelOptRule FILTER_INSTANCE = Config.EMPTY.as(Config.class).withFilter().toRule();
    public static final RelOptRule JOIN_INSTANCE = Config.EMPTY.as(Config.class).withJoin().toRule();
    public static final RelOptRule CALC_INSTANCE = Config.EMPTY.as(Config.class).withCalc().toRule();

    public RemoveUnreachableCoalesceArgumentsRule(Config config) {
        super(config);
    }

    @Override
    public void onMatch(RelOptRuleCall call) {
        Object relNode = call.rel(0);
        RexBuilder rexBuilder = relNode.getCluster().getRexBuilder();
        call.transformTo(relNode.accept(new UnreachableCoalesceArgumentsRemoveRexShuttle(rexBuilder)));
    }

    private static boolean hasCoalesceInvocation(RexNode node) {
        return FlinkRexUtil.hasOperatorCallMatching(node, RemoveUnreachableCoalesceArgumentsRule::operatorIsCoalesce);
    }

    private static boolean operatorIsCoalesce(SqlOperator op) {
        return op instanceof BridgingSqlFunction && ((BridgingSqlFunction)op).getDefinition().equals(BuiltInFunctionDefinitions.COALESCE);
    }

    public static interface Config
    extends RelRule.Config {
        @Override
        default public RelOptRule toRule() {
            return new RemoveUnreachableCoalesceArgumentsRule(this);
        }

        default public Config withProject() {
            Predicate<Project> projectPredicate = lp -> lp.getProjects().stream().anyMatch(x$0 -> RemoveUnreachableCoalesceArgumentsRule.hasCoalesceInvocation(x$0));
            RelRule.OperandTransform projectTransform = operandBuilder -> operandBuilder.operand(Project.class).predicate(projectPredicate).anyInputs();
            return this.withOperandSupplier(projectTransform).as(Config.class);
        }

        default public Config withFilter() {
            Predicate<Filter> filterPredicate = lf -> RemoveUnreachableCoalesceArgumentsRule.hasCoalesceInvocation(lf.getCondition());
            RelRule.OperandTransform filterTransform = operandBuilder -> operandBuilder.operand(Filter.class).predicate(filterPredicate).anyInputs();
            return this.withOperandSupplier(filterTransform).as(Config.class);
        }

        default public Config withJoin() {
            Predicate<Join> joinPredicate = lj -> RemoveUnreachableCoalesceArgumentsRule.hasCoalesceInvocation(lj.getCondition());
            RelRule.OperandTransform joinTransform = operandBuilder -> operandBuilder.operand(Join.class).predicate(joinPredicate).anyInputs();
            return this.withOperandSupplier(joinTransform).as(Config.class);
        }

        default public Config withCalc() {
            Predicate<Calc> calcPredicate = lc -> lc.getProgram().getExprList().stream().anyMatch(x$0 -> RemoveUnreachableCoalesceArgumentsRule.hasCoalesceInvocation(x$0));
            RelRule.OperandTransform joinTransform = operandBuilder -> operandBuilder.operand(Calc.class).predicate(calcPredicate).anyInputs();
            return this.withOperandSupplier(joinTransform).as(Config.class);
        }
    }

    private static class UnreachableCoalesceArgumentsRemoveRexShuttle
    extends RexShuttle {
        private final RexBuilder rexBuilder;

        private UnreachableCoalesceArgumentsRemoveRexShuttle(RexBuilder rexBuilder) {
            this.rexBuilder = rexBuilder;
        }

        @Override
        public RexNode visitCall(RexCall call) {
            if (!RemoveUnreachableCoalesceArgumentsRule.operatorIsCoalesce((call = (RexCall)super.visitCall(call)).getOperator())) {
                return call;
            }
            int firstNonNullableArgIndex = this.getFirstNonNullableArgumentIndex(call);
            if (firstNonNullableArgIndex == 0) {
                RexNode operand = (RexNode)call.operands.get(0);
                if (call.getType().equals(operand.getType())) {
                    return operand;
                }
                return this.rexBuilder.makeCast(call.getType(), operand);
            }
            if (firstNonNullableArgIndex == call.operands.size() - 1 || firstNonNullableArgIndex == -1) {
                return call;
            }
            List trimmedOperandsList = call.operands.subList(0, firstNonNullableArgIndex + 1);
            return call.clone(call.getType(), trimmedOperandsList);
        }

        private int getFirstNonNullableArgumentIndex(RexCall call) {
            for (int argIndex = 0; argIndex < call.operands.size(); ++argIndex) {
                if (((RexNode)call.operands.get(argIndex)).getType().isNullable()) continue;
                return argIndex;
            }
            return -1;
        }
    }
}

