/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.OAuthTokenProvider;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class RequestConfig {
    private String username;
    private String password;
    private String oauthToken;
    private OAuthTokenProvider oauthTokenProvider;
    private String impersonateUsername;
    private String[] impersonateGroups = new String[0];
    private Map<String, List<String>> impersonateExtras = new HashMap<String, List<String>>();
    private int watchReconnectInterval = 1000;
    private int watchReconnectLimit = -1;
    private int connectionTimeout = 10000;
    private int uploadConnectionTimeout = 10000;
    private int uploadRequestTimeout = 120000;
    private int requestRetryBackoffLimit = Config.DEFAULT_REQUEST_RETRY_BACKOFFLIMIT;
    private int requestRetryBackoffInterval = Config.DEFAULT_REQUEST_RETRY_BACKOFFINTERVAL;
    private int requestTimeout = 10000;
    private long rollingTimeout = Config.DEFAULT_ROLLING_TIMEOUT;
    private long scaleTimeout = Config.DEFAULT_SCALE_TIMEOUT;
    private int loggingInterval = 20000;
    private long websocketTimeout = Config.DEFAULT_WEBSOCKET_TIMEOUT;
    private long websocketPingInterval = Config.DEFAULT_WEBSOCKET_PING_INTERVAL;
    private int maxConcurrentRequests = Config.DEFAULT_MAX_CONCURRENT_REQUESTS;
    private int maxConcurrentRequestsPerHost = Config.DEFAULT_MAX_CONCURRENT_REQUESTS_PER_HOST;

    RequestConfig() {
    }

    @Deprecated
    public RequestConfig(String username, String password, String oauthToken, int watchReconnectLimit, int watchReconnectInterval, int connectionTimeout, long rollingTimeout, int requestTimeout, long scaleTimeout, int loggingInterval, long websocketTimeout, long websocketPingInterval, int maxConcurrentRequests, int maxConcurrentRequestsPerHost) {
        this(username, password, oauthToken, watchReconnectLimit, watchReconnectInterval, connectionTimeout, rollingTimeout, requestTimeout, scaleTimeout, loggingInterval, websocketTimeout, websocketPingInterval, maxConcurrentRequests, maxConcurrentRequestsPerHost, null, Config.DEFAULT_REQUEST_RETRY_BACKOFFLIMIT, Config.DEFAULT_REQUEST_RETRY_BACKOFFINTERVAL, 10000, 120000);
    }

    public RequestConfig(String username, String password, String oauthToken, int watchReconnectLimit, int watchReconnectInterval, int connectionTimeout, long rollingTimeout, int requestTimeout, long scaleTimeout, int loggingInterval, long websocketTimeout, long websocketPingInterval, int maxConcurrentRequests, int maxConcurrentRequestsPerHost, OAuthTokenProvider oauthTokenProvider, int requestRetryBackoffLimit, int requestRetryBackoffInterval, int uploadConnectionTimeout, int uploadRequestTimeout) {
        this.username = username;
        this.oauthToken = oauthToken;
        this.password = password;
        this.watchReconnectLimit = watchReconnectLimit;
        this.watchReconnectInterval = watchReconnectInterval;
        this.connectionTimeout = connectionTimeout;
        this.rollingTimeout = rollingTimeout;
        this.requestTimeout = requestTimeout;
        this.scaleTimeout = scaleTimeout;
        this.websocketTimeout = websocketTimeout;
        this.loggingInterval = loggingInterval;
        this.websocketPingInterval = websocketPingInterval;
        this.maxConcurrentRequests = maxConcurrentRequests;
        this.maxConcurrentRequestsPerHost = maxConcurrentRequestsPerHost;
        this.oauthTokenProvider = oauthTokenProvider;
        this.requestRetryBackoffLimit = requestRetryBackoffLimit;
        this.requestRetryBackoffInterval = requestRetryBackoffInterval;
        this.uploadConnectionTimeout = uploadConnectionTimeout;
        this.uploadRequestTimeout = uploadRequestTimeout;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public int getWatchReconnectInterval() {
        return this.watchReconnectInterval;
    }

    public void setWatchReconnectInterval(int watchReconnectInterval) {
        this.watchReconnectInterval = watchReconnectInterval;
    }

    public String getOauthToken() {
        if (this.oauthTokenProvider != null) {
            return this.oauthTokenProvider.getToken();
        }
        return this.oauthToken;
    }

    public void setOauthToken(String oauthToken) {
        this.oauthToken = oauthToken;
    }

    public OAuthTokenProvider getOauthTokenProvider() {
        return this.oauthTokenProvider;
    }

    public void setOauthTokenProvider(OAuthTokenProvider oauthTokenProvider) {
        this.oauthTokenProvider = oauthTokenProvider;
    }

    public int getWatchReconnectLimit() {
        return this.watchReconnectLimit;
    }

    public void setWatchReconnectLimit(int watchReconnectLimit) {
        this.watchReconnectLimit = watchReconnectLimit;
    }

    public int getRequestTimeout() {
        return this.requestTimeout;
    }

    public void setRequestTimeout(int requestTimeout) {
        this.requestTimeout = requestTimeout;
    }

    public int getRequestRetryBackoffLimit() {
        return this.requestRetryBackoffLimit;
    }

    public void setRequestRetryBackoffLimit(int requestRetryBackoffLimit) {
        this.requestRetryBackoffLimit = requestRetryBackoffLimit;
    }

    public int getRequestRetryBackoffInterval() {
        return this.requestRetryBackoffInterval;
    }

    public void setRequestRetryBackoffInterval(int requestRetryBackoffInterval) {
        this.requestRetryBackoffInterval = requestRetryBackoffInterval;
    }

    public int getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public void setConnectionTimeout(int connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }

    public int getUploadConnectionTimeout() {
        return this.uploadConnectionTimeout;
    }

    public void setUploadConnectionTimeout(int uploadConnectionTimeout) {
        this.uploadConnectionTimeout = uploadConnectionTimeout;
    }

    public int getUploadRequestTimeout() {
        return this.uploadRequestTimeout;
    }

    public void setUploadRequestTimeout(int uploadRequestTimeout) {
        this.uploadRequestTimeout = uploadRequestTimeout;
    }

    public long getRollingTimeout() {
        return this.rollingTimeout;
    }

    public void setRollingTimeout(long rollingTimeout) {
        this.rollingTimeout = rollingTimeout;
    }

    public long getScaleTimeout() {
        return this.scaleTimeout;
    }

    public void setScaleTimeout(long scaleTimeout) {
        this.scaleTimeout = scaleTimeout;
    }

    public int getLoggingInterval() {
        return this.loggingInterval;
    }

    public void setLoggingInterval(int loggingInterval) {
        this.loggingInterval = loggingInterval;
    }

    public long getWebsocketTimeout() {
        return this.websocketTimeout;
    }

    public void setWebsocketTimeout(long websocketTimeout) {
        this.websocketTimeout = websocketTimeout;
    }

    public long getWebsocketPingInterval() {
        return this.websocketPingInterval;
    }

    public void setWebsocketPingInterval(long websocketPingInterval) {
        this.websocketPingInterval = websocketPingInterval;
    }

    public int getMaxConcurrentRequests() {
        return this.maxConcurrentRequests;
    }

    public void setMaxConcurrentRequests(int maxConcurrentRequests) {
        this.maxConcurrentRequests = maxConcurrentRequests;
    }

    public int getMaxConcurrentRequestsPerHost() {
        return this.maxConcurrentRequestsPerHost;
    }

    public void setMaxConcurrentRequestsPerHost(int maxConcurrentRequestsPerHost) {
        this.maxConcurrentRequestsPerHost = maxConcurrentRequestsPerHost;
    }

    public void setImpersonateUsername(String impersonateUsername) {
        this.impersonateUsername = impersonateUsername;
    }

    public String getImpersonateUsername() {
        return this.impersonateUsername;
    }

    public void setImpersonateGroups(String ... impersonateGroups) {
        this.impersonateGroups = impersonateGroups == null ? new String[]{} : Arrays.copyOf(impersonateGroups, impersonateGroups.length);
    }

    public String[] getImpersonateGroups() {
        return this.impersonateGroups;
    }

    public void setImpersonateExtras(Map<String, List<String>> impersonateExtras) {
        this.impersonateExtras = new HashMap<String, List<String>>(impersonateExtras);
    }

    public Map<String, List<String>> getImpersonateExtras() {
        return Collections.unmodifiableMap(this.impersonateExtras);
    }
}

