/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.tubemq.client.consumer;

import java.util.ArrayList;
import java.util.List;
import org.apache.inlong.tubemq.client.common.PeerInfo;
import org.apache.inlong.tubemq.client.consumer.FetchContext;
import org.apache.inlong.tubemq.corebase.Message;
import org.apache.inlong.tubemq.corebase.cluster.Partition;
import org.apache.inlong.tubemq.corebase.rv.RetValue;

public class ConsumerResult
extends RetValue {
    private String topicName = "";
    private PeerInfo peerInfo = new PeerInfo();
    private String confirmContext = "";
    private List<Message> messageList = new ArrayList<Message>();

    public ConsumerResult() {
    }

    public ConsumerResult(int errCode, String errMsg) {
        super(errCode, errMsg);
    }

    public ConsumerResult(FetchContext taskContext) {
        super(taskContext.isSuccess(), taskContext.getErrCode(), taskContext.getErrMsg());
        this.topicName = taskContext.getPartition().getTopic();
        this.peerInfo.setMsgSourceInfo(taskContext.getPartition(), taskContext.getCurrOffset(), taskContext.getMaxOffset());
        if (this.isSuccess()) {
            this.messageList = taskContext.getMessageList();
            this.confirmContext = taskContext.getConfirmContext();
        }
    }

    public ConsumerResult(boolean isSuccess, int errCode, String errMsg, String topicName, Partition partition, long currOffset, long maxOffset) {
        super(isSuccess, errCode, errMsg);
        this.topicName = topicName;
        this.peerInfo.setMsgSourceInfo(partition, currOffset, maxOffset);
    }

    public void setSuccResult(String topicName, Partition partition, long currOffset, long maxOffset) {
        super.setSuccResult();
        this.topicName = topicName;
        this.peerInfo.setMsgSourceInfo(partition, currOffset, maxOffset);
    }

    public void setProcessResult(boolean isSuccess, int errCode, String errMsg, String topicName, Partition partition, long currOffset, long maxOffset) {
        super.setFullInfo(isSuccess, errCode, errMsg);
        this.topicName = topicName;
        this.peerInfo.setMsgSourceInfo(partition, currOffset, maxOffset);
    }

    public String getTopicName() {
        return this.topicName;
    }

    public PeerInfo getPeerInfo() {
        return this.peerInfo;
    }

    public String getPartitionKey() {
        return this.peerInfo.getPartitionKey();
    }

    public final String getConfirmContext() {
        return this.confirmContext;
    }

    public long getCurrOffset() {
        return this.peerInfo.getCurrOffset();
    }

    public final List<Message> getMessageList() {
        return this.messageList;
    }

    public long getMaxOffset() {
        return this.peerInfo.getMaxOffset();
    }
}

