/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sdk.dataproxy;

import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.inlong.sdk.dataproxy.BaseMsgSenderFactory;
import org.apache.inlong.sdk.dataproxy.MsgSenderFactory;
import org.apache.inlong.sdk.dataproxy.exception.ProxySdkException;
import org.apache.inlong.sdk.dataproxy.network.PkgCacheQuota;
import org.apache.inlong.sdk.dataproxy.sender.BaseSender;
import org.apache.inlong.sdk.dataproxy.sender.http.HttpMsgSenderConfig;
import org.apache.inlong.sdk.dataproxy.sender.http.InLongHttpMsgSender;
import org.apache.inlong.sdk.dataproxy.sender.tcp.InLongTcpMsgSender;
import org.apache.inlong.sdk.dataproxy.sender.tcp.TcpMsgSenderConfig;
import org.apache.inlong.sdk.dataproxy.utils.ProxyUtils;

public class MsgSenderMultiFactory
implements MsgSenderFactory {
    private static final AtomicLong refCounter = new AtomicLong(0L);
    private final AtomicBoolean initialized = new AtomicBoolean(false);
    private final BaseMsgSenderFactory baseMsgSenderFactory;

    public MsgSenderMultiFactory() {
        this(-1, -1);
    }

    public MsgSenderMultiFactory(int factoryPkgCntPermits, int factoryPkgSizeKbPermits) {
        this.baseMsgSenderFactory = new BaseMsgSenderFactory(this, "iMultiFact-" + ProxyUtils.getProcessPid() + "-" + refCounter.incrementAndGet(), factoryPkgCntPermits, factoryPkgSizeKbPermits);
        this.initialized.set(true);
    }

    @Override
    public void shutdownAll() {
        if (!this.initialized.compareAndSet(true, false)) {
            return;
        }
        this.baseMsgSenderFactory.close();
    }

    @Override
    public void removeClient(BaseSender msgSender) {
        if (msgSender == null || msgSender.getSenderFactory() == null || msgSender.getSenderFactory() != this) {
            return;
        }
        if (this.baseMsgSenderFactory == null) {
            return;
        }
        this.baseMsgSenderFactory.removeClient(msgSender);
    }

    @Override
    public int getMsgSenderCount() {
        if (this.baseMsgSenderFactory == null) {
            return -1;
        }
        return this.baseMsgSenderFactory.getMsgSenderCount();
    }

    @Override
    public PkgCacheQuota getFactoryPkgCacheQuota() {
        if (this.baseMsgSenderFactory == null) {
            return null;
        }
        return this.baseMsgSenderFactory.getPkgCacheQuota();
    }

    @Override
    public InLongTcpMsgSender genTcpSenderByGroupId(TcpMsgSenderConfig configure) throws ProxySdkException {
        return this.genTcpSenderByGroupId(configure, null);
    }

    @Override
    public InLongTcpMsgSender genTcpSenderByGroupId(TcpMsgSenderConfig configure, ThreadFactory selfDefineFactory) throws ProxySdkException {
        if (!this.initialized.get()) {
            throw new ProxySdkException("Please initialize the factory first!");
        }
        return this.baseMsgSenderFactory.genTcpSenderByGroupId(configure, selfDefineFactory);
    }

    @Override
    public InLongTcpMsgSender genTcpSenderByClusterId(TcpMsgSenderConfig configure) throws ProxySdkException {
        return this.genTcpSenderByClusterId(configure, null);
    }

    @Override
    public InLongTcpMsgSender genTcpSenderByClusterId(TcpMsgSenderConfig configure, ThreadFactory selfDefineFactory) throws ProxySdkException {
        if (!this.initialized.get()) {
            throw new ProxySdkException("Please initialize the factory first!");
        }
        return this.baseMsgSenderFactory.genTcpSenderByClusterId(configure, selfDefineFactory);
    }

    @Override
    public InLongHttpMsgSender genHttpSenderByGroupId(HttpMsgSenderConfig configure) throws ProxySdkException {
        if (!this.initialized.get()) {
            throw new ProxySdkException("Please initialize the factory first!");
        }
        return this.baseMsgSenderFactory.genHttpSenderByGroupId(configure);
    }

    @Override
    public InLongHttpMsgSender genHttpSenderByClusterId(HttpMsgSenderConfig configure) throws ProxySdkException {
        if (!this.initialized.get()) {
            throw new ProxySdkException("Please initialize the factory first!");
        }
        return this.baseMsgSenderFactory.genHttpSenderByClusterId(configure);
    }
}

