/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sdk.dataproxy.metric;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.LongAdder;
import org.apache.inlong.sdk.dataproxy.metric.TimeCostInfo;

public class MetaSyncInfo {
    private final Map<Integer, LongAdder> syncErrInfo = new ConcurrentHashMap<Integer, LongAdder>();
    private final TimeCostInfo syncCostMs = new TimeCostInfo("msMs");

    public void addSucMsgInfo(int errCode, long wastMs) {
        LongAdder longCount = this.syncErrInfo.get(errCode);
        if (longCount == null) {
            LongAdder tmpCount = new LongAdder();
            longCount = this.syncErrInfo.putIfAbsent(errCode, tmpCount);
            if (longCount == null) {
                longCount = tmpCount;
            }
        }
        longCount.increment();
        this.syncCostMs.addTimeCostInMs(wastMs);
    }

    public void getAndResetValue(StringBuilder strBuff) {
        if (this.syncErrInfo.isEmpty()) {
            strBuff.append("\"ms\":{\"errT\":{},");
            this.syncCostMs.getAndResetValue(strBuff);
            strBuff.append("}");
        } else {
            long curCnt = 0L;
            strBuff.append("\"ms\":{\"errT\":{");
            for (Map.Entry<Integer, LongAdder> entry : this.syncErrInfo.entrySet()) {
                if (entry == null || entry.getKey() == null || entry.getValue() == null) continue;
                if (curCnt++ > 0L) {
                    strBuff.append(",");
                }
                strBuff.append("\"e").append(entry.getKey()).append("\":").append(entry.getValue());
            }
            strBuff.append("},");
            this.syncCostMs.getAndResetValue(strBuff);
            strBuff.append("}");
            this.syncErrInfo.clear();
        }
    }

    public void clear() {
        this.syncCostMs.clear();
        this.syncErrInfo.clear();
    }
}

