/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.web.auth;

import java.util.Collection;
import javax.annotation.Resource;
import org.apache.inlong.manager.common.auth.InlongShiro;
import org.apache.shiro.mgt.SecurityManager;
import org.apache.shiro.realm.Realm;
import org.apache.shiro.session.mgt.SessionManager;
import org.apache.shiro.spring.security.interceptor.AuthorizationAttributeSourceAdvisor;
import org.apache.shiro.spring.web.ShiroFilterFactoryBean;
import org.apache.shiro.web.mgt.DefaultWebSecurityManager;
import org.apache.shiro.web.mgt.WebSecurityManager;
import org.apache.shiro.web.session.mgt.DefaultWebSessionManager;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class ShiroConfig {
    @Resource
    private InlongShiro inlongShiro;

    @Bean
    public Collection<Realm> shiroRealms() {
        return this.inlongShiro.getShiroRealms();
    }

    @Bean
    public WebSecurityManager securityManager() {
        DefaultWebSecurityManager securityManager = (DefaultWebSecurityManager)this.inlongShiro.getWebSecurityManager();
        securityManager.setSessionManager((SessionManager)new DefaultWebSessionManager());
        securityManager.setRealms(this.shiroRealms());
        return securityManager;
    }

    @Bean
    public DefaultWebSessionManager sessionManager() {
        DefaultWebSessionManager sessionManager = (DefaultWebSessionManager)this.inlongShiro.getWebSessionManager();
        sessionManager.setGlobalSessionTimeout(3600000L);
        return sessionManager;
    }

    @Bean
    public ShiroFilterFactoryBean shiroFilter(SecurityManager securityManager) {
        ShiroFilterFactoryBean shiroFilterFactoryBean = this.inlongShiro.getShiroFilter(securityManager);
        return shiroFilterFactoryBean;
    }

    @Bean
    public AuthorizationAttributeSourceAdvisor authorizationAttributeSourceAdvisor() {
        return this.inlongShiro.getAuthorizationAttributeSourceAdvisor((SecurityManager)this.securityManager());
    }
}

