/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.pojo.node.iceberg;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.apache.inlong.manager.common.util.CommonBeanUtils;
import org.apache.inlong.manager.common.util.JsonTypeDefine;
import org.apache.inlong.manager.pojo.node.DataNodeInfo;
import org.apache.inlong.manager.pojo.node.iceberg.IcebergDataNodeRequest;

@JsonTypeDefine(value="ICEBERG")
@ApiModel(value="Iceberg data node info")
public class IcebergDataNodeInfo
extends DataNodeInfo {
    @ApiModelProperty(value="Catalog type, like: HIVE, HADOOP, default is HIVE")
    private String catalogType = "HIVE";
    @ApiModelProperty(value="Iceberg data warehouse dir")
    private String warehouse;

    public IcebergDataNodeInfo() {
        this.setType("ICEBERG");
    }

    @Override
    public IcebergDataNodeRequest genRequest() {
        return (IcebergDataNodeRequest)CommonBeanUtils.copyProperties((Object)this, IcebergDataNodeRequest::new);
    }

    public String getCatalogType() {
        return this.catalogType;
    }

    public String getWarehouse() {
        return this.warehouse;
    }

    public void setCatalogType(String catalogType) {
        this.catalogType = catalogType;
    }

    public void setWarehouse(String warehouse) {
        this.warehouse = warehouse;
    }

    @Override
    public String toString() {
        return "IcebergDataNodeInfo(super=" + super.toString() + ", catalogType=" + this.getCatalogType() + ", warehouse=" + this.getWarehouse() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof IcebergDataNodeInfo)) {
            return false;
        }
        IcebergDataNodeInfo other = (IcebergDataNodeInfo)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$catalogType = this.getCatalogType();
        String other$catalogType = other.getCatalogType();
        if (this$catalogType == null ? other$catalogType != null : !this$catalogType.equals(other$catalogType)) {
            return false;
        }
        String this$warehouse = this.getWarehouse();
        String other$warehouse = other.getWarehouse();
        return !(this$warehouse == null ? other$warehouse != null : !this$warehouse.equals(other$warehouse));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof IcebergDataNodeInfo;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $catalogType = this.getCatalogType();
        result = result * 59 + ($catalogType == null ? 43 : $catalogType.hashCode());
        String $warehouse = this.getWarehouse();
        result = result * 59 + ($warehouse == null ? 43 : $warehouse.hashCode());
        return result;
    }
}

