/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.pojo.node.kudu;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.apache.inlong.manager.common.util.CommonBeanUtils;
import org.apache.inlong.manager.common.util.JsonTypeDefine;
import org.apache.inlong.manager.pojo.node.DataNodeInfo;
import org.apache.inlong.manager.pojo.node.DataNodeRequest;
import org.apache.inlong.manager.pojo.node.kudu.KuduDataNodeRequest;

@JsonTypeDefine(value="KUDU")
@ApiModel(value="Kudu data node info")
public class KuduDataNodeInfo
extends DataNodeInfo {
    @ApiModelProperty(value="Kudu masters, a comma separated list of 'host:port' pairs")
    private String masters;
    @ApiModelProperty(value="Sets the default timeout used for administrative operations (e.g. createTable, deleteTable, etc). Optional. If not provided, defaults to 30s. A value of 0 disables the timeout")
    private Integer defaultAdminOperationTimeoutMs;
    @ApiModelProperty(value="Sets the default timeout used for user operations (using sessions and scanners). Optional. If not provided, defaults to 30s. A value of 0 disables the timeout")
    private Integer defaultOperationTimeoutMs = 30000;
    @ApiModelProperty(value="Default socket read timeout in ms, default is 10000")
    private Integer defaultSocketReadTimeoutMs = 10000;
    @ApiModelProperty(value="Disable this client's collection of statistics. Statistics are enabled by default")
    private Boolean statisticsDisabled = false;

    public KuduDataNodeInfo() {
        this.setType("KUDU");
    }

    @Override
    public DataNodeRequest genRequest() {
        return (DataNodeRequest)CommonBeanUtils.copyProperties((Object)this, KuduDataNodeRequest::new);
    }

    protected KuduDataNodeInfo(KuduDataNodeInfoBuilder<?, ?> b) {
        super(b);
        this.masters = ((KuduDataNodeInfoBuilder)b).masters;
        this.defaultAdminOperationTimeoutMs = ((KuduDataNodeInfoBuilder)b).defaultAdminOperationTimeoutMs;
        this.defaultOperationTimeoutMs = ((KuduDataNodeInfoBuilder)b).defaultOperationTimeoutMs;
        this.defaultSocketReadTimeoutMs = ((KuduDataNodeInfoBuilder)b).defaultSocketReadTimeoutMs;
        this.statisticsDisabled = ((KuduDataNodeInfoBuilder)b).statisticsDisabled;
    }

    public static KuduDataNodeInfoBuilder<?, ?> builder() {
        return new KuduDataNodeInfoBuilderImpl();
    }

    public String getMasters() {
        return this.masters;
    }

    public Integer getDefaultAdminOperationTimeoutMs() {
        return this.defaultAdminOperationTimeoutMs;
    }

    public Integer getDefaultOperationTimeoutMs() {
        return this.defaultOperationTimeoutMs;
    }

    public Integer getDefaultSocketReadTimeoutMs() {
        return this.defaultSocketReadTimeoutMs;
    }

    public Boolean getStatisticsDisabled() {
        return this.statisticsDisabled;
    }

    public void setMasters(String masters) {
        this.masters = masters;
    }

    public void setDefaultAdminOperationTimeoutMs(Integer defaultAdminOperationTimeoutMs) {
        this.defaultAdminOperationTimeoutMs = defaultAdminOperationTimeoutMs;
    }

    public void setDefaultOperationTimeoutMs(Integer defaultOperationTimeoutMs) {
        this.defaultOperationTimeoutMs = defaultOperationTimeoutMs;
    }

    public void setDefaultSocketReadTimeoutMs(Integer defaultSocketReadTimeoutMs) {
        this.defaultSocketReadTimeoutMs = defaultSocketReadTimeoutMs;
    }

    public void setStatisticsDisabled(Boolean statisticsDisabled) {
        this.statisticsDisabled = statisticsDisabled;
    }

    public KuduDataNodeInfo(String masters, Integer defaultAdminOperationTimeoutMs, Integer defaultOperationTimeoutMs, Integer defaultSocketReadTimeoutMs, Boolean statisticsDisabled) {
        this.masters = masters;
        this.defaultAdminOperationTimeoutMs = defaultAdminOperationTimeoutMs;
        this.defaultOperationTimeoutMs = defaultOperationTimeoutMs;
        this.defaultSocketReadTimeoutMs = defaultSocketReadTimeoutMs;
        this.statisticsDisabled = statisticsDisabled;
    }

    @Override
    public String toString() {
        return "KuduDataNodeInfo(super=" + super.toString() + ", masters=" + this.getMasters() + ", defaultAdminOperationTimeoutMs=" + this.getDefaultAdminOperationTimeoutMs() + ", defaultOperationTimeoutMs=" + this.getDefaultOperationTimeoutMs() + ", defaultSocketReadTimeoutMs=" + this.getDefaultSocketReadTimeoutMs() + ", statisticsDisabled=" + this.getStatisticsDisabled() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof KuduDataNodeInfo)) {
            return false;
        }
        KuduDataNodeInfo other = (KuduDataNodeInfo)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Integer this$defaultAdminOperationTimeoutMs = this.getDefaultAdminOperationTimeoutMs();
        Integer other$defaultAdminOperationTimeoutMs = other.getDefaultAdminOperationTimeoutMs();
        if (this$defaultAdminOperationTimeoutMs == null ? other$defaultAdminOperationTimeoutMs != null : !((Object)this$defaultAdminOperationTimeoutMs).equals(other$defaultAdminOperationTimeoutMs)) {
            return false;
        }
        Integer this$defaultOperationTimeoutMs = this.getDefaultOperationTimeoutMs();
        Integer other$defaultOperationTimeoutMs = other.getDefaultOperationTimeoutMs();
        if (this$defaultOperationTimeoutMs == null ? other$defaultOperationTimeoutMs != null : !((Object)this$defaultOperationTimeoutMs).equals(other$defaultOperationTimeoutMs)) {
            return false;
        }
        Integer this$defaultSocketReadTimeoutMs = this.getDefaultSocketReadTimeoutMs();
        Integer other$defaultSocketReadTimeoutMs = other.getDefaultSocketReadTimeoutMs();
        if (this$defaultSocketReadTimeoutMs == null ? other$defaultSocketReadTimeoutMs != null : !((Object)this$defaultSocketReadTimeoutMs).equals(other$defaultSocketReadTimeoutMs)) {
            return false;
        }
        Boolean this$statisticsDisabled = this.getStatisticsDisabled();
        Boolean other$statisticsDisabled = other.getStatisticsDisabled();
        if (this$statisticsDisabled == null ? other$statisticsDisabled != null : !((Object)this$statisticsDisabled).equals(other$statisticsDisabled)) {
            return false;
        }
        String this$masters = this.getMasters();
        String other$masters = other.getMasters();
        return !(this$masters == null ? other$masters != null : !this$masters.equals(other$masters));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof KuduDataNodeInfo;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Integer $defaultAdminOperationTimeoutMs = this.getDefaultAdminOperationTimeoutMs();
        result = result * 59 + ($defaultAdminOperationTimeoutMs == null ? 43 : ((Object)$defaultAdminOperationTimeoutMs).hashCode());
        Integer $defaultOperationTimeoutMs = this.getDefaultOperationTimeoutMs();
        result = result * 59 + ($defaultOperationTimeoutMs == null ? 43 : ((Object)$defaultOperationTimeoutMs).hashCode());
        Integer $defaultSocketReadTimeoutMs = this.getDefaultSocketReadTimeoutMs();
        result = result * 59 + ($defaultSocketReadTimeoutMs == null ? 43 : ((Object)$defaultSocketReadTimeoutMs).hashCode());
        Boolean $statisticsDisabled = this.getStatisticsDisabled();
        result = result * 59 + ($statisticsDisabled == null ? 43 : ((Object)$statisticsDisabled).hashCode());
        String $masters = this.getMasters();
        result = result * 59 + ($masters == null ? 43 : $masters.hashCode());
        return result;
    }

    private static final class KuduDataNodeInfoBuilderImpl
    extends KuduDataNodeInfoBuilder<KuduDataNodeInfo, KuduDataNodeInfoBuilderImpl> {
        private KuduDataNodeInfoBuilderImpl() {
        }

        @Override
        protected KuduDataNodeInfoBuilderImpl self() {
            return this;
        }

        @Override
        public KuduDataNodeInfo build() {
            return new KuduDataNodeInfo(this);
        }
    }

    public static abstract class KuduDataNodeInfoBuilder<C extends KuduDataNodeInfo, B extends KuduDataNodeInfoBuilder<C, B>>
    extends DataNodeInfo.DataNodeInfoBuilder<C, B> {
        private String masters;
        private Integer defaultAdminOperationTimeoutMs;
        private Integer defaultOperationTimeoutMs;
        private Integer defaultSocketReadTimeoutMs;
        private Boolean statisticsDisabled;

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        public B masters(String masters) {
            this.masters = masters;
            return (B)this.self();
        }

        public B defaultAdminOperationTimeoutMs(Integer defaultAdminOperationTimeoutMs) {
            this.defaultAdminOperationTimeoutMs = defaultAdminOperationTimeoutMs;
            return (B)this.self();
        }

        public B defaultOperationTimeoutMs(Integer defaultOperationTimeoutMs) {
            this.defaultOperationTimeoutMs = defaultOperationTimeoutMs;
            return (B)this.self();
        }

        public B defaultSocketReadTimeoutMs(Integer defaultSocketReadTimeoutMs) {
            this.defaultSocketReadTimeoutMs = defaultSocketReadTimeoutMs;
            return (B)this.self();
        }

        public B statisticsDisabled(Boolean statisticsDisabled) {
            this.statisticsDisabled = statisticsDisabled;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "KuduDataNodeInfo.KuduDataNodeInfoBuilder(super=" + super.toString() + ", masters=" + this.masters + ", defaultAdminOperationTimeoutMs=" + this.defaultAdminOperationTimeoutMs + ", defaultOperationTimeoutMs=" + this.defaultOperationTimeoutMs + ", defaultSocketReadTimeoutMs=" + this.defaultSocketReadTimeoutMs + ", statisticsDisabled=" + this.statisticsDisabled + ")";
        }
    }
}

