/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.pojo.sink;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.List;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.Pattern;
import org.apache.inlong.manager.common.validation.SaveValidation;
import org.apache.inlong.manager.common.validation.UpdateByKeyValidation;
import org.apache.inlong.manager.pojo.sink.SinkField;
import org.hibernate.validator.constraints.Length;

@ApiModel(value="Transform parse request")
public class TransformParseRequest {
    @ApiModelProperty(value="Inlong group id")
    @NotBlank(groups={SaveValidation.class, UpdateByKeyValidation.class}, message="inlongGroupId cannot be blank")
    @Length(min=4, max=256, message="length must be between 4 and 200")
    @Pattern(regexp="^[a-zA-Z0-9_.-]{4,200}$", message="only supports letters, numbers, '.', '-', or '_'")
    private @NotBlank(groups={SaveValidation.class, UpdateByKeyValidation.class}, message="inlongGroupId cannot be blank") @Length(min=4, max=256, message="length must be between 4 and 200") @Pattern(regexp="^[a-zA-Z0-9_.-]{4,200}$", message="only supports letters, numbers, '.', '-', or '_'") String inlongGroupId;
    @ApiModelProperty(value="Inlong stream id")
    @NotBlank(groups={SaveValidation.class, UpdateByKeyValidation.class}, message="inlongStreamId cannot be blank")
    @Length(min=1, max=256, message="inlongStreamId length must be between 1 and 200")
    @Pattern(regexp="^[a-zA-Z0-9_.-]{1,200}$", message="inlongStreamId only supports letters, numbers, '.', '-', or '_'")
    private @NotBlank(groups={SaveValidation.class, UpdateByKeyValidation.class}, message="inlongStreamId cannot be blank") @Length(min=1, max=256, message="inlongStreamId length must be between 1 and 200") @Pattern(regexp="^[a-zA-Z0-9_.-]{1,200}$", message="inlongStreamId only supports letters, numbers, '.', '-', or '_'") String inlongStreamId;
    @ApiModelProperty(value="Transform sql")
    private String transformSql;
    @ApiModelProperty(value="Data")
    private String data;
    @ApiModelProperty(value="Sink field list")
    private List<SinkField> sinkFieldList;

    public String getInlongGroupId() {
        return this.inlongGroupId;
    }

    public String getInlongStreamId() {
        return this.inlongStreamId;
    }

    public String getTransformSql() {
        return this.transformSql;
    }

    public String getData() {
        return this.data;
    }

    public List<SinkField> getSinkFieldList() {
        return this.sinkFieldList;
    }

    public void setInlongGroupId(String inlongGroupId) {
        this.inlongGroupId = inlongGroupId;
    }

    public void setInlongStreamId(String inlongStreamId) {
        this.inlongStreamId = inlongStreamId;
    }

    public void setTransformSql(String transformSql) {
        this.transformSql = transformSql;
    }

    public void setData(String data) {
        this.data = data;
    }

    public void setSinkFieldList(List<SinkField> sinkFieldList) {
        this.sinkFieldList = sinkFieldList;
    }

    public String toString() {
        return "TransformParseRequest(inlongGroupId=" + this.getInlongGroupId() + ", inlongStreamId=" + this.getInlongStreamId() + ", transformSql=" + this.getTransformSql() + ", data=" + this.getData() + ", sinkFieldList=" + this.getSinkFieldList() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TransformParseRequest)) {
            return false;
        }
        TransformParseRequest other = (TransformParseRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$inlongGroupId = this.getInlongGroupId();
        String other$inlongGroupId = other.getInlongGroupId();
        if (this$inlongGroupId == null ? other$inlongGroupId != null : !this$inlongGroupId.equals(other$inlongGroupId)) {
            return false;
        }
        String this$inlongStreamId = this.getInlongStreamId();
        String other$inlongStreamId = other.getInlongStreamId();
        if (this$inlongStreamId == null ? other$inlongStreamId != null : !this$inlongStreamId.equals(other$inlongStreamId)) {
            return false;
        }
        String this$transformSql = this.getTransformSql();
        String other$transformSql = other.getTransformSql();
        if (this$transformSql == null ? other$transformSql != null : !this$transformSql.equals(other$transformSql)) {
            return false;
        }
        String this$data = this.getData();
        String other$data = other.getData();
        if (this$data == null ? other$data != null : !this$data.equals(other$data)) {
            return false;
        }
        List<SinkField> this$sinkFieldList = this.getSinkFieldList();
        List<SinkField> other$sinkFieldList = other.getSinkFieldList();
        return !(this$sinkFieldList == null ? other$sinkFieldList != null : !((Object)this$sinkFieldList).equals(other$sinkFieldList));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TransformParseRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $inlongGroupId = this.getInlongGroupId();
        result = result * 59 + ($inlongGroupId == null ? 43 : $inlongGroupId.hashCode());
        String $inlongStreamId = this.getInlongStreamId();
        result = result * 59 + ($inlongStreamId == null ? 43 : $inlongStreamId.hashCode());
        String $transformSql = this.getTransformSql();
        result = result * 59 + ($transformSql == null ? 43 : $transformSql.hashCode());
        String $data = this.getData();
        result = result * 59 + ($data == null ? 43 : $data.hashCode());
        List<SinkField> $sinkFieldList = this.getSinkFieldList();
        result = result * 59 + ($sinkFieldList == null ? 43 : ((Object)$sinkFieldList).hashCode());
        return result;
    }
}

