/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.pojo.sink.hudi;

import io.swagger.annotations.ApiModelProperty;
import org.apache.commons.lang3.StringUtils;
import org.apache.inlong.manager.common.enums.ErrorCodeEnum;
import org.apache.inlong.manager.common.exceptions.BusinessException;
import org.apache.inlong.manager.common.util.JsonUtils;

public class HudiColumnInfo {
    @ApiModelProperty(value="Length of fixed type")
    private Integer length;
    @ApiModelProperty(value="Precision of decimal type")
    private Integer precision;
    @ApiModelProperty(value="Scale of decimal type")
    private Integer scale;
    @ApiModelProperty(value="Field partition strategy, including: None, Identity, Year, Month, Day, Hour, Bucket, Truncate")
    private String partitionStrategy;
    @ApiModelProperty(value="Bucket num param of bucket partition")
    private Integer bucketNum;
    @ApiModelProperty(value="Width param of truncate partition")
    private Integer width;
    private String name;
    private String type;
    private String desc;
    private boolean required;
    private boolean isPartition;

    public static HudiColumnInfo getFromJson(String extParams) {
        if (StringUtils.isEmpty((CharSequence)extParams)) {
            return new HudiColumnInfo();
        }
        try {
            return (HudiColumnInfo)JsonUtils.parseObject((String)extParams, HudiColumnInfo.class);
        }
        catch (Exception e) {
            throw new BusinessException(ErrorCodeEnum.SINK_INFO_INCORRECT.getMessage() + ": " + e.getMessage());
        }
    }

    public static HudiColumnInfoBuilder builder() {
        return new HudiColumnInfoBuilder();
    }

    public Integer getLength() {
        return this.length;
    }

    public Integer getPrecision() {
        return this.precision;
    }

    public Integer getScale() {
        return this.scale;
    }

    public String getPartitionStrategy() {
        return this.partitionStrategy;
    }

    public Integer getBucketNum() {
        return this.bucketNum;
    }

    public Integer getWidth() {
        return this.width;
    }

    public String getName() {
        return this.name;
    }

    public String getType() {
        return this.type;
    }

    public String getDesc() {
        return this.desc;
    }

    public boolean isRequired() {
        return this.required;
    }

    public boolean isPartition() {
        return this.isPartition;
    }

    public void setLength(Integer length) {
        this.length = length;
    }

    public void setPrecision(Integer precision) {
        this.precision = precision;
    }

    public void setScale(Integer scale) {
        this.scale = scale;
    }

    public void setPartitionStrategy(String partitionStrategy) {
        this.partitionStrategy = partitionStrategy;
    }

    public void setBucketNum(Integer bucketNum) {
        this.bucketNum = bucketNum;
    }

    public void setWidth(Integer width) {
        this.width = width;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    public void setRequired(boolean required) {
        this.required = required;
    }

    public void setPartition(boolean isPartition) {
        this.isPartition = isPartition;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HudiColumnInfo)) {
            return false;
        }
        HudiColumnInfo other = (HudiColumnInfo)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isRequired() != other.isRequired()) {
            return false;
        }
        if (this.isPartition() != other.isPartition()) {
            return false;
        }
        Integer this$length = this.getLength();
        Integer other$length = other.getLength();
        if (this$length == null ? other$length != null : !((Object)this$length).equals(other$length)) {
            return false;
        }
        Integer this$precision = this.getPrecision();
        Integer other$precision = other.getPrecision();
        if (this$precision == null ? other$precision != null : !((Object)this$precision).equals(other$precision)) {
            return false;
        }
        Integer this$scale = this.getScale();
        Integer other$scale = other.getScale();
        if (this$scale == null ? other$scale != null : !((Object)this$scale).equals(other$scale)) {
            return false;
        }
        Integer this$bucketNum = this.getBucketNum();
        Integer other$bucketNum = other.getBucketNum();
        if (this$bucketNum == null ? other$bucketNum != null : !((Object)this$bucketNum).equals(other$bucketNum)) {
            return false;
        }
        Integer this$width = this.getWidth();
        Integer other$width = other.getWidth();
        if (this$width == null ? other$width != null : !((Object)this$width).equals(other$width)) {
            return false;
        }
        String this$partitionStrategy = this.getPartitionStrategy();
        String other$partitionStrategy = other.getPartitionStrategy();
        if (this$partitionStrategy == null ? other$partitionStrategy != null : !this$partitionStrategy.equals(other$partitionStrategy)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        String this$desc = this.getDesc();
        String other$desc = other.getDesc();
        return !(this$desc == null ? other$desc != null : !this$desc.equals(other$desc));
    }

    protected boolean canEqual(Object other) {
        return other instanceof HudiColumnInfo;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isRequired() ? 79 : 97);
        result = result * 59 + (this.isPartition() ? 79 : 97);
        Integer $length = this.getLength();
        result = result * 59 + ($length == null ? 43 : ((Object)$length).hashCode());
        Integer $precision = this.getPrecision();
        result = result * 59 + ($precision == null ? 43 : ((Object)$precision).hashCode());
        Integer $scale = this.getScale();
        result = result * 59 + ($scale == null ? 43 : ((Object)$scale).hashCode());
        Integer $bucketNum = this.getBucketNum();
        result = result * 59 + ($bucketNum == null ? 43 : ((Object)$bucketNum).hashCode());
        Integer $width = this.getWidth();
        result = result * 59 + ($width == null ? 43 : ((Object)$width).hashCode());
        String $partitionStrategy = this.getPartitionStrategy();
        result = result * 59 + ($partitionStrategy == null ? 43 : $partitionStrategy.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        String $desc = this.getDesc();
        result = result * 59 + ($desc == null ? 43 : $desc.hashCode());
        return result;
    }

    public String toString() {
        return "HudiColumnInfo(length=" + this.getLength() + ", precision=" + this.getPrecision() + ", scale=" + this.getScale() + ", partitionStrategy=" + this.getPartitionStrategy() + ", bucketNum=" + this.getBucketNum() + ", width=" + this.getWidth() + ", name=" + this.getName() + ", type=" + this.getType() + ", desc=" + this.getDesc() + ", required=" + this.isRequired() + ", isPartition=" + this.isPartition() + ")";
    }

    public HudiColumnInfo() {
    }

    public HudiColumnInfo(Integer length, Integer precision, Integer scale, String partitionStrategy, Integer bucketNum, Integer width, String name, String type, String desc, boolean required, boolean isPartition) {
        this.length = length;
        this.precision = precision;
        this.scale = scale;
        this.partitionStrategy = partitionStrategy;
        this.bucketNum = bucketNum;
        this.width = width;
        this.name = name;
        this.type = type;
        this.desc = desc;
        this.required = required;
        this.isPartition = isPartition;
    }

    public static class HudiColumnInfoBuilder {
        private Integer length;
        private Integer precision;
        private Integer scale;
        private String partitionStrategy;
        private Integer bucketNum;
        private Integer width;
        private String name;
        private String type;
        private String desc;
        private boolean required;
        private boolean isPartition;

        HudiColumnInfoBuilder() {
        }

        public HudiColumnInfoBuilder length(Integer length) {
            this.length = length;
            return this;
        }

        public HudiColumnInfoBuilder precision(Integer precision) {
            this.precision = precision;
            return this;
        }

        public HudiColumnInfoBuilder scale(Integer scale) {
            this.scale = scale;
            return this;
        }

        public HudiColumnInfoBuilder partitionStrategy(String partitionStrategy) {
            this.partitionStrategy = partitionStrategy;
            return this;
        }

        public HudiColumnInfoBuilder bucketNum(Integer bucketNum) {
            this.bucketNum = bucketNum;
            return this;
        }

        public HudiColumnInfoBuilder width(Integer width) {
            this.width = width;
            return this;
        }

        public HudiColumnInfoBuilder name(String name) {
            this.name = name;
            return this;
        }

        public HudiColumnInfoBuilder type(String type) {
            this.type = type;
            return this;
        }

        public HudiColumnInfoBuilder desc(String desc) {
            this.desc = desc;
            return this;
        }

        public HudiColumnInfoBuilder required(boolean required) {
            this.required = required;
            return this;
        }

        public HudiColumnInfoBuilder isPartition(boolean isPartition) {
            this.isPartition = isPartition;
            return this;
        }

        public HudiColumnInfo build() {
            return new HudiColumnInfo(this.length, this.precision, this.scale, this.partitionStrategy, this.bucketNum, this.width, this.name, this.type, this.desc, this.required, this.isPartition);
        }

        public String toString() {
            return "HudiColumnInfo.HudiColumnInfoBuilder(length=" + this.length + ", precision=" + this.precision + ", scale=" + this.scale + ", partitionStrategy=" + this.partitionStrategy + ", bucketNum=" + this.bucketNum + ", width=" + this.width + ", name=" + this.name + ", type=" + this.type + ", desc=" + this.desc + ", required=" + this.required + ", isPartition=" + this.isPartition + ")";
        }
    }
}

