/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.pojo.sink.kudu;

import io.swagger.annotations.ApiModelProperty;
import java.util.List;
import java.util.Map;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang3.StringUtils;
import org.apache.inlong.manager.common.enums.ErrorCodeEnum;
import org.apache.inlong.manager.common.exceptions.BusinessException;
import org.apache.inlong.manager.common.util.CommonBeanUtils;
import org.apache.inlong.manager.common.util.JsonUtils;
import org.apache.inlong.manager.pojo.sink.BaseStreamSink;
import org.apache.inlong.manager.pojo.sink.kudu.KuduColumnInfo;
import org.apache.inlong.manager.pojo.sink.kudu.KuduSinkRequest;
import org.apache.inlong.manager.pojo.sink.kudu.KuduTableInfo;

public class KuduSinkDTO
extends BaseStreamSink {
    @ApiModelProperty(value="Kudu masters, a comma separated list of 'host:port' pairs")
    private String masters;
    @ApiModelProperty(value="Target table name")
    private String tableName;
    @ApiModelProperty(value="Properties for Kudu")
    private Map<String, Object> properties;
    @ApiModelProperty(value="Partition field list")
    private String partitionKey;
    @ApiModelProperty(value="Buckets for the newly created table")
    private Integer buckets;

    public static KuduSinkDTO getFromRequest(KuduSinkRequest request, String extParams) {
        KuduSinkDTO dto = StringUtils.isNotBlank((CharSequence)extParams) ? KuduSinkDTO.getFromJson(extParams) : new KuduSinkDTO();
        return (KuduSinkDTO)CommonBeanUtils.copyProperties((Object)request, (Object)dto, (boolean)true);
    }

    public static KuduSinkDTO getFromJson(@NotNull String extParams) {
        try {
            return (KuduSinkDTO)JsonUtils.parseObject((String)extParams, KuduSinkDTO.class);
        }
        catch (Exception e) {
            throw new BusinessException(ErrorCodeEnum.SINK_INFO_INCORRECT, String.format("parse extParams of Kudu SinkDTO failure: %s", e.getMessage()));
        }
    }

    public static KuduTableInfo getKuduTableInfo(KuduSinkDTO kuduInfo, List<KuduColumnInfo> columnList) {
        KuduTableInfo tableInfo = new KuduTableInfo();
        tableInfo.setTableName(kuduInfo.getTableName());
        tableInfo.setMasters(kuduInfo.getMasters());
        tableInfo.setColumns(columnList);
        tableInfo.setTblProperties(kuduInfo.getProperties());
        tableInfo.setBuckets(kuduInfo.getBuckets());
        return tableInfo;
    }

    public static KuduSinkDTOBuilder builder() {
        return new KuduSinkDTOBuilder();
    }

    public String getMasters() {
        return this.masters;
    }

    public String getTableName() {
        return this.tableName;
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public String getPartitionKey() {
        return this.partitionKey;
    }

    public Integer getBuckets() {
        return this.buckets;
    }

    public void setMasters(String masters) {
        this.masters = masters;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public void setProperties(Map<String, Object> properties) {
        this.properties = properties;
    }

    public void setPartitionKey(String partitionKey) {
        this.partitionKey = partitionKey;
    }

    public void setBuckets(Integer buckets) {
        this.buckets = buckets;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof KuduSinkDTO)) {
            return false;
        }
        KuduSinkDTO other = (KuduSinkDTO)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$buckets = this.getBuckets();
        Integer other$buckets = other.getBuckets();
        if (this$buckets == null ? other$buckets != null : !((Object)this$buckets).equals(other$buckets)) {
            return false;
        }
        String this$masters = this.getMasters();
        String other$masters = other.getMasters();
        if (this$masters == null ? other$masters != null : !this$masters.equals(other$masters)) {
            return false;
        }
        String this$tableName = this.getTableName();
        String other$tableName = other.getTableName();
        if (this$tableName == null ? other$tableName != null : !this$tableName.equals(other$tableName)) {
            return false;
        }
        Map<String, Object> this$properties = this.getProperties();
        Map<String, Object> other$properties = other.getProperties();
        if (this$properties == null ? other$properties != null : !((Object)this$properties).equals(other$properties)) {
            return false;
        }
        String this$partitionKey = this.getPartitionKey();
        String other$partitionKey = other.getPartitionKey();
        return !(this$partitionKey == null ? other$partitionKey != null : !this$partitionKey.equals(other$partitionKey));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof KuduSinkDTO;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $buckets = this.getBuckets();
        result = result * 59 + ($buckets == null ? 43 : ((Object)$buckets).hashCode());
        String $masters = this.getMasters();
        result = result * 59 + ($masters == null ? 43 : $masters.hashCode());
        String $tableName = this.getTableName();
        result = result * 59 + ($tableName == null ? 43 : $tableName.hashCode());
        Map<String, Object> $properties = this.getProperties();
        result = result * 59 + ($properties == null ? 43 : ((Object)$properties).hashCode());
        String $partitionKey = this.getPartitionKey();
        result = result * 59 + ($partitionKey == null ? 43 : $partitionKey.hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "KuduSinkDTO(masters=" + this.getMasters() + ", tableName=" + this.getTableName() + ", properties=" + this.getProperties() + ", partitionKey=" + this.getPartitionKey() + ", buckets=" + this.getBuckets() + ")";
    }

    public KuduSinkDTO() {
    }

    public KuduSinkDTO(String masters, String tableName, Map<String, Object> properties, String partitionKey, Integer buckets) {
        this.masters = masters;
        this.tableName = tableName;
        this.properties = properties;
        this.partitionKey = partitionKey;
        this.buckets = buckets;
    }

    public static class KuduSinkDTOBuilder {
        private String masters;
        private String tableName;
        private Map<String, Object> properties;
        private String partitionKey;
        private Integer buckets;

        KuduSinkDTOBuilder() {
        }

        public KuduSinkDTOBuilder masters(String masters) {
            this.masters = masters;
            return this;
        }

        public KuduSinkDTOBuilder tableName(String tableName) {
            this.tableName = tableName;
            return this;
        }

        public KuduSinkDTOBuilder properties(Map<String, Object> properties) {
            this.properties = properties;
            return this;
        }

        public KuduSinkDTOBuilder partitionKey(String partitionKey) {
            this.partitionKey = partitionKey;
            return this;
        }

        public KuduSinkDTOBuilder buckets(Integer buckets) {
            this.buckets = buckets;
            return this;
        }

        public KuduSinkDTO build() {
            return new KuduSinkDTO(this.masters, this.tableName, this.properties, this.partitionKey, this.buckets);
        }

        public String toString() {
            return "KuduSinkDTO.KuduSinkDTOBuilder(masters=" + this.masters + ", tableName=" + this.tableName + ", properties=" + this.properties + ", partitionKey=" + this.partitionKey + ", buckets=" + this.buckets + ")";
        }
    }
}

