/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.pojo.transform.joiner;

import com.fasterxml.jackson.annotation.JsonFormat;
import java.util.List;
import org.apache.inlong.manager.common.enums.TransformType;
import org.apache.inlong.manager.pojo.stream.StreamField;
import org.apache.inlong.manager.pojo.stream.StreamNode;
import org.apache.inlong.manager.pojo.transform.TransformDefinition;
import org.apache.inlong.manager.pojo.transform.joiner.JoinerDefinition;

public class TemporalJoinerDefinition
extends TransformDefinition {
    private TemporalJoinWay temporalJoinWay;
    private StreamNode leftNode;
    private String leftTimeColumn;
    private String rightTimeColumn;
    private StreamNode rightNode;
    private List<StreamField> leftJoinFields;
    private List<StreamField> rightJoinFields;
    private JoinerDefinition.JoinMode joinMode;

    public TemporalJoinerDefinition(TemporalJoinWay temporalJoinWay, StreamNode leftNode, String leftTimeColumn, String rightTimeColumn, StreamNode rightNode, List<StreamField> leftJoinFields, List<StreamField> rightJoinFields, JoinerDefinition.JoinMode joinMode) {
        this.transformType = TransformType.TEMPORAL_JOINER;
        this.temporalJoinWay = temporalJoinWay;
        this.leftNode = leftNode;
        this.leftTimeColumn = leftTimeColumn;
        this.rightTimeColumn = rightTimeColumn;
        this.rightNode = rightNode;
        this.leftJoinFields = leftJoinFields;
        this.rightJoinFields = rightJoinFields;
        this.joinMode = joinMode;
    }

    public static TemporalJoinerDefinitionBuilder builder() {
        return new TemporalJoinerDefinitionBuilder();
    }

    public TemporalJoinWay getTemporalJoinWay() {
        return this.temporalJoinWay;
    }

    public StreamNode getLeftNode() {
        return this.leftNode;
    }

    public String getLeftTimeColumn() {
        return this.leftTimeColumn;
    }

    public String getRightTimeColumn() {
        return this.rightTimeColumn;
    }

    public StreamNode getRightNode() {
        return this.rightNode;
    }

    public List<StreamField> getLeftJoinFields() {
        return this.leftJoinFields;
    }

    public List<StreamField> getRightJoinFields() {
        return this.rightJoinFields;
    }

    public JoinerDefinition.JoinMode getJoinMode() {
        return this.joinMode;
    }

    public void setTemporalJoinWay(TemporalJoinWay temporalJoinWay) {
        this.temporalJoinWay = temporalJoinWay;
    }

    public void setLeftNode(StreamNode leftNode) {
        this.leftNode = leftNode;
    }

    public void setLeftTimeColumn(String leftTimeColumn) {
        this.leftTimeColumn = leftTimeColumn;
    }

    public void setRightTimeColumn(String rightTimeColumn) {
        this.rightTimeColumn = rightTimeColumn;
    }

    public void setRightNode(StreamNode rightNode) {
        this.rightNode = rightNode;
    }

    public void setLeftJoinFields(List<StreamField> leftJoinFields) {
        this.leftJoinFields = leftJoinFields;
    }

    public void setRightJoinFields(List<StreamField> rightJoinFields) {
        this.rightJoinFields = rightJoinFields;
    }

    public void setJoinMode(JoinerDefinition.JoinMode joinMode) {
        this.joinMode = joinMode;
    }

    @Override
    public String toString() {
        return "TemporalJoinerDefinition(temporalJoinWay=" + (Object)((Object)this.getTemporalJoinWay()) + ", leftNode=" + this.getLeftNode() + ", leftTimeColumn=" + this.getLeftTimeColumn() + ", rightTimeColumn=" + this.getRightTimeColumn() + ", rightNode=" + this.getRightNode() + ", leftJoinFields=" + this.getLeftJoinFields() + ", rightJoinFields=" + this.getRightJoinFields() + ", joinMode=" + (Object)((Object)this.getJoinMode()) + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TemporalJoinerDefinition)) {
            return false;
        }
        TemporalJoinerDefinition other = (TemporalJoinerDefinition)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        TemporalJoinWay this$temporalJoinWay = this.getTemporalJoinWay();
        TemporalJoinWay other$temporalJoinWay = other.getTemporalJoinWay();
        if (this$temporalJoinWay == null ? other$temporalJoinWay != null : !((Object)((Object)this$temporalJoinWay)).equals((Object)other$temporalJoinWay)) {
            return false;
        }
        StreamNode this$leftNode = this.getLeftNode();
        StreamNode other$leftNode = other.getLeftNode();
        if (this$leftNode == null ? other$leftNode != null : !((Object)this$leftNode).equals(other$leftNode)) {
            return false;
        }
        String this$leftTimeColumn = this.getLeftTimeColumn();
        String other$leftTimeColumn = other.getLeftTimeColumn();
        if (this$leftTimeColumn == null ? other$leftTimeColumn != null : !this$leftTimeColumn.equals(other$leftTimeColumn)) {
            return false;
        }
        String this$rightTimeColumn = this.getRightTimeColumn();
        String other$rightTimeColumn = other.getRightTimeColumn();
        if (this$rightTimeColumn == null ? other$rightTimeColumn != null : !this$rightTimeColumn.equals(other$rightTimeColumn)) {
            return false;
        }
        StreamNode this$rightNode = this.getRightNode();
        StreamNode other$rightNode = other.getRightNode();
        if (this$rightNode == null ? other$rightNode != null : !((Object)this$rightNode).equals(other$rightNode)) {
            return false;
        }
        List<StreamField> this$leftJoinFields = this.getLeftJoinFields();
        List<StreamField> other$leftJoinFields = other.getLeftJoinFields();
        if (this$leftJoinFields == null ? other$leftJoinFields != null : !((Object)this$leftJoinFields).equals(other$leftJoinFields)) {
            return false;
        }
        List<StreamField> this$rightJoinFields = this.getRightJoinFields();
        List<StreamField> other$rightJoinFields = other.getRightJoinFields();
        if (this$rightJoinFields == null ? other$rightJoinFields != null : !((Object)this$rightJoinFields).equals(other$rightJoinFields)) {
            return false;
        }
        JoinerDefinition.JoinMode this$joinMode = this.getJoinMode();
        JoinerDefinition.JoinMode other$joinMode = other.getJoinMode();
        return !(this$joinMode == null ? other$joinMode != null : !((Object)((Object)this$joinMode)).equals((Object)other$joinMode));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof TemporalJoinerDefinition;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        TemporalJoinWay $temporalJoinWay = this.getTemporalJoinWay();
        result = result * 59 + ($temporalJoinWay == null ? 43 : ((Object)((Object)$temporalJoinWay)).hashCode());
        StreamNode $leftNode = this.getLeftNode();
        result = result * 59 + ($leftNode == null ? 43 : ((Object)$leftNode).hashCode());
        String $leftTimeColumn = this.getLeftTimeColumn();
        result = result * 59 + ($leftTimeColumn == null ? 43 : $leftTimeColumn.hashCode());
        String $rightTimeColumn = this.getRightTimeColumn();
        result = result * 59 + ($rightTimeColumn == null ? 43 : $rightTimeColumn.hashCode());
        StreamNode $rightNode = this.getRightNode();
        result = result * 59 + ($rightNode == null ? 43 : ((Object)$rightNode).hashCode());
        List<StreamField> $leftJoinFields = this.getLeftJoinFields();
        result = result * 59 + ($leftJoinFields == null ? 43 : ((Object)$leftJoinFields).hashCode());
        List<StreamField> $rightJoinFields = this.getRightJoinFields();
        result = result * 59 + ($rightJoinFields == null ? 43 : ((Object)$rightJoinFields).hashCode());
        JoinerDefinition.JoinMode $joinMode = this.getJoinMode();
        result = result * 59 + ($joinMode == null ? 43 : ((Object)((Object)$joinMode)).hashCode());
        return result;
    }

    public static class TemporalJoinerDefinitionBuilder {
        private TemporalJoinWay temporalJoinWay;
        private StreamNode leftNode;
        private String leftTimeColumn;
        private String rightTimeColumn;
        private StreamNode rightNode;
        private List<StreamField> leftJoinFields;
        private List<StreamField> rightJoinFields;
        private JoinerDefinition.JoinMode joinMode;

        TemporalJoinerDefinitionBuilder() {
        }

        public TemporalJoinerDefinitionBuilder temporalJoinWay(TemporalJoinWay temporalJoinWay) {
            this.temporalJoinWay = temporalJoinWay;
            return this;
        }

        public TemporalJoinerDefinitionBuilder leftNode(StreamNode leftNode) {
            this.leftNode = leftNode;
            return this;
        }

        public TemporalJoinerDefinitionBuilder leftTimeColumn(String leftTimeColumn) {
            this.leftTimeColumn = leftTimeColumn;
            return this;
        }

        public TemporalJoinerDefinitionBuilder rightTimeColumn(String rightTimeColumn) {
            this.rightTimeColumn = rightTimeColumn;
            return this;
        }

        public TemporalJoinerDefinitionBuilder rightNode(StreamNode rightNode) {
            this.rightNode = rightNode;
            return this;
        }

        public TemporalJoinerDefinitionBuilder leftJoinFields(List<StreamField> leftJoinFields) {
            this.leftJoinFields = leftJoinFields;
            return this;
        }

        public TemporalJoinerDefinitionBuilder rightJoinFields(List<StreamField> rightJoinFields) {
            this.rightJoinFields = rightJoinFields;
            return this;
        }

        public TemporalJoinerDefinitionBuilder joinMode(JoinerDefinition.JoinMode joinMode) {
            this.joinMode = joinMode;
            return this;
        }

        public TemporalJoinerDefinition build() {
            return new TemporalJoinerDefinition(this.temporalJoinWay, this.leftNode, this.leftTimeColumn, this.rightTimeColumn, this.rightNode, this.leftJoinFields, this.rightJoinFields, this.joinMode);
        }

        public String toString() {
            return "TemporalJoinerDefinition.TemporalJoinerDefinitionBuilder(temporalJoinWay=" + (Object)((Object)this.temporalJoinWay) + ", leftNode=" + this.leftNode + ", leftTimeColumn=" + this.leftTimeColumn + ", rightTimeColumn=" + this.rightTimeColumn + ", rightNode=" + this.rightNode + ", leftJoinFields=" + this.leftJoinFields + ", rightJoinFields=" + this.rightJoinFields + ", joinMode=" + (Object)((Object)this.joinMode) + ")";
        }
    }

    public static enum TemporalJoinWay {
        EVENT,
        PROCESSING;

    }

    @JsonFormat
    public static enum JoinMode {
        LEFT_JOIN,
        INNER_JOIN;

    }
}

