/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sort.protocol.node.format;

import java.util.HashMap;
import java.util.Map;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonIgnore;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonTypeName;
import org.apache.inlong.sort.protocol.node.format.CsvFormat;
import org.apache.inlong.sort.protocol.node.format.Format;

@JsonTypeName(value="inLongMsgFormat")
public class InLongMsgFormat
implements Format {
    private static final long serialVersionUID = 1L;
    private static final String IDENTIFIER = "inlong-msg";
    @JsonProperty(value="innerFormat")
    private Format innerFormat;
    @JsonProperty(value="ignoreParseErrors", defaultValue="false")
    private Boolean ignoreParseErrors;

    @JsonCreator
    public InLongMsgFormat(@JsonProperty(value="innerFormat") Format innerFormat, @JsonProperty(value="ignoreParseErrors", defaultValue="false") Boolean ignoreParseErrors) {
        this.innerFormat = innerFormat;
        this.ignoreParseErrors = ignoreParseErrors;
    }

    public InLongMsgFormat() {
        this(new CsvFormat(), false);
    }

    @Override
    @JsonIgnore
    public String getFormat() {
        return IDENTIFIER;
    }

    @Override
    public String identifier() {
        return IDENTIFIER;
    }

    @Override
    public Map<String, String> generateOptions() {
        HashMap<String, String> options = new HashMap<String, String>(16);
        options.put("format", this.getFormat());
        options.put("inlong-msg.inner.format", this.innerFormat.getFormat());
        this.innerFormat.generateOptions().entrySet().stream().filter(entry -> !"format".equals(entry.getKey())).forEach(entry -> {
            String cfr_ignored_0 = (String)options.put("inlong-msg." + (String)entry.getKey(), (String)entry.getValue());
        });
        if (this.ignoreParseErrors != null) {
            options.put("inlong-msg.ignore-parse-errors", this.ignoreParseErrors.toString());
        }
        return options;
    }

    public Format getInnerFormat() {
        return this.innerFormat;
    }

    public Boolean getIgnoreParseErrors() {
        return this.ignoreParseErrors;
    }

    public void setInnerFormat(Format innerFormat) {
        this.innerFormat = innerFormat;
    }

    public void setIgnoreParseErrors(Boolean ignoreParseErrors) {
        this.ignoreParseErrors = ignoreParseErrors;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof InLongMsgFormat)) {
            return false;
        }
        InLongMsgFormat other = (InLongMsgFormat)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$ignoreParseErrors = this.getIgnoreParseErrors();
        Boolean other$ignoreParseErrors = other.getIgnoreParseErrors();
        if (this$ignoreParseErrors == null ? other$ignoreParseErrors != null : !((Object)this$ignoreParseErrors).equals(other$ignoreParseErrors)) {
            return false;
        }
        Format this$innerFormat = this.getInnerFormat();
        Format other$innerFormat = other.getInnerFormat();
        return !(this$innerFormat == null ? other$innerFormat != null : !this$innerFormat.equals(other$innerFormat));
    }

    protected boolean canEqual(Object other) {
        return other instanceof InLongMsgFormat;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $ignoreParseErrors = this.getIgnoreParseErrors();
        result = result * 59 + ($ignoreParseErrors == null ? 43 : ((Object)$ignoreParseErrors).hashCode());
        Format $innerFormat = this.getInnerFormat();
        result = result * 59 + ($innerFormat == null ? 43 : $innerFormat.hashCode());
        return result;
    }

    public String toString() {
        return "InLongMsgFormat(innerFormat=" + this.getInnerFormat() + ", ignoreParseErrors=" + this.getIgnoreParseErrors() + ")";
    }
}

