/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sort.protocol.transformation.function;

import com.google.common.base.Preconditions;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nonnull;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonTypeName;
import org.apache.inlong.sort.protocol.transformation.Function;
import org.apache.inlong.sort.protocol.transformation.FunctionParam;

@JsonTypeName(value="addFunction")
public class AddFunction
implements Function {
    @Nonnull
    @JsonProperty(value="leftField")
    private final FunctionParam leftField;
    @Nonnull
    @JsonProperty(value="rightField")
    private final FunctionParam rightField;

    @JsonCreator
    public AddFunction(@Nonnull @JsonProperty(value="leftField") FunctionParam leftField, @Nonnull @JsonProperty(value="rightField") FunctionParam rightField) {
        this.leftField = (FunctionParam)Preconditions.checkNotNull((Object)leftField, (Object)"leftField is null");
        this.rightField = (FunctionParam)Preconditions.checkNotNull((Object)rightField, (Object)"rightField is null");
    }

    @Override
    public List<FunctionParam> getParams() {
        return Arrays.asList(this.leftField, this.rightField);
    }

    @Override
    public String getName() {
        return "+";
    }

    @Override
    public String format() {
        return String.format("%s %s %s", this.leftField.format(), this.getName(), this.rightField.format());
    }

    @Nonnull
    public FunctionParam getLeftField() {
        return this.leftField;
    }

    @Nonnull
    public FunctionParam getRightField() {
        return this.rightField;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AddFunction)) {
            return false;
        }
        AddFunction other = (AddFunction)o;
        if (!other.canEqual(this)) {
            return false;
        }
        FunctionParam this$leftField = this.getLeftField();
        FunctionParam other$leftField = other.getLeftField();
        if (this$leftField == null ? other$leftField != null : !this$leftField.equals(other$leftField)) {
            return false;
        }
        FunctionParam this$rightField = this.getRightField();
        FunctionParam other$rightField = other.getRightField();
        return !(this$rightField == null ? other$rightField != null : !this$rightField.equals(other$rightField));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AddFunction;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        FunctionParam $leftField = this.getLeftField();
        result = result * 59 + ($leftField == null ? 43 : $leftField.hashCode());
        FunctionParam $rightField = this.getRightField();
        result = result * 59 + ($rightField == null ? 43 : $rightField.hashCode());
        return result;
    }

    public String toString() {
        return "AddFunction(leftField=" + this.getLeftField() + ", rightField=" + this.getRightField() + ")";
    }
}

