/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flume.instrumentation;

import org.apache.commons.lang.ArrayUtils;
import org.apache.flume.ChannelException;
import org.apache.flume.instrumentation.MonitoredCounterGroup;
import org.apache.flume.instrumentation.SourceCounterMBean;

public class SourceCounter
extends MonitoredCounterGroup
implements SourceCounterMBean {
    private static final String COUNTER_EVENTS_RECEIVED = "src.events.received";
    private static final String COUNTER_EVENTS_ACCEPTED = "src.events.accepted";
    private static final String COUNTER_APPEND_RECEIVED = "src.append.received";
    private static final String COUNTER_APPEND_ACCEPTED = "src.append.accepted";
    private static final String COUNTER_APPEND_BATCH_RECEIVED = "src.append-batch.received";
    private static final String COUNTER_APPEND_BATCH_ACCEPTED = "src.append-batch.accepted";
    private static final String COUNTER_OPEN_CONNECTION_COUNT = "src.open-connection.count";
    private static final String COUNTER_EVENT_READ_FAIL = "src.event.read.fail";
    private static final String COUNTER_GENERIC_PROCESSING_FAIL = "src.generic.processing.fail";
    private static final String COUNTER_CHANNEL_WRITE_FAIL = "src.channel.write.fail";
    private static final String[] ATTRIBUTES = new String[]{"src.events.received", "src.events.accepted", "src.append.received", "src.append.accepted", "src.append-batch.received", "src.append-batch.accepted", "src.open-connection.count", "src.event.read.fail", "src.channel.write.fail", "src.generic.processing.fail"};

    public SourceCounter(String name) {
        super(MonitoredCounterGroup.Type.SOURCE, name, ATTRIBUTES);
    }

    public SourceCounter(String name, String[] attributes) {
        super(MonitoredCounterGroup.Type.SOURCE, name, (String[])ArrayUtils.addAll((Object[])attributes, (Object[])ATTRIBUTES));
    }

    @Override
    public long getEventReceivedCount() {
        return this.get(COUNTER_EVENTS_RECEIVED);
    }

    public long incrementEventReceivedCount() {
        return this.increment(COUNTER_EVENTS_RECEIVED);
    }

    public long addToEventReceivedCount(long delta) {
        return this.addAndGet(COUNTER_EVENTS_RECEIVED, delta);
    }

    @Override
    public long getEventAcceptedCount() {
        return this.get(COUNTER_EVENTS_ACCEPTED);
    }

    public long incrementEventAcceptedCount() {
        return this.increment(COUNTER_EVENTS_ACCEPTED);
    }

    public long addToEventAcceptedCount(long delta) {
        return this.addAndGet(COUNTER_EVENTS_ACCEPTED, delta);
    }

    @Override
    public long getAppendReceivedCount() {
        return this.get(COUNTER_APPEND_RECEIVED);
    }

    public long incrementAppendReceivedCount() {
        return this.increment(COUNTER_APPEND_RECEIVED);
    }

    @Override
    public long getAppendAcceptedCount() {
        return this.get(COUNTER_APPEND_ACCEPTED);
    }

    public long incrementAppendAcceptedCount() {
        return this.increment(COUNTER_APPEND_ACCEPTED);
    }

    @Override
    public long getAppendBatchReceivedCount() {
        return this.get(COUNTER_APPEND_BATCH_RECEIVED);
    }

    public long incrementAppendBatchReceivedCount() {
        return this.increment(COUNTER_APPEND_BATCH_RECEIVED);
    }

    @Override
    public long getAppendBatchAcceptedCount() {
        return this.get(COUNTER_APPEND_BATCH_ACCEPTED);
    }

    public long incrementAppendBatchAcceptedCount() {
        return this.increment(COUNTER_APPEND_BATCH_ACCEPTED);
    }

    @Override
    public long getOpenConnectionCount() {
        return this.get(COUNTER_OPEN_CONNECTION_COUNT);
    }

    public void setOpenConnectionCount(long openConnectionCount) {
        this.set(COUNTER_OPEN_CONNECTION_COUNT, openConnectionCount);
    }

    public long incrementEventReadFail() {
        return this.increment(COUNTER_EVENT_READ_FAIL);
    }

    @Override
    public long getEventReadFail() {
        return this.get(COUNTER_EVENT_READ_FAIL);
    }

    public long incrementChannelWriteFail() {
        return this.increment(COUNTER_CHANNEL_WRITE_FAIL);
    }

    @Override
    public long getChannelWriteFail() {
        return this.get(COUNTER_CHANNEL_WRITE_FAIL);
    }

    public long incrementGenericProcessingFail() {
        return this.increment(COUNTER_GENERIC_PROCESSING_FAIL);
    }

    @Override
    public long getGenericProcessingFail() {
        return this.get(COUNTER_GENERIC_PROCESSING_FAIL);
    }

    public long incrementEventReadOrChannelFail(Throwable t) {
        if (t instanceof ChannelException) {
            return this.incrementChannelWriteFail();
        }
        return this.incrementEventReadFail();
    }
}

