/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flume.netty.filter;

import io.netty.handler.ipfilter.IpFilterRule;
import io.netty.handler.ipfilter.IpFilterRuleType;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PatternRule
implements IpFilterRule {
    private static final Logger logger = LoggerFactory.getLogger(PatternRule.class);
    private static final String LOCALHOST = "127.0.0.1";
    private final IpFilterRuleType ruleType;
    private Pattern ipPattern;
    private Pattern namePattern;
    private boolean localhost;

    public PatternRule(IpFilterRuleType ruleType, String pattern) {
        this.ruleType = ruleType;
        this.parse(pattern);
    }

    private static String addRule(String pattern, String rule) {
        if (rule == null || rule.length() == 0) {
            return pattern;
        }
        if (pattern.length() != 0) {
            pattern = pattern + "|";
        }
        rule = rule.replaceAll("\\.", "\\\\.");
        rule = rule.replaceAll("\\*", ".*");
        rule = rule.replaceAll("\\?", ".");
        pattern = pattern + '(' + rule + ')';
        return pattern;
    }

    private static boolean isLocalhost(InetAddress address) {
        block7: {
            block6: {
                try {
                    if (address.equals(InetAddress.getLocalHost())) {
                        return true;
                    }
                }
                catch (UnknownHostException e) {
                    if (!logger.isInfoEnabled()) break block6;
                    logger.info("error getting ip of localhost", (Throwable)e);
                }
            }
            try {
                InetAddress[] addrs;
                for (InetAddress addr : addrs = InetAddress.getAllByName(LOCALHOST)) {
                    if (!addr.equals(address)) continue;
                    return true;
                }
            }
            catch (UnknownHostException e) {
                if (!logger.isInfoEnabled()) break block7;
                logger.info("error getting ip of localhost", (Throwable)e);
            }
        }
        return false;
    }

    public boolean matches(InetSocketAddress inetSocketAddress) {
        InetAddress inetAddress = inetSocketAddress.getAddress();
        if (this.localhost && PatternRule.isLocalhost(inetAddress)) {
            return true;
        }
        if (this.ipPattern != null && this.ipPattern.matcher(inetAddress.getHostAddress()).matches()) {
            return true;
        }
        if (this.namePattern != null) {
            return this.namePattern.matcher(inetAddress.getHostName()).matches();
        }
        return false;
    }

    public IpFilterRuleType ruleType() {
        return this.ruleType;
    }

    private void parse(String pattern) {
        if (pattern == null) {
            return;
        }
        String[] acls = pattern.split(",");
        String ip = "";
        String name = "";
        for (String c : acls) {
            if ("n:localhost".equals(c = c.trim())) {
                this.localhost = true;
                continue;
            }
            if (c.startsWith("n:")) {
                name = PatternRule.addRule(name, c.substring(2));
                continue;
            }
            if (!c.startsWith("i:")) continue;
            ip = PatternRule.addRule(ip, c.substring(2));
        }
        if (ip.length() != 0) {
            this.ipPattern = Pattern.compile(ip);
        }
        if (name.length() != 0) {
            this.namePattern = Pattern.compile(name);
        }
    }
}

