/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.operators.rank;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.state.MapState;
import org.apache.flink.api.common.state.MapStateDescriptor;
import org.apache.flink.api.common.state.StateTtlConfig;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.java.typeutils.ListTypeInfo;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.shaded.guava30.com.google.common.cache.Cache;
import org.apache.flink.shaded.guava30.com.google.common.cache.CacheBuilder;
import org.apache.flink.streaming.api.functions.KeyedProcessFunction;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.runtime.generated.GeneratedRecordComparator;
import org.apache.flink.table.runtime.keyselector.RowDataKeySelector;
import org.apache.flink.table.runtime.operators.rank.AbstractTopNFunction;
import org.apache.flink.table.runtime.operators.rank.RankRange;
import org.apache.flink.table.runtime.operators.rank.RankType;
import org.apache.flink.table.runtime.operators.rank.TopNBuffer;
import org.apache.flink.table.runtime.typeutils.InternalTypeInfo;
import org.apache.flink.util.Collector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AppendOnlyTopNFunction
extends AbstractTopNFunction {
    private static final long serialVersionUID = -4708453213104128011L;
    private static final Logger LOG = LoggerFactory.getLogger(AppendOnlyTopNFunction.class);
    private final InternalTypeInfo<RowData> sortKeyType;
    private final TypeSerializer<RowData> inputRowSer;
    private final long cacheSize;
    private transient MapState<RowData, List<RowData>> dataState;
    private transient TopNBuffer buffer;
    private transient Cache<RowData, TopNBuffer> kvSortedMap;

    public AppendOnlyTopNFunction(StateTtlConfig ttlConfig, InternalTypeInfo<RowData> inputRowType, GeneratedRecordComparator sortKeyGeneratedRecordComparator, RowDataKeySelector sortKeySelector, RankType rankType, RankRange rankRange, boolean generateUpdateBefore, boolean outputRankNumber, long cacheSize) {
        super(ttlConfig, inputRowType, sortKeyGeneratedRecordComparator, sortKeySelector, rankType, rankRange, generateUpdateBefore, outputRankNumber);
        this.sortKeyType = sortKeySelector.getProducedType();
        this.inputRowSer = inputRowType.createSerializer(new ExecutionConfig());
        this.cacheSize = cacheSize;
    }

    @Override
    public void open(Configuration parameters) throws Exception {
        super.open(parameters);
        int lruCacheSize = Math.max(1, (int)(this.cacheSize / this.getDefaultTopNSize()));
        CacheBuilder cacheBuilder = CacheBuilder.newBuilder();
        if (this.ttlConfig.isEnabled()) {
            cacheBuilder.expireAfterWrite(this.ttlConfig.getTtl().toMilliseconds(), TimeUnit.MILLISECONDS);
        }
        this.kvSortedMap = cacheBuilder.maximumSize((long)lruCacheSize).build();
        LOG.info("Top{} operator is using LRU caches key-size: {}", (Object)this.getDefaultTopNSize(), (Object)lruCacheSize);
        ListTypeInfo valueTypeInfo = new ListTypeInfo((TypeInformation)this.inputRowType);
        MapStateDescriptor mapStateDescriptor = new MapStateDescriptor("data-state-with-append", this.sortKeyType, (TypeInformation)valueTypeInfo);
        if (this.ttlConfig.isEnabled()) {
            mapStateDescriptor.enableTimeToLive(this.ttlConfig);
        }
        this.dataState = this.getRuntimeContext().getMapState(mapStateDescriptor);
        this.registerMetric(this.kvSortedMap.size() * this.getDefaultTopNSize());
    }

    public void processElement(RowData input, KeyedProcessFunction.Context context, Collector<RowData> out) throws Exception {
        this.initHeapStates();
        this.initRankEnd(input);
        RowData sortKey = (RowData)this.sortKeySelector.getKey((Object)input);
        if (this.checkSortKeyInBufferRange(sortKey, this.buffer)) {
            this.buffer.put(sortKey, (RowData)this.inputRowSer.copy((Object)input));
            Collection<RowData> inputs = this.buffer.get(sortKey);
            this.dataState.put((Object)sortKey, new ArrayList<RowData>(inputs));
            if (this.outputRankNumber || this.hasOffset()) {
                this.processElementWithRowNumber(sortKey, input, out);
            } else {
                this.processElementWithoutRowNumber(input, out);
            }
        }
    }

    private void initHeapStates() throws Exception {
        ++this.requestCount;
        RowData currentKey = (RowData)this.keyContext.getCurrentKey();
        this.buffer = (TopNBuffer)this.kvSortedMap.getIfPresent((Object)currentKey);
        if (this.buffer == null) {
            this.buffer = new TopNBuffer(this.sortKeyComparator, ArrayList::new);
            this.kvSortedMap.put((Object)currentKey, (Object)this.buffer);
            Iterator iter = this.dataState.iterator();
            if (iter != null) {
                while (iter.hasNext()) {
                    Map.Entry entry = (Map.Entry)iter.next();
                    RowData sortKey = (RowData)entry.getKey();
                    List values = (List)entry.getValue();
                    this.buffer.putAll(sortKey, values);
                }
            }
        } else {
            ++this.hitCount;
        }
    }

    private void processElementWithRowNumber(RowData sortKey, RowData input, Collector<RowData> out) throws Exception {
        Iterator<Map.Entry<RowData, Collection<RowData>>> iterator = this.buffer.entrySet().iterator();
        long currentRank = 0L;
        boolean findsSortKey = false;
        RowData currentRow = null;
        while (iterator.hasNext() && this.isInRankEnd(currentRank)) {
            Map.Entry<RowData, Collection<RowData>> entry = iterator.next();
            Collection<RowData> records = entry.getValue();
            if (!findsSortKey && entry.getKey().equals(sortKey)) {
                currentRank += (long)records.size();
                currentRow = input;
                findsSortKey = true;
                continue;
            }
            if (findsSortKey) {
                Iterator<RowData> recordsIter = records.iterator();
                while (recordsIter.hasNext() && this.isInRankEnd(currentRank)) {
                    RowData prevRow = recordsIter.next();
                    this.collectUpdateBefore(out, prevRow, currentRank);
                    this.collectUpdateAfter(out, currentRow, currentRank);
                    currentRow = prevRow;
                    ++currentRank;
                }
                continue;
            }
            currentRank += (long)records.size();
        }
        if (this.isInRankEnd(currentRank)) {
            this.collectInsert(out, currentRow, currentRank);
        }
        ArrayList<RowData> toDeleteSortKeys = new ArrayList<RowData>();
        while (iterator.hasNext()) {
            Map.Entry<RowData, Collection<RowData>> entry = iterator.next();
            RowData key = entry.getKey();
            this.dataState.remove((Object)key);
            toDeleteSortKeys.add(key);
        }
        for (RowData toDeleteKey : toDeleteSortKeys) {
            this.buffer.removeAll(toDeleteKey);
        }
    }

    private void processElementWithoutRowNumber(RowData input, Collector<RowData> out) throws Exception {
        if ((long)this.buffer.getCurrentTopNum() > this.rankEnd) {
            Map.Entry<RowData, Collection<RowData>> lastEntry = this.buffer.lastEntry();
            RowData lastKey = lastEntry.getKey();
            Collection<RowData> lastList = lastEntry.getValue();
            RowData lastElement = this.buffer.lastElement();
            int size = lastList.size();
            if (size <= 1) {
                this.buffer.removeAll(lastKey);
                this.dataState.remove((Object)lastKey);
            } else {
                this.buffer.removeLast();
                this.dataState.put((Object)lastKey, new ArrayList<RowData>(lastList));
            }
            if (size == 0 || input.equals(lastElement)) {
                return;
            }
            this.collectDelete(out, lastElement);
        }
        this.collectInsert(out, input);
    }
}

