/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.types.converters;

import java.util.Locale;
import org.datanucleus.store.types.converters.ColumnLengthDefiningTypeConverter;
import org.datanucleus.store.types.converters.TypeConverter;
import org.datanucleus.util.I18nUtils;

public class LocaleStringConverter
implements TypeConverter<Locale, String>,
ColumnLengthDefiningTypeConverter {
    private static final long serialVersionUID = -5566584819761013454L;

    @Override
    public Locale toMemberType(String str) {
        if (str == null) {
            return null;
        }
        return I18nUtils.getLocaleFromString(str);
    }

    @Override
    public String toDatastoreType(Locale loc) {
        return loc != null ? loc.toString() : null;
    }

    @Override
    public int getDefaultColumnLength(int columnPosition) {
        if (columnPosition != 0) {
            return -1;
        }
        return 20;
    }
}

