/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.common.auth;

import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Map;
import org.apache.inlong.manager.common.auth.Authentication;
import org.apache.inlong.manager.common.auth.SecretAuthentication;
import org.apache.inlong.manager.common.util.JsonTypeDefine;
import org.apache.inlong.manager.common.util.JsonUtils;

@JsonTypeDefine(value="secret_token")
public class SecretTokenAuthentication
extends SecretAuthentication {
    public static final String SECRET_TOKEN = "secret_token";
    protected String sToken;

    public SecretTokenAuthentication(String secretId, String secretKey, String secretToken) {
        this.secretId = secretId;
        this.secretKey = secretKey;
        this.sToken = secretToken;
    }

    @Override
    public Authentication.AuthType getAuthType() {
        return Authentication.AuthType.SECRET_AND_TOKEN;
    }

    @Override
    public void configure(Map<String, String> properties) {
        super.configure(properties);
        this.sToken = properties.get(SECRET_TOKEN);
    }

    @Override
    public String toString() {
        ObjectNode objectNode = JsonUtils.OBJECT_MAPPER.createObjectNode();
        objectNode.put("secret_id", this.getSecretId());
        objectNode.put("secret_key", this.getSecretKey());
        objectNode.put(SECRET_TOKEN, this.getSToken());
        return objectNode.toString();
    }

    public SecretTokenAuthentication() {
    }

    public String getSToken() {
        return this.sToken;
    }
}

