/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.common.enums;

import java.util.Locale;

public enum DataFormat {
    CSV("csv"),
    AVRO("avro"),
    CANAL("canal"),
    JSON("json"),
    DEBEZIUM_JSON("debezium_json"),
    RAW("raw"),
    NONE("none");

    private final String name;

    private DataFormat(String name) {
        this.name = name;
    }

    public static DataFormat forName(String name) {
        for (DataFormat dataFormat : DataFormat.values()) {
            if (!dataFormat.getName().equals(name.toLowerCase(Locale.ROOT))) continue;
            return dataFormat;
        }
        throw new IllegalArgumentException(String.format("Unsupported data format for %s", name));
    }

    public String getName() {
        return this.name;
    }
}

